/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xunlei.channel.api.basechannel.constants.Constants;
import com.xunlei.channel.api.basechannel.entity.Biz;
import com.xunlei.channel.api.basechannel.entity.BizQueryRequest;
import com.xunlei.channel.api.basechannel.entity.ChannelBusiness;
import com.xunlei.channel.api.basechannel.service.AccountCacheService;
import com.xunlei.channel.api.basechannel.service.BizService;
import com.xunlei.channel.api.basechannel.service.ChannelBusinessService;
import com.xunlei.channel.api.basechannel.service.CommonService;
import com.xunlei.channel.api.basechannel.service.SignUtilsService;
import com.xunlei.channel.api.basechannel.utils.ChannelBusinessMapperUtil;
import com.xunlei.channel.api.entity.JsonResult;
import com.xunlei.channel.api.entity.ReturnResult;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/basechannel/biz"}, produces={"text/html;charset=UTF-8"})
public class BizController {
    private static final Logger logger = LoggerFactory.getLogger(BizController.class);
    @Autowired
    private BizService bizService;
    @Autowired
    private SignUtilsService signUtilsService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private ChannelBusinessService channelBusinessService;
    @Autowired
    private AccountCacheService accountCacheService;

    @RequestMapping(value={"/query"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    public String query(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        BizQueryRequest data = (BizQueryRequest)JSON.parseObject((String)json, BizQueryRequest.class);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        logger.info("\u4e1a\u52a1\u67e5\u8be2\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            List<Biz> result = this.bizService.query(data);
            return JsonResult.getResult(result);
        }
        catch (Exception e) {
            logger.info("AccountController.delete error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
    }

    @RequestMapping(value={"/insert"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    public String insert(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        BizQueryRequest data = (BizQueryRequest)JSON.parseObject((String)json, BizQueryRequest.class);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        logger.info("\u4e1a\u52a1\u65b0\u589e\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        int insert = 0;
        try {
            List<Biz> bizList = this.bizService.findBusiess(data);
            if (bizList.size() > 0) {
                return JsonResult.getResult((int)ReturnResult.DATA_ALREADY_EXISTS.getCode(), (String)ReturnResult.DATA_ALREADY_EXISTS.getMessage(), (String)("\u4e1a\u52a1\u540d\u79f0\uff1a" + data.getBizName() + ReturnResult.DATA_ALREADY_EXISTS.getDescribe()), null);
            }
            String businessNo = this.commonService.getCommonNo(Constants.COLUMN_BUSINESS_NO, Constants.TABLE_NAME_BUSINESS);
            data.setBizNo("000001" + businessNo.substring(businessNo.length() - 3, businessNo.length()));
            insert = this.bizService.insert(data);
        }
        catch (Exception e) {
            logger.info("AccountController.delete error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (insert > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)"\u65b0\u589e\u6210\u529f");
        }
        return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String delete(@RequestBody String jsonStr) {
        int delete = 0;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        List list = JSON.parseArray((String)json, BizQueryRequest.class);
        logger.info("\u4e1a\u52a1\u5220\u9664\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            for (BizQueryRequest result : list) {
                delete = this.bizService.delete(result);
            }
        }
        catch (Exception e) {
            logger.info("AccountController.delete error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (delete > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)ReturnResult.SUCCESS);
        }
        return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String update(@RequestBody String jsonStr) {
        int update;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        BizQueryRequest data = (BizQueryRequest)JSON.parseObject((String)json, BizQueryRequest.class);
        logger.info("\u4e1a\u52a1\u4fee\u6539\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            List<Biz> bizList;
            List<Biz> bizs = this.bizService.findBizByBizNo(data.getBizNo());
            if (!data.getBizLineNo().equals(bizs.get(0).getBizLineNo())) {
                ChannelBusiness channelBusiness = new ChannelBusiness();
                channelBusiness.setBizNo(data.getBizNo());
                this.channelBusinessService.deleteByNo(channelBusiness);
            }
            if ((bizList = this.bizService.findBusiess(data)).size() != 0) {
                if (bizList.get(0).getRemark().equals(data.getRemark()) && bizList.get(0).getBizStatus().equals(data.getBizStatus()) && bizList.get(0).getType().equals(data.getType()) && bizList.get(0).getBizLineNo().equals(data.getBizLineNo()) && bizList.get(0).getContactName().equals(data.getContactName()) && bizList.get(0).getContactPhone().equals(data.getContactPhone())) {
                    if (!bizList.get(0).getBizNo().equals(data.getBizNo())) {
                        return JsonResult.getResult((int)1, (String)"", (String)("\u4e1a\u52a1\u540d\u79f0\uff1a " + data.getBizName() + " \u5df2\u5b58\u5728"), (Object)("\u4e1a\u52a1\u540d\u79f0\uff1a " + data.getBizName() + "\u5df2\u5b58\u5728"));
                    }
                    update = 1;
                } else {
                    if (!bizList.get(0).getBizNo().equals(data.getBizNo())) {
                        return JsonResult.getResult((int)1, (String)"", (String)("\u4e1a\u52a1\u540d\u79f0\uff1a " + data.getBizName() + " \u5df2\u5b58\u5728"), (Object)("\u4e1a\u52a1\u540d\u79f0\uff1a " + data.getBizName() + "\u5df2\u5b58\u5728"));
                    }
                    update = this.bizService.update(data);
                }
            } else {
                update = this.bizService.update(data);
            }
        }
        catch (Exception e) {
            logger.info("BizController.update error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (update > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)ReturnResult.SUCCESS);
        }
        return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
    }

    @RequestMapping(value={"/updatestatus"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String updateStatus(@RequestBody String jsonStr) {
        int updateStatus = 0;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        List list = JSON.parseArray((String)json, BizQueryRequest.class);
        logger.info("\u4e1a\u52a1\u505c\u7528\u542f\u7528\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            for (BizQueryRequest result : list) {
                List<ChannelBusiness> channelBusinessList;
                updateStatus = this.bizService.updateStatus(result);
                ChannelBusiness channelBiz = new ChannelBusiness();
                channelBiz.setBizNo(result.getBizNo());
                if (result.getBizStatus().equals("N")) {
                    channelBusinessList = this.channelBusinessService.queryByNo(channelBiz);
                    if (channelBusinessList.size() <= 0) continue;
                    channelBiz.setBizStatus("N");
                    this.channelBusinessService.updateStatus(channelBiz);
                    continue;
                }
                channelBiz.setBizStatus("N");
                channelBusinessList = this.channelBusinessService.queryByNo(channelBiz);
                if (channelBusinessList.size() <= 0) continue;
                for (ChannelBusiness channelBusiness : channelBusinessList) {
                    channelBusiness.setBizStatus("Y");
                    this.channelBusinessService.updateStatus(channelBusiness);
                }
            }
            List<String> bizNos = list.stream().map(BizQueryRequest::getBizNo).filter(Objects::nonNull).collect(Collectors.toList());
            List<ChannelBusiness> channelBusinesses = this.channelBusinessService.queryByBizNo(bizNos);
            this.accountCacheService.updateAccountList(ChannelBusinessMapperUtil.map(channelBusinesses));
        }
        catch (Exception e) {
            logger.info("AccountController.updatestatus error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (updateStatus > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)ReturnResult.SUCCESS);
        }
        return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
    }
}

