/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xunlei.channel.api.basechannel.constants.Constants;
import com.xunlei.channel.api.basechannel.entity.Account;
import com.xunlei.channel.api.basechannel.entity.AccountQueryRequest;
import com.xunlei.channel.api.basechannel.entity.ChannelBusiness;
import com.xunlei.channel.api.basechannel.service.AccountCacheService;
import com.xunlei.channel.api.basechannel.service.AccountService;
import com.xunlei.channel.api.basechannel.service.ChannelBusinessService;
import com.xunlei.channel.api.basechannel.service.CommonService;
import com.xunlei.channel.api.basechannel.service.SignUtilsService;
import com.xunlei.channel.api.basechannel.utils.ChannelBusinessMapperUtil;
import com.xunlei.channel.api.entity.JsonResult;
import com.xunlei.channel.api.entity.ReturnResult;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/basechannel/account"}, produces={"text/html;charset=UTF-8"})
public class AccountController {
    private static final Logger logger = LoggerFactory.getLogger(AccountController.class);
    @Autowired
    private AccountService accountService;
    @Autowired
    private SignUtilsService signUtilsService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private ChannelBusinessService channelBusinessService;
    @Autowired
    private AccountCacheService accountCacheService;

    @RequestMapping(value={"/query"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    public String query(@RequestBody String jsonStr) {
        logger.info("\u8d26\u6237\u67e5\u8be2\u5b57\u7b26\u4e32\uff1a" + jsonStr);
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        AccountQueryRequest data = (AccountQueryRequest)JSON.parseObject((String)json, AccountQueryRequest.class);
        logger.info("\u8d26\u6237\u65b0\u589e\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            List<Account> result = this.accountService.query(data);
            return JsonResult.getResult(result);
        }
        catch (Exception e) {
            logger.info("AccountController.delete error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
    }

    @RequestMapping(value={"/insert"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String insert(@RequestBody String jsonStr) {
        int insert;
        logger.info("\u8d26\u6237\u65b0\u589e\u5b57\u7b26\u4e32\uff1a" + jsonStr);
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        AccountQueryRequest data = (AccountQueryRequest)JSON.parseObject((String)json, AccountQueryRequest.class);
        logger.info("\u8d26\u6237\u65b0\u589e\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        AccountQueryRequest accountQueryRequest = new AccountQueryRequest();
        accountQueryRequest.setProviderNo(data.getProviderNo());
        accountQueryRequest.setAccountName(data.getAccountName());
        List<Account> accountList = this.accountService.findAccount(accountQueryRequest);
        try {
            if (accountList.size() > 0) {
                return JsonResult.getResult((int)1, (String)"", (String)("\u6240\u9009\u670d\u52a1\u5546\u4e0b\u5df2\u5b58\u5728\u8d26\u6237\uff1a" + data.getAccountName()), (Object)("\u670d\u52a1\u5546\uff1a " + data.getProviderNo() + "\u5df2\u5b58\u5728\u8d26\u6237\uff1a" + data.getAccountName()));
            }
            String accountNo = this.commonService.getCommonNo(Constants.COLUMN_ACCOUINT_NO, Constants.TABLE_NAME_ACCOUNT);
            data.setAccountNo(accountNo);
            insert = this.accountService.insert(data);
        }
        catch (Exception e) {
            logger.info("AccountController.insert error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (insert > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)"\u65b0\u589e\u6210\u529f");
        }
        return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String delete(@RequestBody String jsonStr) {
        int delete = 0;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        List list = JSON.parseArray((String)json, AccountQueryRequest.class);
        logger.info("\u8d26\u6237\u5220\u9664\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            for (AccountQueryRequest result : list) {
                delete = this.accountService.delete(result);
            }
        }
        catch (Exception e) {
            logger.info("AccountController.delete error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (delete > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)ReturnResult.SUCCESS);
        }
        return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String update(@RequestBody String jsonStr) {
        int update;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        AccountQueryRequest data = (AccountQueryRequest)JSON.parseObject((String)json, AccountQueryRequest.class);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        AccountQueryRequest accountQueryRequest = new AccountQueryRequest();
        accountQueryRequest.setProviderNo(data.getProviderNo());
        accountQueryRequest.setAccountName(data.getAccountName());
        List<Account> accountList = this.accountService.findAccount(accountQueryRequest);
        try {
            if (accountList.size() != 0) {
                if (accountList.get(0).getRemark().equals(data.getRemark()) && accountList.get(0).getIsUse().equals(data.getIsUse()) && accountList.get(0).getCashAccount().equals(data.getCashAccount()) && accountList.get(0).getSettlementCycle().equals(data.getSettlementCycle()) && accountList.get(0).getSignBodyNo().equals(data.getSignBodyNo())) {
                    if (!accountList.get(0).getAccountNo().equals(data.getAccountNo()) || !accountList.get(0).getProviderNo().equals(data.getProviderNo())) {
                        return JsonResult.getResult((int)1, (String)"", (String)"", (Object)("\u670d\u52a1\u5546\uff1a " + data.getProviderNo() + "\u5df2\u5b58\u5728\u8d26\u6237\uff1a" + data.getAccountName()));
                    }
                    update = 1;
                } else {
                    if (!accountList.get(0).getAccountNo().equals(data.getAccountNo())) {
                        return JsonResult.getResult((int)1, (String)"", (String)("\u6240\u9009\u670d\u52a1\u5546\u4e0b\u5df2\u5b58\u5728\u8d26\u6237\uff1a" + data.getAccountName()), (Object)("\u670d\u52a1\u5546\uff1a " + data.getProviderNo() + "\u5df2\u5b58\u5728\u8d26\u6237\uff1a" + data.getAccountName()));
                    }
                    update = this.accountService.update(data);
                }
            } else {
                update = this.accountService.update(data);
            }
        }
        catch (Exception e) {
            logger.info("AccountController.update error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (update > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)ReturnResult.SUCCESS);
        }
        return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
    }

    @RequestMapping(value={"/updatestatus"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String updateStatus(@RequestBody String jsonStr) {
        int updateStatus = 0;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        List list = JSON.parseArray((String)json, AccountQueryRequest.class);
        logger.info("\u8d26\u6237\u505c\u7528\u542f\u7528\u63a5\u6536\u7684\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            for (AccountQueryRequest result : list) {
                List<ChannelBusiness> channelBusinessList;
                ChannelBusiness channelBizQuery = new ChannelBusiness();
                channelBizQuery.setAccountNo(result.getAccountNo());
                if (result.getIsUse().equals("N")) {
                    channelBusinessList = this.channelBusinessService.queryByNo(channelBizQuery);
                    if (channelBusinessList.size() > 0) {
                        channelBizQuery.setAccountStatus("N");
                        this.channelBusinessService.updateStatus(channelBizQuery);
                    }
                } else {
                    channelBizQuery.setAccountStatus("N");
                    channelBusinessList = this.channelBusinessService.queryByNo(channelBizQuery);
                    if (channelBusinessList.size() > 0) {
                        for (ChannelBusiness channelBusiness : channelBusinessList) {
                            channelBusiness.setAccountStatus("Y");
                            this.channelBusinessService.updateStatus(channelBusiness);
                        }
                    }
                }
                updateStatus = this.accountService.updateStatus(result);
            }
            List<String> accountNos = list.stream().map(AccountQueryRequest::getAccountNo).filter(Objects::nonNull).collect(Collectors.toList());
            List<ChannelBusiness> channelBusinesses = this.channelBusinessService.queryByAccountNo(accountNos);
            this.accountCacheService.updateAccountList(ChannelBusinessMapperUtil.map(channelBusinesses));
        }
        catch (Exception e) {
            logger.info("AccountController.updatestatus error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (updateStatus > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)ReturnResult.SUCCESS);
        }
        return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
    }
}

