/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.agreement.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger logger = LoggerFactory.getLogger(CommonUtils.class);

    public static List<String> getMonthBetween(String beginDate, String endDate) throws ParseException {
        SimpleDateFormat sdfs = new SimpleDateFormat("yyyy-MM-dd");
        Date minDate = sdfs.parse(beginDate);
        Date maxDate = sdfs.parse(endDate);
        ArrayList<String> result = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        min.setTime(minDate);
        min.set(min.get(1), min.get(2), min.get(5));
        max.setTime(maxDate);
        max.set(max.get(1), max.get(2), max.get(5));
        Calendar curr = min;
        while (curr.before(max) && now.get(1) != curr.get(1)) {
            result.add(sdf.format(curr.getTime()));
            curr.add(1, 1);
        }
        return result;
    }

    public static List<String> getTables4Bizorder(String fromDate, String toDate) throws ParseException {
        String[] table = new String[]{"bizorder_2012Q3", "bizorder_2012Q4", "bizorder_2013Q1", "bizorder_2013Q2", "bizorder_2013Q3", "bizorder_2013Q4", "bizorder_2014Q1", "bizorder_2014Q2", "bizorder_2014Q3", "bizorder_2014Q4"};
        table = CommonUtils.getTable(table, toDate, "bizorder");
        String before7Date = CommonUtils.addDate(null, "D", -30);
        ArrayList<String> tables = new ArrayList<String>();
        if (fromDate.compareTo(before7Date) >= 0) {
            tables.add("bizorder");
            return tables;
        }
        if (toDate.compareTo(before7Date) >= 0) {
            tables.add("bizorder");
        }
        int start = CommonUtils.indexOfTable(table, fromDate, "bizorder");
        int end = CommonUtils.indexOfTable(table, toDate, "bizorder");
        for (int index = start; index <= end; ++index) {
            tables.add(table[index]);
        }
        return tables;
    }

    public static String addDate(String date1, String addpart, int num) {
        return CommonUtils.addTime(date1, addpart, num).substring(0, 10);
    }

    public static String addTime(String time1, String addpart, int num) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String now = sdf.format(new Date());
            String string = time1 = time1 == null ? now : time1;
            if (time1.length() < 19) {
                time1 = time1 + " 00:00:00";
            }
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(sdf.parse(time1));
            if (addpart.equalsIgnoreCase("Y")) {
                cal.add(1, num);
            } else if (addpart.equalsIgnoreCase("M")) {
                cal.add(2, num);
            } else if (addpart.equalsIgnoreCase("D")) {
                cal.add(5, num);
            } else if (addpart.equalsIgnoreCase("H")) {
                cal.add(10, num);
            } else if (addpart.equalsIgnoreCase("F")) {
                cal.add(12, num);
            } else if (addpart.equalsIgnoreCase("S")) {
                cal.add(13, num);
            }
            return sdf.format(cal.getTime());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static int indexOfTable(String[] table, String date, String tableNamePrefix) throws ParseException {
        String quarter = CommonUtils.getQuarterTable(date);
        if ("2012Q3".compareTo(quarter) > 0) {
            quarter = "2012Q3";
        }
        int index = 0;
        String tableName = tableNamePrefix + "_" + quarter;
        for (String tb : table) {
            if (tableName.equals(tb)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static String[] getTable(String[] table, String date, String name) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        String[] newTable = null;
        try {
            calendar.setTime(format.parse(date));
            int year = calendar.get(1);
            int length = table.length;
            int i = year - 2014;
            newTable = new String[length + i * 4];
            for (int k = 0; k < length; ++k) {
                newTable[k] = table[k];
            }
            int index = length;
            String tableName = null;
            for (int z = 1; z <= i; ++z) {
                for (int j = 1; j <= 4; ++j) {
                    newTable[index] = tableName = name + "_" + (2014 + z) + "Q" + j;
                    ++index;
                }
            }
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
        }
        return newTable;
    }

    public static String getQuarterTable(String date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(format.parse(date));
        int year = calendar.get(1);
        int month = calendar.get(2);
        if (month >= 0 && month <= 2) {
            return year + "Q1";
        }
        if (month >= 3 && month <= 5) {
            return year + "Q2";
        }
        if (month >= 6 && month <= 8) {
            return year + "Q3";
        }
        if (month >= 9 && month <= 11) {
            return year + "Q4";
        }
        return "";
    }

    public static List<String> getTables4BizorderOk(String fromDate, String toDate) throws ParseException {
        String[] table = new String[]{"bizorderok_2010Q1", "bizorderok_2010Q2", "bizorderok_2010Q3", "bizorderok_2010Q4", "bizorderok_2011Q1", "bizorderok_2011Q2", "bizorderok_2011Q3", "bizorderok_2011Q4", "bizorderok_2012Q1", "bizorderok_2012Q2", "bizorderok_2012Q3", "bizorderok_2012Q4", "bizorderok_2013Q1", "bizorderok_2013Q2", "bizorderok_2013Q3", "bizorderok_2013Q4", "bizorderok_2014Q1", "bizorderok_2014Q2", "bizorderok_2014Q3", "bizorderok_2014Q4"};
        table = CommonUtils.getTable(table, toDate, "bizorderok");
        String before7Date = CommonUtils.addDate(null, "D", -7);
        ArrayList<String> tables = new ArrayList<String>();
        if (fromDate.compareTo(before7Date) >= 0) {
            tables.add("bizorderok");
            return tables;
        }
        if (toDate.compareTo(before7Date) >= 0) {
            tables.add("bizorderok");
        }
        int start = CommonUtils.indexOfTable(table, fromDate, "bizorderok");
        int end = CommonUtils.indexOfTable(table, toDate, "bizorderok");
        for (int index = start; index <= end; ++index) {
            tables.add(table[index]);
        }
        return tables;
    }
}

