/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.agreement.query;

import com.xunlei.channel.api.agreement.builder.BuilderUtils;
import com.xunlei.channel.api.agreement.dao.AgreementDao;
import com.xunlei.channel.api.agreement.entity.Agreement;
import com.xunlei.channel.api.agreement.entity.AgreementQueryRequest;
import com.xunlei.channel.api.agreement.entity.AgreementResult;
import com.xunlei.channel.api.agreement.query.AgreementQuery;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgreementQueryService
implements AgreementQuery {
    private static final Logger logger = LoggerFactory.getLogger(AgreementQueryService.class);
    @Autowired
    private AgreementDao agreementDao;

    @Override
    public Map<String, AgreementResult> queryAgreement(AgreementQueryRequest query) {
        return this.agreementDao.queryAgreement(query);
    }

    public Map<String, Agreement> construct(AgreementQueryRequest query, String payType) {
        query.setPayType(payType);
        return this.getResultMap(query);
    }

    public Map<String, Agreement> getResultMap(AgreementQueryRequest query) {
        Agreement json;
        boolean haveKey;
        TreeMap<String, Agreement> resultMap = new TreeMap<String, Agreement>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.compareTo(o1);
            }
        });
        List<Object> list1 = new ArrayList();
        List<Object> list2 = new ArrayList();
        List<Object> list3 = new ArrayList();
        List<Object> list4 = new ArrayList();
        if (query.getPayType().equals("AM")) {
            list1 = this.queryExtAlipayMonthReqCount(query);
            list2 = this.queryExtAlipayMonthOkCount(query);
            list3 = this.queryAutoPayNewCount(query);
            list4 = this.queryAutoPayCancelNewCount(query);
        } else if (query.getPayType().equals("W5")) {
            list1 = this.queryExtWechatMonthReqCount(query);
            list2 = this.queryExtWechatMonthOkCount(query);
            list3 = this.queryAutoPayNewCount(query);
            list4 = this.queryAutoPayCancelNewCount(query);
        } else if (query.getPayType().equals("E3")) {
            list1 = this.queryExtAlipayDutReqCount(query);
            list2 = this.queryExtAlipayDutOkCount(query);
            list3 = this.queryAutoPayNewCount(query);
            list4 = this.queryAutoPayCancelNewCount(query);
        } else if (query.getPayType().equals("AS")) {
            list1 = this.queryExtArsoftPayCount(query);
            list2 = this.queryExtArsoftPayOkCount(query);
            list3 = this.queryExtArsoftContractOkCount(query);
            list4 = this.queryExtArsoftContractQuitCount(query);
        } else if (query.getPayType().equals("TP")) {
            list1 = this.queryExtTeleMonthlyPayCount(query);
            list2 = this.queryExtTeleMonthlyPayOkCount(query);
            list3 = this.queryExtTeleMonthlyBindCount(query);
            list4 = this.queryExtTeleMonthlyQuitOkCount(query);
        } else if (query.getPayType().equals("UP")) {
            list1 = this.queryExtUniMonthPayCount(query);
            list2 = this.queryExtUniMonthPayOkCount(query);
            list3 = this.queryExtUniMonthBindCount(query);
            list4 = this.queryExtUniMonthQuitOkCount(query);
        } else if (query.getPayType().equals("YM")) {
            list1 = this.queryExtBestPayPayReqCount(query);
            list2 = this.queryExtBestPayPayOkCount(query);
            list3 = this.queryExtBestPayContractOkCount(query);
            list4 = this.queryExtBestPayContractQuitCount(query);
        } else if (query.getPayType().equals("F")) {
            list1 = this.queryMobileVIPBillReqCount(query);
            list2 = this.queryMobileVIPBillOkCount(query);
            list3 = this.queryMobileVIPDayEndCount(query);
            list4 = this.queryMobileVIPDayEndQuitCount(query);
        }
        if (null != list1) {
            for (Agreement agreement : list1) {
                haveKey = resultMap.containsKey(agreement.getBalanceDate());
                if (haveKey) {
                    json = (Agreement)resultMap.get(agreement.getBalanceDate());
                    json.setPayReqNum(agreement.getPayReqNum());
                    continue;
                }
                resultMap.put(agreement.getBalanceDate(), agreement);
            }
        }
        if (null != list2) {
            for (Agreement agreement : list2) {
                haveKey = resultMap.containsKey(agreement.getBalanceDate());
                if (haveKey) {
                    json = (Agreement)resultMap.get(agreement.getBalanceDate());
                    json.setPayOkNum(agreement.getPayOkNum());
                    continue;
                }
                resultMap.put(agreement.getBalanceDate(), agreement);
            }
        }
        if (null != list3) {
            for (Agreement agreement : list3) {
                haveKey = resultMap.containsKey(agreement.getBalanceDate());
                if (haveKey) {
                    json = (Agreement)resultMap.get(agreement.getBalanceDate());
                    json.setSignNum(agreement.getSignNum());
                    continue;
                }
                resultMap.put(agreement.getBalanceDate(), agreement);
            }
        }
        if (null != list4) {
            for (Agreement agreement : list4) {
                haveKey = resultMap.containsKey(agreement.getBalanceDate());
                if (haveKey) {
                    json = (Agreement)resultMap.get(agreement.getBalanceDate());
                    json.setUnsignNum(agreement.getUnsignNum());
                    continue;
                }
                resultMap.put(agreement.getBalanceDate(), agreement);
            }
        }
        return resultMap;
    }

    @Override
    public List<Agreement> queryExtAlipayMonthReqCount(AgreementQueryRequest query) {
        return this.agreementDao.queryExtAlipayMonthReqCount(query);
    }

    @Override
    public List<Agreement> queryExtAlipayMonthOkCount(AgreementQueryRequest query) {
        return this.agreementDao.queryExtAlipayMonthOkCount(query);
    }

    @Override
    public List<Agreement> queryAutoPayNewCount(AgreementQueryRequest query) {
        return this.agreementDao.queryAutoPayNewCount(query);
    }

    @Override
    public List<Agreement> queryAutoPayCancelNewCount(AgreementQueryRequest query) {
        query.setProductType(BuilderUtils.getProductType(query.getBizNo()));
        return this.agreementDao.queryAutoPayCancelNewCount(query);
    }

    @Override
    public List<Agreement> queryExtWechatMonthReqCount(AgreementQueryRequest query) {
        return this.agreementDao.queryExtWechatMonthReqCount(query);
    }

    @Override
    public List<Agreement> queryExtWechatMonthOkCount(AgreementQueryRequest query) {
        return this.agreementDao.queryExtWechatMonthOkCount(query);
    }

    @Override
    public List<Agreement> queryExtAlipayDutReqCount(AgreementQueryRequest query) {
        return this.agreementDao.queryExtAlipayDutReqCount(query);
    }

    @Override
    public List<Agreement> queryExtAlipayDutOkCount(AgreementQueryRequest query) {
        return this.agreementDao.queryExtAlipayDutOkCount(query);
    }

    @Override
    public List<Agreement> queryExtArsoftPayCount(AgreementQueryRequest query) {
        return this.agreementDao.queryExtArsoftPayCount(query);
    }

    @Override
    public List<Agreement> queryExtArsoftPayOkCount(AgreementQueryRequest query) {
        return this.agreementDao.queryExtArsoftPayOkCount(query);
    }

    @Override
    public List<Agreement> queryExtArsoftContractOkCount(AgreementQueryRequest query) {
        return this.agreementDao.queryExtArsoftContractOkCount(query);
    }

    @Override
    public List<Agreement> queryExtArsoftContractQuitCount(AgreementQueryRequest query) {
        return this.agreementDao.queryExtArsoftContractQuitCount(query);
    }

    @Override
    public List<Agreement> queryExtTeleMonthlyPayCount(AgreementQueryRequest query) {
        return this.agreementDao.queryExtTeleMonthlyPayCount(query);
    }

    @Override
    public List<Agreement> queryExtTeleMonthlyPayOkCount(AgreementQueryRequest query) {
        return this.agreementDao.queryExtTeleMonthlyPayOkCount(query);
    }

    @Override
    public List<Agreement> queryExtTeleMonthlyBindCount(AgreementQueryRequest query) {
        return this.agreementDao.queryExtTeleMonthlyBindCount(query);
    }

    @Override
    public List<Agreement> queryExtTeleMonthlyQuitOkCount(AgreementQueryRequest query) {
        return this.agreementDao.queryExtTeleMonthlyQuitOkCount(query);
    }

    @Override
    public List<Agreement> queryExtUniMonthPayCount(AgreementQueryRequest query) {
        return this.agreementDao.queryExtUniMonthPayCount(query);
    }

    @Override
    public List<Agreement> queryExtUniMonthPayOkCount(AgreementQueryRequest query) {
        return this.agreementDao.queryExtUniMonthPayOkCount(query);
    }

    @Override
    public List<Agreement> queryExtUniMonthBindCount(AgreementQueryRequest query) {
        return this.agreementDao.queryExtUniMonthBindCount(query);
    }

    @Override
    public List<Agreement> queryExtUniMonthQuitOkCount(AgreementQueryRequest query) {
        return this.agreementDao.queryExtUniMonthQuitOkCount(query);
    }

    @Override
    public List<Agreement> queryExtBestPayPayReqCount(AgreementQueryRequest query) {
        query.setPayType("YM");
        return this.agreementDao.queryExtBestPayPayReqCount(query);
    }

    @Override
    public List<Agreement> queryExtBestPayPayOkCount(AgreementQueryRequest query) {
        query.setPayType("YM");
        return this.agreementDao.queryExtBestPayPayOkCount(query);
    }

    @Override
    public List<Agreement> queryExtBestPayContractOkCount(AgreementQueryRequest query) {
        query.setPayType("YM");
        return this.agreementDao.queryExtBestPayContractOkCount(query);
    }

    @Override
    public List<Agreement> queryExtBestPayContractQuitCount(AgreementQueryRequest query) {
        query.setPayType("YM");
        return this.agreementDao.queryExtBestPayContractQuitCount(query);
    }

    @Override
    public List<Agreement> queryMobileVIPBillReqCount(AgreementQueryRequest query) {
        return this.agreementDao.queryMobileVIPBillReqCount(query);
    }

    @Override
    public List<Agreement> queryMobileVIPBillOkCount(AgreementQueryRequest query) {
        query.setChargeState("Y");
        return this.agreementDao.queryMobileVIPBillPayokCount(query);
    }

    @Override
    public List<Agreement> queryMobileVIPDayEndCount(AgreementQueryRequest query) {
        List<Agreement> resultList = this.agreementDao.queryMobileVIPDayEndCount(query);
        return resultList;
    }

    @Override
    public List<Agreement> queryMobileVIPDayEndQuitCount(AgreementQueryRequest query) {
        List<Agreement> resultList = this.agreementDao.queryMobileVIPDayEndQuitCount(query);
        return resultList;
    }
}

