/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.agreement.director;

import com.xunlei.channel.api.agreement.builder.Builder;
import com.xunlei.channel.api.agreement.entity.Agreement;
import com.xunlei.channel.api.agreement.entity.AgreementQueryRequest;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResultDirector {
    @Autowired
    private Builder builder;

    public ResultDirector(Builder builder) {
        this.builder = builder;
    }

    public Map<String, Agreement> construct(AgreementQueryRequest query) {
        return this.getResultMap(query);
    }

    public Map<String, Agreement> getResultMap(AgreementQueryRequest query) {
        Agreement json;
        boolean haveKey;
        TreeMap<String, Agreement> resultMap = new TreeMap<String, Agreement>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.compareTo(o1);
            }
        });
        List<Agreement> list1 = this.builder.getPayReqNum(query);
        List<Agreement> list2 = this.builder.getPayOkNum(query);
        List<Agreement> list3 = this.builder.getSignNum(query);
        List<Agreement> list4 = this.builder.getUnSignNum(query);
        if (null != list1) {
            for (Agreement temp : list1) {
                haveKey = resultMap.containsKey(temp.getBalanceDate());
                if (haveKey) {
                    json = (Agreement)resultMap.get(temp.getBalanceDate());
                    json.setPayReqNum(temp.getPayReqNum());
                    continue;
                }
                resultMap.put(temp.getBalanceDate(), temp);
            }
        }
        if (null != list2) {
            for (Agreement temp : list2) {
                haveKey = resultMap.containsKey(temp.getBalanceDate());
                if (haveKey) {
                    json = (Agreement)resultMap.get(temp.getBalanceDate());
                    json.setPayOkNum(temp.getPayOkNum());
                    continue;
                }
                resultMap.put(temp.getBalanceDate(), temp);
            }
        }
        if (null != list3) {
            for (Agreement temp : list3) {
                haveKey = resultMap.containsKey(temp.getBalanceDate());
                if (haveKey) {
                    json = (Agreement)resultMap.get(temp.getBalanceDate());
                    json.setSignNum(temp.getSignNum());
                    continue;
                }
                resultMap.put(temp.getBalanceDate(), temp);
            }
        }
        if (null != list4) {
            for (Agreement temp : list4) {
                haveKey = resultMap.containsKey(temp.getBalanceDate());
                if (haveKey) {
                    json = (Agreement)resultMap.get(temp.getBalanceDate());
                    json.setUnsignNum(temp.getUnsignNum());
                    continue;
                }
                resultMap.put(temp.getBalanceDate(), temp);
            }
        }
        return resultMap;
    }
}

