/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.agreement.dao;

import com.xunlei.channel.api.agreement.entity.Agreement;
import com.xunlei.channel.api.agreement.entity.AgreementQueryRequest;
import com.xunlei.channel.api.agreement.entity.AgreementResult;
import com.xunlei.channel.api.agreement.utils.CommonUtils;
import com.xunlei.channel.api.dao.PayproxyBaseDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class AgreementDao
extends PayproxyBaseDao<Agreement>
implements RowMapper<Agreement> {
    private static final Logger logger = LoggerFactory.getLogger(AgreementDao.class);

    public Map<String, AgreementResult> queryAgreement(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT balanceDate,payType,SUM(payreq) as payReq,SUM(payok) as payOk,SUM(signnum) as signNum,SUM(unsignnum) as unSignNum FROM agreement_daily ");
        StringBuffer sqlParams = new StringBuffer("WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sqlParams.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sqlParams.append(" AND balanceDate >= '").append(query.getBeginDate()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sqlParams.append(" AND balanceDate <= '").append(query.getEndDate()).append("'");
        }
        sqlParams.append(" group by balancedate,paytype");
        sql.append(sqlParams);
        logger.info("sql: {}", (Object)sql);
        final HashMap<String, AgreementResult> resultMap = new HashMap<String, AgreementResult>();
        this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement agreement = new Agreement();
                agreement.setBalanceDate(rs.getString("balanceDate"));
                agreement.setPayType(rs.getString("payType"));
                agreement.setPayReqNum(rs.getInt("payReq"));
                agreement.setPayOkNum(rs.getInt("payOk"));
                agreement.setSignNum(rs.getInt("signNum"));
                agreement.setUnsignNum(rs.getInt("unSignNum"));
                if (resultMap.containsKey(agreement.getBalanceDate())) {
                    AgreementResult agreementResult = (AgreementResult)resultMap.get(rs.getString("balanceDate"));
                    resultMap.put(agreement.getBalanceDate(), AgreementDao.this.setAgreementObject(agreementResult, agreement));
                } else {
                    resultMap.put(agreement.getBalanceDate(), AgreementDao.this.setAgreementObject(new AgreementResult(), agreement));
                }
                return agreement;
            }
        });
        return resultMap;
    }

    public AgreementResult setAgreementObject(AgreementResult result, Agreement agreement) {
        result.setBalanceDate(agreement.getBalanceDate());
        if (agreement.getPayType().equals("AM")) {
            result.setPayReqAM(agreement.getPayReqNum());
            result.setPayOkAM(agreement.getPayOkNum());
            result.setSignNumAM(agreement.getSignNum());
            result.setUnSignNumAM(agreement.getUnsignNum());
        }
        if (agreement.getPayType().equals("W5")) {
            result.setPayReqW5(agreement.getPayReqNum());
            result.setPayOkW5(agreement.getPayOkNum());
            result.setSignNumW5(agreement.getSignNum());
            result.setUnSignNumW5(agreement.getUnsignNum());
        }
        if (agreement.getPayType().equals("E3")) {
            result.setPayReqE3(agreement.getPayReqNum());
            result.setPayOkE3(agreement.getPayOkNum());
            result.setSignNumE3(agreement.getSignNum());
            result.setUnSignNumE3(agreement.getUnsignNum());
        }
        if (agreement.getPayType().equals("AS") || agreement.getPayType().equals("UP") || agreement.getPayType().equals("TP") || agreement.getPayType().equals("YM") || agreement.getPayType().equals("F")) {
            result.setPayReqPhone(agreement.getPayReqNum() + result.getPayReqPhone());
            result.setPayOkPhone(agreement.getPayOkNum() + result.getPayOkPhone());
            result.setSignNumPhone(agreement.getSignNum() + result.getSignNumPhone());
            result.setUnSignNumPhone(agreement.getUnsignNum() + result.getUnSignNumPhone());
        }
        return result;
    }

    public List<Agreement> queryExtAlipayMonthReqCount(AgreementQueryRequest data) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as payReqNum,balanceDate FROM ");
        StringBuffer sqlParamsReq = new StringBuffer("WHERE remark='auto' ");
        if (!StringUtils.isEmpty((Object)data.getBizNo())) {
            sqlParamsReq.append(" AND bizNo = '").append(data.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)data.getBeginDate())) {
            sqlParamsReq.append(" AND orderTime >= '").append(data.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)data.getEndDate())) {
            sqlParamsReq.append(" AND orderTime <= '").append(data.getEndDate()).append(" 23:59:59'");
        }
        StringBuffer sqlParamsOk = new StringBuffer("WHERE remark='auto' ");
        if (!StringUtils.isEmpty((Object)data.getBizNo())) {
            sqlParamsOk.append(" AND bizNo = '").append(data.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)data.getBeginDate())) {
            sqlParamsOk.append(" AND balanceDate >= '").append(data.getBeginDate()).append(" '");
        }
        if (!StringUtils.isEmpty((Object)data.getEndDate())) {
            sqlParamsOk.append(" AND balanceDate <= '").append(data.getEndDate()).append("'");
        }
        sql.append("(SELECT seqid,DATE_FORMAT(orderTime,\"%Y-%m-%d\") as balanceDate FROM extalipaymonthreq " + sqlParamsReq.toString() + " union SELECT seqid,balanceDate from extwechatmonthpayok " + sqlParamsOk.toString() + ") a group by balanceDate");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("AM");
                temp.setPayReqNum(rs.getInt("payReqNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtAlipayMonthOkCount(AgreementQueryRequest data) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as payOkNum,balanceDate FROM extalipaymonthok WHERE remark='auto'");
        if (!StringUtils.isEmpty((Object)data.getBizNo())) {
            sql.append(" AND bizNo = '").append(data.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)data.getBeginDate())) {
            sql.append(" AND successTime >= '").append(data.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)data.getEndDate())) {
            sql.append(" AND successTime <= '").append(data.getEndDate()).append(" 23:59:59'");
        }
        sql.append(" group by balanceDate order by balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("AM");
                temp.setPayOkNum(rs.getInt("payOkNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryAutoPayNewCount(AgreementQueryRequest data) {
        final String payType = data.getPayType();
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as signNum,DATE_FORMAT(autopayTime,\"%Y-%m-%d\") as balanceDate FROM autopay_new WHERE ext2=1 AND failTimes=0 AND flag=1 AND extcardpayStatus='Y' ");
        if (!StringUtils.isEmpty((Object)data.getPayType())) {
            sql.append(" AND payType = '").append(data.getPayType()).append("'");
        }
        if (!StringUtils.isEmpty((Object)data.getProductType())) {
            sql.append(" AND productType = '").append(data.getProductType()).append("'");
        }
        if (!StringUtils.isEmpty((Object)data.getBeginDate())) {
            sql.append(" AND autopayTime >= '").append(data.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)data.getEndDate())) {
            sql.append(" AND autopayTime <= '").append(data.getEndDate()).append(" 23:59:59'");
        }
        sql.append(" group by balanceDate order by balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType(payType);
                temp.setSignNum(rs.getInt("signNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryAutoPayCancelNewCount(AgreementQueryRequest data) {
        final String payType = data.getPayType();
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as unsignNum,DATE_FORMAT(cancelTime,\"%Y-%m-%d\") as balanceDate FROM autopaycancel_new WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)data.getPayType())) {
            sql.append(" AND payType = '").append(data.getPayType()).append("'");
        }
        if (!StringUtils.isEmpty((Object)data.getProductType())) {
            sql.append(" AND productType = '").append(data.getProductType()).append("'");
        }
        if (!StringUtils.isEmpty((Object)data.getBeginDate())) {
            sql.append(" AND cancelTime >= '").append(data.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)data.getEndDate())) {
            sql.append(" AND cancelTime <= '").append(data.getEndDate()).append(" 23:59:59'");
        }
        sql.append(" group by balanceDate order by balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType(payType);
                temp.setUnsignNum(rs.getInt("unsignNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtWechatMonthReqCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as payReqNum,balanceDate FROM ");
        StringBuffer sqlParamsReq = new StringBuffer("WHERE remark='auto' ");
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sqlParamsReq.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sqlParamsReq.append(" AND orderTime >= '").append(query.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sqlParamsReq.append(" AND orderTime <= '").append(query.getEndDate()).append(" 23:59:59'");
        }
        StringBuffer sqlParamsOk = new StringBuffer("WHERE remark='auto' ");
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sqlParamsOk.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sqlParamsOk.append(" AND balanceDate >= '").append(query.getBeginDate()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sqlParamsOk.append(" AND balanceDate <= '").append(query.getEndDate()).append("'");
        }
        sql.append("(SELECT seqid,DATE_FORMAT(orderTime,\"%Y-%m-%d\") as balanceDate FROM extwechatmonthpayreq " + sqlParamsReq.toString() + " union SELECT seqid,balanceDate from extwechatmonthpayok " + sqlParamsOk.toString() + ") a group by balanceDate");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("W5");
                temp.setPayReqNum(rs.getInt("payReqNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtWechatMonthOkCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as payOkNum,balanceDate FROM extwechatmonthpayok WHERE remark='auto' ");
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sql.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sql.append(" AND balanceDate >= '").append(query.getBeginDate()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sql.append(" AND balanceDate <= '").append(query.getEndDate()).append("'");
        }
        sql.append(" group by balanceDate order by balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("W5");
                temp.setPayOkNum(rs.getInt("payOkNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtAlipayDutReqCount(AgreementQueryRequest query) {
        int i;
        List<String> bizOrderList = null;
        List<String> bizOrderOkList = null;
        try {
            bizOrderList = CommonUtils.getTables4Bizorder(query.getBeginDate(), query.getEndDate());
            bizOrderOkList = CommonUtils.getTables4BizorderOk(query.getBeginDate(), query.getEndDate());
        }
        catch (ParseException e) {
            logger.error("error queryExtAlipayDutReqCount getMonthBetween:{}", (Object)e.toString());
            e.printStackTrace();
        }
        StringBuffer sqlParamsReq = new StringBuffer(" WHERE other1='ifm' and payType='E3' ");
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sqlParamsReq.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sqlParamsReq.append(" AND inputTime >= '").append(query.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sqlParamsReq.append(" AND inputTime <= '").append(query.getEndDate()).append(" 23:59:59'");
        }
        StringBuffer sqlParamsOk = new StringBuffer(" WHERE other1='ifm' and payType='E3' ");
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sqlParamsOk.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sqlParamsOk.append(" AND balanceDate >= '").append(query.getBeginDate()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sqlParamsOk.append(" AND balanceDate <= '").append(query.getEndDate()).append("'");
        }
        StringBuffer strSQL = new StringBuffer();
        for (i = 0; i < bizOrderList.size(); ++i) {
            if (i != 0) {
                strSQL.append(" union ");
            }
            strSQL.append(" SELECT seqid,DATE_FORMAT(inputtime,\"%Y-%m-%d\") as balanceDate from " + bizOrderList.get(0) + sqlParamsReq.toString());
        }
        for (i = 0; i < bizOrderOkList.size(); ++i) {
            strSQL.append("union SELECT seqid,balanceDate from " + bizOrderOkList.get(0) + sqlParamsOk.toString());
        }
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as payReqNum,balanceDate FROM ");
        sql.append(" ( ").append(strSQL.toString()).append(" ) a group by balanceDate");
        logger.info("sql: {}", (Object)sql.toString());
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("E3");
                temp.setPayReqNum(rs.getInt("payReqNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtAlipayDutOkCount(AgreementQueryRequest query) {
        List<String> bizOrderOkList = null;
        try {
            bizOrderOkList = CommonUtils.getTables4BizorderOk(query.getBeginDate(), query.getEndDate());
        }
        catch (ParseException e) {
            logger.error("error queryExtAlipayDutOkCount getMonthBetween:{}", (Object)e.toString());
            e.printStackTrace();
        }
        StringBuffer sqlParams = new StringBuffer(" WHERE other1='ifm' and payType='E3' ");
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sqlParams.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sqlParams.append(" AND balanceDate >= '").append(query.getBeginDate()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sqlParams.append(" AND balanceDate <= '").append(query.getEndDate()).append("'");
        }
        StringBuffer strSQL = new StringBuffer();
        for (int i = 0; i < bizOrderOkList.size(); ++i) {
            if (i != 0) {
                strSQL.append(" union ");
            }
            strSQL.append(" SELECT seqid,balanceDate from " + bizOrderOkList.get(0) + sqlParams.toString());
        }
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as payOkNum,balanceDate FROM ");
        sql.append(" (").append(strSQL.toString()).append(" ) group by balanceDate order by balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("E3");
                temp.setPayOkNum(rs.getInt("payOkNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtArsoftPayCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as payReqNum,balanceDate FROM ");
        StringBuffer sqlParamsReq = new StringBuffer("WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getPayType())) {
            sqlParamsReq.append(" AND payType = '").append(query.getPayType()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sqlParamsReq.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sqlParamsReq.append(" AND inputTime >= '").append(query.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sqlParamsReq.append(" AND inputTime <= '").append(query.getEndDate()).append(" 23:59:59'");
        }
        StringBuffer sqlParamsOk = new StringBuffer("WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getPayType())) {
            sqlParamsOk.append(" AND payType = '").append(query.getPayType()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sqlParamsOk.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sqlParamsOk.append(" AND balanceDate >= '").append(query.getBeginDate()).append(" '");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sqlParamsOk.append(" AND balanceDate <= '").append(query.getEndDate()).append("'");
        }
        sql.append("(SELECT seqid,DATE_FORMAT(inputTime,\"%Y-%m-%d\") as balanceDate FROM extarsoftpay " + sqlParamsReq.toString() + "union SELECT seqid,balanceDate from extarsoftpayok " + sqlParamsOk.toString() + ") a group by balanceDate");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("AS");
                temp.setPayReqNum(rs.getInt("payReqNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtArsoftPayOkCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as payOkNum,balanceDate FROM extarsoftpayok WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getPayType())) {
            sql.append(" AND payType = '").append(query.getPayType()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sql.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sql.append(" AND balanceDate >= '").append(query.getBeginDate()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sql.append(" AND balanceDate <= '").append(query.getEndDate()).append("'");
        }
        sql.append(" group by balanceDate order by balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("AS");
                temp.setPayOkNum(rs.getInt("payOkNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtArsoftContractOkCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as signNum,a1.balanceDate FROM extarsoftcontractok a1 left join extarsoftpayok a2 on a1.signno=a2.xunleipayid WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getPayType())) {
            sql.append(" AND a1.payType = '").append(query.getPayType()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sql.append(" AND a1.balanceDate >= '").append(query.getBeginDate()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sql.append(" AND a1.balanceDate <= '").append(query.getEndDate()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sql.append(" AND a2.bizNo = '").append(query.getBizNo()).append("'");
        }
        sql.append(" group by a1.balanceDate order by a1.balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("AS");
                temp.setSignNum(rs.getInt("signNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtArsoftContractQuitCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as unsignNum,a1.balanceDate FROM extarsoftcontractquit a1 left join extarsoftpayok a2 on a1.signno=a2.xunleipayid WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getPayType())) {
            sql.append(" AND a1.payType = '").append(query.getPayType()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sql.append(" AND a1.balanceDate >= '").append(query.getBeginDate()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sql.append(" AND a1.balanceDate <= '").append(query.getEndDate()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sql.append(" AND a2.bizNo = '").append(query.getBizNo()).append("'");
        }
        sql.append(" group by a1.balanceDate order by a1.balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("AS");
                temp.setUnsignNum(rs.getInt("unsignNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtTeleMonthlyPayCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as payReqNum,balanceDate FROM ");
        StringBuffer sqlParamsReq = new StringBuffer("WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sqlParamsReq.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sqlParamsReq.append(" AND inputTime >= '").append(query.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sqlParamsReq.append(" AND inputTime <= '").append(query.getEndDate()).append(" 23:59:59'");
        }
        StringBuffer sqlParamsOk = new StringBuffer("WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sqlParamsOk.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sqlParamsOk.append(" AND balanceDate >= '").append(query.getBeginDate()).append(" '");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sqlParamsOk.append(" AND balanceDate <= '").append(query.getEndDate()).append("'");
        }
        sql.append("(SELECT seqid,DATE_FORMAT(inputTime,\"%Y-%m-%d\") as balanceDate FROM exttelemonthlypay " + sqlParamsReq.toString() + " union SELECT seqid,balanceDate from exttelemonthlypayok " + sqlParamsOk.toString() + ") a group by balanceDate");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("TP");
                temp.setPayReqNum(rs.getInt("payReqNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtTeleMonthlyPayOkCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as payOkNum,balanceDate FROM exttelemonthlypayok WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sql.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sql.append(" AND balanceDate >= '").append(query.getBeginDate()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sql.append(" AND balanceDate <= '").append(query.getEndDate()).append("'");
        }
        sql.append(" group by balanceDate order by balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("TP");
                temp.setPayOkNum(rs.getInt("payOkNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtTeleMonthlyBindCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as signNum,DATE_FORMAT(ordertime,\"%Y-%m-%d\") as balanceDate FROM exttelemonthlybind WHERE status='Y' ");
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sql.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sql.append(" AND ordertime >= '").append(query.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sql.append(" AND ordertime <= '").append(query.getEndDate()).append(" 23:59:59'");
        }
        sql.append(" group by balanceDate order by balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("TP");
                temp.setSignNum(rs.getInt("signNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtTeleMonthlyQuitOkCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as unsignNum,DATE_FORMAT(cancelTime,\"%Y-%m-%d\") as balanceDate FROM exttelemonthlyquitok WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sql.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sql.append(" AND cancelTime >= '").append(query.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sql.append(" AND cancelTime <= '").append(query.getEndDate()).append(" 23:59:59'");
        }
        sql.append(" group by balanceDate order by balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("TP");
                temp.setUnsignNum(rs.getInt("unsignNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtUniMonthPayCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as payReqNum,balanceDate FROM ");
        StringBuffer sqlParamsReq = new StringBuffer("WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sqlParamsReq.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sqlParamsReq.append(" AND inputTime >= '").append(query.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sqlParamsReq.append(" AND inputTime <= '").append(query.getEndDate()).append(" 23:59:59'");
        }
        StringBuffer sqlParamsOk = new StringBuffer("WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sqlParamsOk.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sqlParamsOk.append(" AND balanceDate >= '").append(query.getBeginDate()).append(" '");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sqlParamsOk.append(" AND balanceDate <= '").append(query.getEndDate()).append("'");
        }
        sql.append("(SELECT seqid,DATE_FORMAT(inputTime,\"%Y-%m-%d\") as balanceDate FROM extunimonthpay " + sqlParamsReq.toString() + " union SELECT seqid,balanceDate from extunimonthpayok " + sqlParamsOk.toString() + ") a group by balanceDate");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("UP");
                temp.setPayReqNum(rs.getInt("payReqNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtUniMonthPayOkCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as payOkNum,balanceDate FROM extunimonthpayok WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sql.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sql.append(" AND balanceDate >= '").append(query.getBeginDate()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sql.append(" AND balanceDate <= '").append(query.getEndDate()).append("'");
        }
        sql.append(" group by balanceDate order by balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("UP");
                temp.setPayOkNum(rs.getInt("payOkNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtUniMonthBindCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as signNum,DATE_FORMAT(orderTime,\"%Y-%m-%d\") as balanceDate FROM extunimonthbind WHERE status='Y' ");
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sql.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sql.append(" AND orderTime >= '").append(query.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sql.append(" AND orderTime <= '").append(query.getEndDate()).append(" 23:59:59'");
        }
        sql.append(" group by balanceDate order by balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("UP");
                temp.setSignNum(rs.getInt("signNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtUniMonthQuitOkCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as unsignNum,DATE_FORMAT(cancelTime,\"%Y-%m-%d\") as balanceDate FROM extunimonthquitok WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sql.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sql.append(" AND cancelTime >= '").append(query.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sql.append(" AND cancelTime <= '").append(query.getEndDate()).append(" 23:59:59'");
        }
        sql.append(" group by balanceDate order by balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("UP");
                temp.setUnsignNum(rs.getInt("unsignNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtBestPayPayReqCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as payReqNum,balanceDate FROM ");
        StringBuffer sqlParamsReq = new StringBuffer("WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getPayType())) {
            sqlParamsReq.append(" AND payType = '").append(query.getPayType()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sqlParamsReq.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sqlParamsReq.append(" AND inputTime >= '").append(query.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sqlParamsReq.append(" AND inputTime <= '").append(query.getEndDate()).append(" 23:59:59'");
        }
        StringBuffer sqlParamsOk = new StringBuffer("WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getPayType())) {
            sqlParamsOk.append(" AND payType = '").append(query.getPayType()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sqlParamsOk.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sqlParamsOk.append(" AND balanceDate >= '").append(query.getBeginDate()).append(" '");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sqlParamsOk.append(" AND balanceDate <= '").append(query.getEndDate()).append("'");
        }
        sql.append("(SELECT seqid,DATE_FORMAT(inputTime,\"%Y-%m-%d\") as balanceDate FROM extbestpaypay " + sqlParamsReq.toString() + " union SELECT seqid,balanceDate from extbestpaypayok " + sqlParamsOk.toString() + ") a group by balanceDate");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("YM");
                temp.setPayReqNum(rs.getInt("payReqNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtBestPayPayOkCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as payOkNum,balanceDate FROM extbestpaypayok WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getPayType())) {
            sql.append(" AND payType = '").append(query.getPayType()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sql.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sql.append(" AND balanceDate >= '").append(query.getBeginDate()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sql.append(" AND balanceDate <= '").append(query.getEndDate()).append("'");
        }
        sql.append(" group by balanceDate order by balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("YM");
                temp.setPayOkNum(rs.getInt("payOkNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtBestPayContractOkCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as signNum,balanceDate FROM extbestpaycontractok WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getPayType())) {
            sql.append(" AND payType = '").append(query.getPayType()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sql.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sql.append(" AND balanceDate >= '").append(query.getBeginDate()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sql.append(" AND balanceDate <= '").append(query.getEndDate()).append("'");
        }
        sql.append(" group by balanceDate order by balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("YM");
                temp.setSignNum(rs.getInt("signNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryExtBestPayContractQuitCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as unsignNum,DATE_FORMAT(canceltime,\"%Y-%m-%d\") as balanceDate FROM extbestpaycontractquit WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)query.getPayType())) {
            sql.append(" AND payType = '").append(query.getPayType()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBizNo())) {
            sql.append(" AND bizNo = '").append(query.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sql.append(" AND cancelTime >= '").append(query.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sql.append(" AND cancelTime <= '").append(query.getEndDate()).append(" 23:59:59'");
        }
        sql.append(" group by balanceDate order by balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("YM");
                temp.setUnsignNum(rs.getInt("unsignNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryMobileVIPBillReqCount(AgreementQueryRequest query) {
        StringBuffer sqlParamsMobileOk = new StringBuffer("");
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sqlParamsMobileOk.append(" AND GetTime >= '").append(query.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sqlParamsMobileOk.append(" AND GetTime <= '").append(query.getEndDate()).append(" 23:59:59'");
        }
        sqlParamsMobileOk.append(" group by balanceDate ");
        StringBuffer sqlParamsRequest = new StringBuffer("");
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sqlParamsRequest.append(" AND ReqTime >= '").append(query.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sqlParamsRequest.append(" AND ReqTime <= '").append(query.getEndDate()).append(" 23:59:59'");
        }
        sqlParamsRequest.append(" group by balanceDate ");
        StringBuffer sqlParamsMobilevipBill = new StringBuffer(" WHERE chargestate='Y' AND Datastate='N' AND Dealtype='A' AND Sp='K' ");
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sqlParamsMobilevipBill.append(" AND chargetime >= '").append(query.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sqlParamsMobilevipBill.append(" AND chargetime <= '").append(query.getEndDate()).append(" 23:59:59'");
        }
        sqlParamsMobilevipBill.append(" group by balanceDate ");
        StringBuffer requestCountSql = new StringBuffer("SELECT  SUM(payReqNumS) as payReqNum, balanceDate FROM (SELECT COUNT(1) as payReqNumS,DATE_FORMAT(ReqTime,\"%Y-%m-%d\") as balanceDate FROM mobilevipreq WHERE sp='K' ").append(sqlParamsRequest.toString()).append(" UNION SELECT COUNT(1) AS payReqNumS,DATE_FORMAT(GetTime,\"%Y-%m-%d\") AS balanceDate FROM mobilevipok WHERE sp='K'").append(sqlParamsMobileOk.toString()).append(" UNION SELECT COUNT(1) AS payReqNumS,DATE_FORMAT(chargetime,\"%Y-%m-%d\") AS balanceDate FROM mobilevipbill ").append(sqlParamsMobilevipBill.toString()).append(") as a group by balancedate order by balanceDate desc");
        logger.info("sql: {}", (Object)requestCountSql.toString());
        List list = this.jdbcTemplate.query(requestCountSql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("F");
                temp.setPayReqNum(rs.getInt("payReqNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryMobileVIPBillPayokCount(AgreementQueryRequest query) {
        StringBuffer sqlParamsMobileOk = new StringBuffer(" ");
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sqlParamsMobileOk.append(" AND chargetime >= '").append(query.getBeginDate()).append(" 00:00:00'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sqlParamsMobileOk.append(" AND chargetime <= '").append(query.getEndDate()).append(" 23:59:59'");
        }
        sqlParamsMobileOk.append(" group by balanceDate order by balanceDate desc");
        StringBuffer payokCountSql = new StringBuffer("SELECT COUNT(1) AS payOkNum,DATE_FORMAT(chargetime,\"%Y-%m-%d\") AS balanceDate FROM mobilevipbill  WHERE chargestate='Y' AND Datastate='N' AND Dealtype='A' AND Sp='K' ").append(sqlParamsMobileOk.toString());
        logger.info("sql: {}", (Object)payokCountSql.toString());
        List list = this.jdbcTemplate.query(payokCountSql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("F");
                temp.setPayOkNum(rs.getInt("payOkNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryMobileVIPDayEndCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT sum(newsuccessnum) as signNum,sum(newquitnum) as unsignNum,balanceDate FROM mobilevipdayend WHERE sp='K' ");
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sql.append(" AND balanceDate >= '").append(query.getBeginDate()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sql.append(" AND balanceDate <= '").append(query.getEndDate()).append("'");
        }
        sql.append(" group by balanceDate order by balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("F");
                temp.setSignNum(rs.getInt("signNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public List<Agreement> queryMobileVIPDayEndQuitCount(AgreementQueryRequest query) {
        StringBuffer sql = new StringBuffer("SELECT sum(newquitnum) as unsignNum,balanceDate FROM mobilevipdayend WHERE sp='K' ");
        if (!StringUtils.isEmpty((Object)query.getBeginDate())) {
            sql.append(" AND balanceDate >= '").append(query.getBeginDate()).append("'");
        }
        if (!StringUtils.isEmpty((Object)query.getEndDate())) {
            sql.append(" AND balanceDate <= '").append(query.getEndDate()).append("'");
        }
        sql.append(" group by balanceDate order by balanceDate desc");
        logger.info("sql: {}", (Object)sql);
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Agreement mapRow(ResultSet rs, int rowNum) throws SQLException {
                Agreement temp = new Agreement();
                temp.setPayType("F");
                temp.setUnsignNum(rs.getInt("unsignNum"));
                temp.setBalanceDate(rs.getString("balanceDate"));
                return temp;
            }
        });
        return list;
    }

    public Agreement mapRow(ResultSet resultSet, int i) throws SQLException {
        return null;
    }
}

