/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.agreement.controller;

import com.google.common.collect.Sets;
import com.xunlei.channel.api.agreement.dao.BizInfoQueryDao;
import com.xunlei.channel.api.agreement.entity.AgreementQueryRequest;
import com.xunlei.channel.api.agreement.entity.AgreementResult;
import com.xunlei.channel.api.agreement.entity.JsonResult;
import com.xunlei.channel.api.agreement.query.AgreementQueryService;
import com.xunlei.channel.api.entity.ReturnResult;
import com.xunlei.channel.api.util.reflect.ReflectionUtils;
import com.xunlei.channel.api.util.sign.SignUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/agreement"})
public class AgreementController {
    private static final Logger logger = LoggerFactory.getLogger(AgreementController.class);
    @Autowired
    private BizInfoQueryDao bizInfoQueryDao;
    @Autowired
    private AgreementQueryService agreementQueryService;

    @GetMapping(value={"/queryAgreement"})
    public ReturnResult queryOrderInfoByBizNoAndBizOrderId(@Valid AgreementQueryRequest agreementQueryRequest, BindingResult bindingResult) {
        long startTime = System.currentTimeMillis();
        String signBizNo = agreementQueryRequest.getSignBizNo();
        Assert.hasText((String)signBizNo, (String)"signBizNo\u4e0d\u80fd\u4e3a\u7a7a");
        String signMessage = agreementQueryRequest.getSignMessage();
        Assert.hasText((String)signMessage, (String)"signMessage\u4e0d\u80fd\u4e3a\u7a7a");
        String beginDate = agreementQueryRequest.getBeginDate();
        Assert.hasText((String)beginDate, (String)"beginDate\u4e0d\u80fd\u4e3a\u7a7a");
        String endDate = agreementQueryRequest.getEndDate();
        Assert.hasText((String)endDate, (String)"endDate\u4e0d\u80fd\u4e3a\u7a7a");
        Boolean isMatchSign = this.checkSign(agreementQueryRequest);
        if (!isMatchSign.booleanValue()) {
            return ReturnResult.CHECK_SIGN_ERROR;
        }
        if (beginDate.length() != 10 || endDate.length() != 10) {
            return ReturnResult.CHECK_SIGN_ERROR;
        }
        Map<String, AgreementResult> agreementResultMap = this.agreementQueryService.queryAgreement(agreementQueryRequest);
        ArrayList<AgreementResult> resultList = new ArrayList<AgreementResult>();
        Iterator<String> iter = agreementResultMap.keySet().iterator();
        while (iter.hasNext()) {
            AgreementResult vo = agreementResultMap.get(iter.next());
            resultList.add(vo);
        }
        TreeMap<String, Object> resultJson = new TreeMap<String, Object>();
        resultJson.put("result", resultList);
        resultJson.put("status", "T");
        if (resultJson == null) {
            return ReturnResult.NO_AGREEMENT_DATA;
        }
        long endTime = System.currentTimeMillis();
        logger.info("finsh success,take time:", (Object)((endTime - startTime) / 1000L));
        return JsonResult.getResult(resultJson);
    }

    private Boolean checkSign(AgreementQueryRequest areementQueryRequest) {
        String bizNo = areementQueryRequest.getSignBizNo();
        String signMessage = areementQueryRequest.getSignMessage();
        Map map = ReflectionUtils.convertObjectFieldsToMap((Object)areementQueryRequest, AgreementQueryRequest.class);
        String key = this.bizInfoQueryDao.findBizKey(bizNo);
        if (StringUtils.isEmpty((Object)key)) {
            return false;
        }
        String signed = SignUtils.sign((Map)map, (Set)Sets.newHashSet((Object[])new String[]{"signMessage"}), (String)key, (String)"UTF-8", (boolean)true);
        boolean isMatch = SignUtils.checkSign((String)signMessage, (Map)map, (Set)Sets.newHashSet((Object[])new String[]{"signMessage"}), (String)key, (String)"UTF-8", (boolean)true);
        if (isMatch) {
            if (logger.isDebugEnabled()) {
                logger.debug("Success check sign! signed: {}, signMessage: {}", (Object)signed, (Object)signMessage);
            }
        } else {
            logger.warn("Mismatch sign message! signed: {}, signMessage: {}", (Object)signed, (Object)signMessage);
        }
        return isMatch;
    }
}

