/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.agreement.builder;

import com.xunlei.channel.api.agreement.entity.Agreement;
import com.xunlei.channel.api.agreement.entity.AgreementResult;
import com.xunlei.channel.api.util.md5.MD5Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class BuilderUtils {
    private static final Logger logger = LoggerFactory.getLogger(BuilderUtils.class);
    public static Map<String, String> AUTO_PAY_INFO = new HashMap<String, String>();
    public static String KEY;

    public static Map<String, Agreement> conformityMap(List<Agreement> list, Map<String, Agreement> resultMap) {
        if (null != list) {
            for (Agreement temp : list) {
                boolean haveKey = resultMap.containsKey(temp.getBalanceDate());
                if (haveKey) {
                    Agreement json = resultMap.get(temp.getBalanceDate());
                    json.setUnsignNum(temp.getUnsignNum());
                    continue;
                }
                resultMap.put(temp.getBalanceDate(), temp);
            }
        }
        return resultMap;
    }

    public static Map<String, AgreementResult> conformityMap(String payType, Map<String, AgreementResult> resultMap, Map<String, Agreement> map) {
        for (String key : map.keySet()) {
            boolean haveKey = resultMap.containsKey(key);
            Agreement value = map.get(key);
            AgreementResult vo = null;
            vo = haveKey ? resultMap.get(key) : new AgreementResult();
            if ("AM".equals(payType)) {
                vo.setPayReqAM(value.getPayReqNum());
                vo.setPayOkAM(value.getPayOkNum());
                vo.setSignNumAM(value.getSignNum());
                vo.setUnSignNumAM(value.getUnsignNum());
            }
            if ("W5".equals(payType)) {
                vo.setPayReqW5(value.getPayReqNum());
                vo.setPayOkW5(value.getPayOkNum());
                vo.setSignNumW5(value.getSignNum());
                vo.setUnSignNumW5(value.getUnsignNum());
            }
            if ("E3".equals(payType)) {
                vo.setPayReqE3(value.getPayReqNum());
                vo.setPayOkE3(value.getPayOkNum());
                vo.setSignNumE3(value.getSignNum());
                vo.setUnSignNumE3(value.getUnsignNum());
            }
            if ("AS".equals(payType) || "YM".equals(payType) || "UP".equals(payType) || "TP".equals(payType) || "F".equals(payType)) {
                vo.setPayReqPhone(value.getPayReqNum() + vo.getPayReqPhone());
                vo.setPayOkPhone(value.getPayOkNum() + vo.getPayOkPhone());
                vo.setSignNumPhone(value.getSignNum() + vo.getSignNumPhone());
                vo.setUnSignNumPhone(value.getUnsignNum() + vo.getUnSignNumPhone());
            }
            vo.setBalanceDate(value.getBalanceDate());
            resultMap.put(key, vo);
        }
        return resultMap;
    }

    public static void init() {
        ResourceBundle rb = ResourceBundle.getBundle("agreement");
        KEY = rb.getString("key");
        String autoPayTemp = rb.getString("auto_pay_product_type");
        for (String productType : autoPayTemp.split(",")) {
            String[] biznos;
            for (String bizNo : biznos = rb.getString(productType + "_biz_nos").split(",")) {
                AUTO_PAY_INFO.put(bizNo, productType);
            }
        }
    }

    public static String getProductType(String bizNo) {
        if (null == AUTO_PAY_INFO || AUTO_PAY_INFO.size() == 0) {
            BuilderUtils.init();
        }
        return AUTO_PAY_INFO.get(bizNo);
    }

    public static String sign(Map<String, String> map, String key) {
        StringBuilder builder = new StringBuilder();
        builder.append(BuilderUtils.createLinkString(map)).append(key);
        return MD5Utils.getMD5Str((String)builder.toString(), (String)"UTF-8");
    }

    private static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (StringUtils.isEmpty((Object)value)) continue;
            if (i == keys.size() - 1) {
                builder.append(key).append("=").append(value);
                continue;
            }
            builder.append(key).append("=").append(value).append("&");
        }
        return builder.toString();
    }

    static {
        BuilderUtils.init();
    }
}

