/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.user.info.service;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.DirectReturnResult;
import com.xunlei.channel.gateway.common.result.ReturnResult;
import com.xunlei.channel.gateway.common.utils.BizUtil;
import com.xunlei.channel.gateway.common.utils.SignatureUtils;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public abstract class AbstractUserInfoService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractUserInfoService.class);
    @Autowired
    private BizUtil bizUtil;

    public ReturnResult processRequest(HttpServletRequest httpServletRequest) {
        String bizNo = httpServletRequest.getParameter("biz_no");
        if (!Strings.isNullOrEmpty((String)bizNo)) {
            String bizKey = this.bizUtil.getBizKey(bizNo);
            logger.debug("bizKey:{}", (Object)bizKey);
            if (bizKey == null) {
                logger.info("validate failed:invalid bizNo:{}", (Object)bizNo);
                return new DirectReturnResult(InterfaceReqResult.FAIL, "14", "\u5546\u6237\u53f7\u65e0\u6548", "pay_fail_page", null);
            }
            if (!this.verifySign(httpServletRequest, bizKey)) {
                logger.error("invalid sign");
                return new DirectReturnResult(InterfaceReqResult.FAIL, "11", "\u7b7e\u540d\u9519\u8bef", "pay_fail_page", null);
            }
        }
        return this.processBizRequest(httpServletRequest);
    }

    public abstract ReturnResult processBizRequest(HttpServletRequest var1);

    public boolean verifySign(HttpServletRequest httpServletRequest, String bizKey) {
        Enumeration names = httpServletRequest.getParameterNames();
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            paramsMap.put(name, httpServletRequest.getParameter(name));
        }
        if (SignatureUtils.checkSign(paramsMap, (String)bizKey, (String)"sign")) {
            return true;
        }
        logger.info("validate failed:invalid sign");
        return false;
    }
}

