/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.service.impl;

import com.google.common.base.Strings;
import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.ReturnResult;
import com.xunlei.channel.gateway.common.utils.BizUtil;
import com.xunlei.channel.gateway.common.utils.ObjectUtil;
import com.xunlei.channel.gateway.common.utils.SignatureUtils;
import com.xunlei.channel.gateway.common.utils.ValidateUtils;
import com.xunlei.channel.gateway.common.utils.XunleiPayIdUtils;
import com.xunlei.channel.gateway.pay.channels.ChannelHandler;
import com.xunlei.channel.gateway.pay.channels.ChannelHandlerMapping;
import com.xunlei.channel.gateway.pay.common.ChannelConfigInfoUtils;
import com.xunlei.channel.gateway.pay.common.ChildrenUserUtils;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import com.xunlei.channel.gateway.pay.service.PayService;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayServiceImpl
implements PayService {
    private static final Logger logger = LoggerFactory.getLogger(PayServiceImpl.class);
    @Autowired
    private PayOrderDAO payOrderDAO;
    @Autowired
    private ChannelHandlerMapping channelHandlerMapping;
    @Autowired
    private BizUtil bizUtil;
    @Autowired
    ChannelConfigInfoUtils channelConfigInfoUtils;
    private static final String REAL_PAYTYPE_GROUP_ID = "gateway_realpaytype";

    private void savePayOrder(PayOrder payOrder) {
        this.payOrderDAO.savePayOrder(payOrder);
    }

    private PayOrder generatePayOrder(UnitedPayRequest payRequest) {
        PayOrder payOrder = new PayOrder();
        payOrder.setBizNo(payRequest.getBizNo());
        payOrder.setBizOrderId(payRequest.getBizOrderId());
        payOrder.setOrderIp(payRequest.getClientIp());
        payOrder.setBizExt(payRequest.getExtraCommonParam());
        payOrder.setExtraJson(payRequest.getChannelHandler().analyzeExtParams(payRequest));
        payOrder.setPageCharset(payRequest.getInputCharset());
        payOrder.setNotifyUrl(payRequest.getNotifyUrl());
        payOrder.setOrderAmt(payRequest.getOrderAmt());
        payOrder.setOrderGroup(payRequest.getOrderGroup());
        payOrder.setOrderType(payRequest.getOrderType());
        payOrder.setPageUrl(payRequest.getPageUrl());
        payOrder.setPayType(payRequest.getRealPayType());
        String phone = payRequest.getExtraParamsMap().get("phone");
        payOrder.setPhone(null != phone ? phone : "");
        payOrder.setProductDesc(payRequest.getProductDesc());
        payOrder.setProductId(payRequest.getProductId());
        payOrder.setProductName(payRequest.getProductName());
        payOrder.setRemark(payRequest.getChannelHandler().generateRemark(payRequest));
        payOrder.setStatus("W");
        payOrder.setUserShow(payRequest.getUserShow());
        payOrder.setVersion(payRequest.getVersion());
        payOrder.setXunleiId(payRequest.getXunleiId());
        payOrder.setXunleiPayId(payRequest.getXunleiPayId());
        return payOrder;
    }

    @Override
    public ReturnResult processPayRequest(UnitedPayRequest payRequest, HttpServletRequest httpServletRequest) {
        ReturnResult validateResult = this.validateUnitedPayRequest(payRequest, httpServletRequest);
        if (validateResult != null) {
            logger.info("validate failed,return errorMsg");
            return validateResult;
        }
        payRequest.setXunleiPayId(XunleiPayIdUtils.generateXunleiPayId());
        payRequest.setOrderGroup(payRequest.getXunleiPayId());
        payRequest.setOrderType("A");
        return this.processPayRequest(payRequest);
    }

    private ReturnResult validateUnitedPayRequest(UnitedPayRequest payRequest, HttpServletRequest httpServletRequest) {
        ReturnResult unitedValidateResult = this.validateUnitedParams(payRequest, httpServletRequest);
        return unitedValidateResult == null ? this.validateChannelParams(payRequest) : unitedValidateResult;
    }

    private ReturnResult validateUnitedParams(UnitedPayRequest payRequest, HttpServletRequest httpServletRequest) {
        String errorMsg = ValidateUtils.validateToString((Object)payRequest);
        if (null != errorMsg) {
            logger.info("validate failed:{}", (Object)errorMsg);
            return new ReturnResult(InterfaceReqResult.FAIL, "13", errorMsg, "pay_fail_page");
        }
        if (ChildrenUserUtils.checkIsChildrenAccount(payRequest.getXunleiId(), payRequest.getUserShow())) {
            logger.info("validate failed:\u5b50\u8d26\u53f7\u4e0d\u5141\u8bb8\u652f\u4ed8");
            return new ReturnResult(InterfaceReqResult.FAIL, "10", "\u5b50\u8d26\u53f7\u4e0d\u5141\u8bb8\u652f\u4ed8", "pay_fail_page");
        }
        String bizKey = this.bizUtil.getBizKey(payRequest.getBizNo());
        logger.debug("bizKey:{}", (Object)bizKey);
        if (bizKey == null) {
            logger.info("validate failed:invalid bizNo:{}", (Object)payRequest.getBizNo());
            return new ReturnResult(InterfaceReqResult.FAIL, "14", "\u5546\u6237\u53f7\u65e0\u6548", "pay_fail_page");
        }
        logger.debug("\u8fdb\u884c\u7b7e\u540d\u5224\u65ad");
        Map<String, String> params = this.generatePayRequestMap(httpServletRequest);
        params.put("sign", payRequest.getSign());
        if (!SignatureUtils.checkSign(params, (String)bizKey, (String)"sign")) {
            logger.info("validate failed:invalid sign");
            return new ReturnResult(InterfaceReqResult.FAIL, "11", "\u7b7e\u540d\u9519\u8bef", "pay_fail_page");
        }
        int payOrderCount = this.payOrderDAO.getCountByBizNoAndBizOrderId(payRequest.getBizNo(), payRequest.getBizOrderId());
        if (payOrderCount > 0) {
            logger.info("validate failed:duplicated bizOrderId...bizNo:{},bizOrderId:{}", (Object)payRequest.getBizNo(), (Object)payRequest.getBizOrderId());
            return new ReturnResult(InterfaceReqResult.FAIL, "12", "\u8ba2\u5355\u53f7\u91cd\u590d", "pay_fail_page");
        }
        String realPayType = this.channelConfigInfoUtils.getConfigValue(REAL_PAYTYPE_GROUP_ID, payRequest.getPayType());
        if (Strings.isNullOrEmpty((String)realPayType)) {
            realPayType = payRequest.getPayType();
        }
        logger.debug("realPayType:{}", (Object)realPayType);
        ChannelHandler<?> channelHandler = this.channelHandlerMapping.getChannelHanderByPayType(realPayType);
        if (null == channelHandler) {
            logger.error("validate failed:invalid payType:{}", (Object)payRequest.getPayType());
            return new ReturnResult(InterfaceReqResult.FAIL, "17", "\u65e0\u6548\u7684\u652f\u4ed8\u65b9\u5f0f", "pay_fail_page");
        }
        payRequest.setChannelHandler(channelHandler);
        payRequest.setRealPayType(realPayType);
        return null;
    }

    private Map<String, String> generatePayRequestMap(UnitedPayRequest payRequest) {
        try {
            Map mapFromObjectTrim = ObjectUtil.getMapFromObjectWithNonStaticPrimitiveTypeAndTrim((Object)payRequest);
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            for (Map.Entry stringObjectEntry : mapFromObjectTrim.entrySet()) {
                Object value = stringObjectEntry.getValue();
                if (value == null) continue;
                paramsMap.put((String)stringObjectEntry.getKey(), value.toString());
            }
            return paramsMap;
        }
        catch (Exception e) {
            logger.error("caught error when getting map from object: " + payRequest, (Throwable)e);
            return new HashMap<String, String>();
        }
    }

    private Map<String, String> generatePayRequestMap(HttpServletRequest httpServletRequest) {
        Enumeration parameterNames = httpServletRequest.getParameterNames();
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            String value = httpServletRequest.getParameter(name);
            paramsMap.put(name, value);
        }
        return paramsMap;
    }

    private Map<String, String> _generatePayRequestMap(UnitedPayRequest payRequest) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!Strings.isNullOrEmpty((String)payRequest.getAntiPhishingKey())) {
            params.put("anti_phishing_key", payRequest.getAntiPhishingKey());
        }
        params.put("biz_no", payRequest.getBizNo());
        params.put("biz_order_id", payRequest.getBizOrderId());
        if (!Strings.isNullOrEmpty((String)payRequest.getClientIp())) {
            params.put("client_ip", payRequest.getClientIp());
        }
        if (!Strings.isNullOrEmpty((String)payRequest.getExtendParam())) {
            params.put("extend_param", payRequest.getExtendParam());
        }
        if (!Strings.isNullOrEmpty((String)payRequest.getExtraCommonParam())) {
            params.put("extra_common_param", payRequest.getExtraCommonParam());
        }
        params.put("input_charset", payRequest.getInputCharset());
        if (!Strings.isNullOrEmpty((String)payRequest.getNeedPhishingCheck())) {
            params.put("need_phishing_check", payRequest.getNeedPhishingCheck());
        }
        params.put("notify_url", payRequest.getNotifyUrl());
        params.put("page_url", payRequest.getPageUrl());
        params.put("pay_type", payRequest.getPayType());
        if (!Strings.isNullOrEmpty((String)payRequest.getProductDesc())) {
            params.put("product_desc", payRequest.getProductDesc());
        }
        params.put("product_id", String.valueOf(payRequest.getProductId()));
        params.put("product_name", payRequest.getProductName());
        params.put("sign_type", payRequest.getSignType());
        params.put("user_show", payRequest.getUserShow());
        params.put("version", payRequest.getVersion());
        params.put("xunlei_id", payRequest.getXunleiId());
        params.put("order_amt", payRequest.getOrderAmt() + "");
        return params;
    }

    public ReturnResult validateChannelParams(UnitedPayRequest payRequest) {
        return payRequest.getChannelHandler().validateSpecialParams(payRequest);
    }

    public ReturnResult processPayRequest(UnitedPayRequest payRequest) {
        PayOrder payOrder = this.generatePayOrder(payRequest);
        this.savePayOrder(payOrder);
        return payRequest.getChannelHandler().generateChannelResult(payRequest);
    }
}

