/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.unicommobilepay;

import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.dao.PayOrderOkDAO;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.utils.BizUtil;
import com.xunlei.channel.gateway.common.utils.SignatureUtils;
import com.xunlei.channel.gateway.notice.service.PayNoticeService;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobilePayChannelData;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobilePayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobilePayException;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobilePayUtil;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobileResponseCode;
import com.xunlei.xlcommons.util.http.HttpClientUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnicomMobilePayChannelService
extends AbstractChannelService {
    private static final Logger logger = LoggerFactory.getLogger(UnicomMobilePayChannelService.class);
    @Autowired
    private PayOrderDAO payOrderDAO;
    @Autowired
    private PayOrderOkDAO payOrderOkDAO;
    @Autowired
    private UnicomMobilePayChannelInfo channelInfo;
    @Autowired
    private PayNoticeService noticeService;
    @Autowired
    private BizUtil bizUtil;

    public void executeCallback(HttpServletRequest request, UnicomMobilePayChannelInfo channelInfo) throws Exception {
        String bizExt;
        String transactionId;
        String outTradeNo = request.getParameter("outTradeNo");
        String paymentCodeSms = request.getParameter("paymentcodesms");
        String sign = request.getParameter("signMsg");
        PayOrder payOrder = this.payOrderDAO.getPayOrderByPayTypeAndChannelOrderId("LT", outTradeNo);
        if (null == payOrder) {
            logger.info("outTradeNo: {}, not found the order!", (Object)outTradeNo);
            PayOrderOk payOrderOk = this.payOrderOkDAO.getPayOrderOkByPayTypeAndChannelOrderId("LT", outTradeNo);
            if (null == payOrderOk) {
                logger.info("bizExt(outTradeNo): {}, not found the ok order!", (Object)outTradeNo);
                String msg = "outTradeNo:{" + outTradeNo + "},order does not exist!";
                throw new UnicomMobilePayException(msg, UnicomMobileResponseCode.RTN4.getCode());
            }
            logger.info("outTradeNo:[{}],order has already success!", (Object)outTradeNo);
            String biznoOrderStatus = payOrderOk.getSendNoticeStatus();
            if (!"Y".equals(biznoOrderStatus)) {
                logger.info("\u5728\u4e1a\u52a1\u6210\u529f\u8ba2\u5355\u4e2d\u67e5\u5230\u4e86,\u4f46\u662f\u901a\u77e5\u72b6\u6001\u4e0d\u662f\u6210\u529f!");
                this.noticeService.sendPayOrderOkNotice(payOrderOk.getXunleiPayId());
            }
            return;
        }
        PayOrderOk payOrderOk = this.payOrderOkDAO.getPayOrderOkByPayTypeAndChannelOrderId("LT", outTradeNo);
        if (null != payOrderOk) {
            logger.info("outTradeNo:[{}],order has already success!", (Object)outTradeNo);
            String biznoOrderStatus = payOrderOk.getSendNoticeStatus();
            if (!"Y".equals(biznoOrderStatus)) {
                logger.info("\u5728\u4e1a\u52a1\u6210\u529f\u8ba2\u5355\u4e2d\u67e5\u5230\u4e86,\u4f46\u662f\u901a\u77e5\u72b6\u6001\u4e0d\u662f\u6210\u529f!");
                this.noticeService.sendPayOrderOkNotice(payOrderOk.getXunleiPayId());
            }
            return;
        }
        if (payOrder.getStatus().equals("F")) {
            String errorMsg = "order is already failed, pleas reorder!";
            throw new UnicomMobilePayException(errorMsg, UnicomMobileResponseCode.RTN2.getCode());
        }
        String orderId = payOrder.getXunleiPayId();
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("outTradeNo", outTradeNo);
        params.put("paymentcodesms", paymentCodeSms);
        params.put("signMsg", sign);
        if (!this.checkSign(params, payOrder)) {
            throw new UnicomMobilePayException("sign error!", UnicomMobileResponseCode.RTN1001.getCode());
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String timeStamp = sdf.format(new Date());
        params.put("timeStamp", timeStamp);
        params.put("sign", UnicomMobilePayUtil.createToken(params, channelInfo.getConfigValue("key")));
        params.put("pid", channelInfo.getConfigValue("pid"));
        params.put("svcid", channelInfo.getConfigValue("svcid"));
        params.put("paymentUser", payOrder.getPhone());
        logger.info("send params: {}, orderid: {}", params, (Object)orderId);
        String response = HttpClientUtil.doGet((String)channelInfo.getConfigValue(UnicomMobilePayChannelInfo.CALLBACK_URL), params, null);
        logger.info("get response: {}, orderId: {} ", (Object)response, (Object)orderId);
        Map<String, String> map = UnicomMobilePayUtil.json2map(response);
        logger.info("change to map get params: {}, orderId is: {}", map, (Object)orderId);
        String resultCode = map.get("resultCode");
        if ("0".equals(resultCode)) {
            transactionId = map.get("transactionId");
            bizExt = payOrder.getBizExt();
            if (bizExt.contains("=")) {
                bizExt = bizExt + "^";
            }
        } else {
            String errorCode = map.get("errorCode");
            String errorDesc = map.get("errorDesc");
            if (errorCode == null || errorCode.equals("")) {
                errorCode = map.get("resultCode");
                errorDesc = map.get("resultDescription");
            }
            this.processPayFail(payOrder, errorCode, errorDesc, outTradeNo, payOrder.getExtraJson());
            if (UnicomMobilePayUtil.isContainsFullWidth(errorDesc)) {
                errorDesc = UnicomMobilePayUtil.stringToUnicode(errorDesc);
            }
            throw new UnicomMobilePayException(errorDesc, errorCode);
        }
        bizExt = bizExt + "ext2=" + transactionId;
        this.payOrderDAO.updateBizExtByXunleiPayId(bizExt, payOrder.getXunleiPayId());
        String successTime = UnicomMobilePayUtil.formatTime(timeStamp);
        UnicomMobilePayChannelData channelData = new UnicomMobilePayChannelData();
        channelData.setOutTradeNo(outTradeNo);
        channelData.setOrderAmt(payOrder.getOrderAmt());
        channelData.setSuccessTime(successTime);
        double rateOfCharge = Double.parseDouble(channelInfo.getConfigValue("rate_of_charge"));
        channelData.setFareAmt((int)((double)payOrder.getOrderAmt() * rateOfCharge));
        channelData.setFactAmt((int)((double)payOrder.getOrderAmt() * (1.0 - rateOfCharge)));
        this.processPaySuccess(payOrder, channelData);
    }

    public boolean checkSign(Map paramsMap, PayOrder payOrder) {
        String bizKey = this.bizUtil.getBizKey(payOrder.getBizNo());
        boolean b = SignatureUtils.checkSign((Map)paramsMap, (String)bizKey, (String)"signMsg");
        if (b) {
            if (logger.isDebugEnabled()) {
                logger.debug("checkSign... paramsMap: {}, payOrder: {}, result: {}", new Object[]{paramsMap, payOrder, b});
            }
        } else {
            logger.warn("checkSign... paramsMap: {}, payOrder: {}, result: {}", new Object[]{paramsMap, payOrder, b});
        }
        return b;
    }
}

