/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.cardpay;

import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.DirectReturnResult;
import com.xunlei.channel.gateway.common.result.ReturnResult;
import com.xunlei.channel.gateway.pay.annotation.PayType;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelHandler;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftCode;
import com.xunlei.channel.gateway.pay.channels.cardpay.XLCardPayChannelData;
import com.xunlei.channel.gateway.pay.channels.cardpay.XLCardPayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.cardpay.XLCardPayChannelService;
import com.xunlei.channel.gateway.pay.channels.cardpay.XLCardPayUtils;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import com.xunlei.xlcommons.util.Date.DateUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PayType(value="S", desc="\u8fc5\u96f7\u76f4\u5145")
public class XLCardPayChannelHandler
extends AbstractChannelHandler<ReturnResult> {
    private static final Logger logger = LoggerFactory.getLogger(XLCardPayChannelHandler.class);
    @Autowired
    private XLCardPayChannelInfo xLCardPayChannelInfo;
    @Autowired
    private XLCardPayChannelService xLCardPayChannelService;

    @Override
    public ReturnResult generateChannelResult(UnitedPayRequest unitedPayRequest) {
        try {
            XLCardPayChannelData cardPayChannelData = this.dealCommit(unitedPayRequest);
            if (cardPayChannelData.getIsSuccess()) {
                logger.info(cardPayChannelData.getOrderId() + " save success!");
                return this.dealResult(cardPayChannelData.getReqData(), cardPayChannelData);
            }
            logger.error(cardPayChannelData.getOrderId() + " save or request with exception,please check it!");
            return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "pay failed", "pay_fail_page", null);
        }
        catch (Exception e) {
            logger.error("\u672a\u77e5\u9519\u8bef1! {}", (Throwable)e);
            return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "pay failed", "pay_fail_page", null);
        }
    }

    private XLCardPayChannelData getCardPayChannelData(UnitedPayRequest unitedPayRequest) {
        XLCardPayChannelData cardpayChannelData = new XLCardPayChannelData();
        cardpayChannelData.setPageCharset(this.xLCardPayChannelInfo.getInputCharset());
        cardpayChannelData.setNotifyUrl(this.xLCardPayChannelInfo.getNotifyUrl());
        cardpayChannelData.setBizSysNo(this.xLCardPayChannelInfo.getBizSysNo());
        cardpayChannelData.setOrderId(unitedPayRequest.getXunleiPayId());
        cardpayChannelData.setOrderamt("" + unitedPayRequest.getOrderAmt());
        cardpayChannelData.setCardNo(unitedPayRequest.getExtraParam("phone"));
        cardpayChannelData.setCardpwd(unitedPayRequest.getExtraParam("pwd"));
        cardpayChannelData.setXunleiId(unitedPayRequest.getXunleiId());
        cardpayChannelData.setProductName(unitedPayRequest.getProductName());
        cardpayChannelData.setProductDesc(unitedPayRequest.getProductDesc());
        cardpayChannelData.setInputIp(unitedPayRequest.getClientIp());
        cardpayChannelData.setUserShow(unitedPayRequest.getUserShow());
        cardpayChannelData.setExt1(unitedPayRequest.getExtraParam("ext1"));
        cardpayChannelData.setExt2(unitedPayRequest.getExtraParam("ext2"));
        cardpayChannelData.setOrderTime(DateUtil.getCurrentTime((String)"yyyyMMddHHmmss"));
        logger.debug("begin to sign message for cardpay");
        String signMsg = XLCardPayUtils.genCardpayReqSignMsg(cardpayChannelData, this.xLCardPayChannelInfo.getBizKey());
        logger.debug("signMsg:" + signMsg);
        cardpayChannelData.setSignMsg(signMsg);
        return cardpayChannelData;
    }

    private XLCardPayChannelData dealCommit(UnitedPayRequest unitedPayRequest) throws ParseException, IOException {
        XLCardPayChannelData cardPayData = this.getCardPayChannelData(unitedPayRequest);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httppost = new HttpPost(this.xLCardPayChannelInfo.getPayUrl());
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        if (this.checkParams("pagecharset", cardPayData.getPageCharset())) {
            nvps.add(new BasicNameValuePair("pagecharset", cardPayData.getPageCharset()));
        }
        if (this.checkParams("notifyurl", cardPayData.getNotifyUrl())) {
            nvps.add(new BasicNameValuePair("notifyurl", cardPayData.getNotifyUrl()));
        }
        if (this.checkParams("bizsysno", cardPayData.getBizSysNo())) {
            nvps.add(new BasicNameValuePair("bizsysno", cardPayData.getBizSysNo()));
        }
        if (this.checkParams("orderid", cardPayData.getOrderId())) {
            nvps.add(new BasicNameValuePair("orderid", cardPayData.getOrderId()));
        }
        if (this.checkParams("orderamt", cardPayData.getOrderamt())) {
            nvps.add(new BasicNameValuePair("orderamt", "" + cardPayData.getOrderamt()));
        }
        if (this.checkParams("ordertime", cardPayData.getOrderTime())) {
            nvps.add(new BasicNameValuePair("ordertime", cardPayData.getOrderTime()));
        }
        if (this.checkParams("cardno", cardPayData.getCardNo())) {
            nvps.add(new BasicNameValuePair("cardno", cardPayData.getCardNo()));
        }
        if (this.checkParams("cardpwd", cardPayData.getCardpwd())) {
            nvps.add(new BasicNameValuePair("cardpwd", cardPayData.getCardpwd()));
        }
        if (this.checkParams("xluser", cardPayData.getUserShow())) {
            logger.info("nvps.xluser=" + cardPayData.getUserShow());
            nvps.add(new BasicNameValuePair("xluser", cardPayData.getUserShow()));
        }
        if (this.checkParams("xlinnerid", cardPayData.getXunleiId())) {
            logger.info("nvps.xlinnerid=" + cardPayData.getXunleiId());
            nvps.add(new BasicNameValuePair("xlinnerid", cardPayData.getXunleiId()));
        }
        if (this.checkParams("productname", cardPayData.getProductName())) {
            nvps.add(new BasicNameValuePair("productname", cardPayData.getProductName()));
        }
        if (this.checkParams("productdesc", cardPayData.getProductDesc())) {
            nvps.add(new BasicNameValuePair("productdesc", cardPayData.getProductDesc()));
        }
        if (this.checkParams("clientip", cardPayData.getInputIp())) {
            nvps.add(new BasicNameValuePair("clientip", cardPayData.getInputIp()));
        }
        if (this.checkParams("ext1", cardPayData.getExt1())) {
            nvps.add(new BasicNameValuePair("ext1", cardPayData.getExt1()));
        }
        if (this.checkParams("ext2", cardPayData.getExt2())) {
            nvps.add(new BasicNameValuePair("ext2", cardPayData.getExt2()));
        }
        nvps.add(new BasicNameValuePair("sign", cardPayData.getSignMsg()));
        HttpResponse response = null;
        try {
            logger.debug("nvgs: {}", (Object)((Object)nvps).toString());
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            logger.debug("httppost: {}", (Object)httppost.toString());
            response = httpclient.execute((HttpUriRequest)httppost);
            if (response == null) {
                cardPayData.setIsSuccess(false);
                logger.info(cardPayData.getOrderId() + " conntected time out!");
                return cardPayData;
            }
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() != 200) {
                cardPayData.setIsSuccess(false);
                logger.info(cardPayData.getOrderId() + "'s statuscode is " + status.getStatusCode());
                return cardPayData;
            }
            String xmlResult = EntityUtils.toString((HttpEntity)response.getEntity());
            logger.info("xmlResult: {}", (Object)xmlResult);
            if (null == xmlResult || "".equals(xmlResult) || "null".equals(xmlResult)) {
                cardPayData.setIsSuccess(false);
                logger.error(cardPayData.getOrderId() + "'s xmlResult is null or ''");
                return cardPayData;
            }
            cardPayData.setReqData(xmlResult);
            cardPayData.setIsSuccess(true);
            logger.info("cardPayData {}", (Object)cardPayData);
        }
        catch (Exception ex) {
            logger.error("pay with exection:pay url=" + this.xLCardPayChannelInfo.getPayUrl());
            logger.error("exception message:" + ex.getMessage());
        }
        return cardPayData;
    }

    private boolean checkParams(String key, String value) {
        return null != value && !"".equals(value) && !"null".equals(value) && value.length() != 0;
    }

    private DirectReturnResult dealResult(String xmlResult, XLCardPayChannelData cardPayData) {
        logger.info("xmlResult:" + xmlResult);
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)xmlResult);
        }
        catch (DocumentException e) {
            logger.debug("\u8bfb\u5165xml\u51fa\u9519");
            return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "parse xml failed", "pay_fail_page", null);
        }
        Element root = document.getRootElement();
        String is_success = root.element("is_success").getText();
        String orderid = cardPayData.getOrderId();
        if ("Y".equals(is_success)) {
            PayOrder payOrder = this.xLCardPayChannelService.getPayOrder(orderid);
            if (payOrder != null) {
                PayOrderOk payOrderOk = this.xLCardPayChannelService.dealWithPayOrder(payOrder, cardPayData);
                if (payOrderOk == null) {
                    return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "ok", "pay_fail_page", null);
                }
                return new DirectReturnResult(InterfaceReqResult.SUCCESS, ArSoftCode.RTN0.getCode(), "pay successfully", "pay_success_page", null);
            }
        } else {
            return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "pay failed", "pay_fail_page", null);
        }
        return null;
    }
}

