/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.arsoft;

import com.xunlei.channel.db.dao.ChannelAutoPayQuitDAO;
import com.xunlei.channel.db.dao.ChannelAutoPayResultDAO;
import com.xunlei.channel.db.dao.ContactReqDAO;
import com.xunlei.channel.db.dao.ContactResultDAO;
import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.pojo.ChannelAutoPayQuit;
import com.xunlei.channel.db.pojo.ChannelAutoPayResult;
import com.xunlei.channel.db.pojo.ContactReq;
import com.xunlei.channel.db.pojo.ContactResult;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.utils.StringUtils;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftChannelData;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftChannelHandler;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftChannelInfo;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftChannelUtils;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArSoftNoticeService
extends AbstractChannelService {
    private static final Logger logger = LoggerFactory.getLogger(ArSoftNoticeService.class);
    private static final String[][] sqlhandles = new String[][]{{"'", "`"}, {"<", ""}, {">", ""}};
    private static final String SUCCESS = "success";
    private static final String FAIL = "fail";
    @Autowired
    private ArSoftChannelInfo arSoftChannelInfo;
    @Autowired
    private PayOrderDAO payOrderDAO;
    @Autowired
    private ChannelAutoPayResultDAO channelAutoPayResultDAO;
    @Autowired
    private ChannelAutoPayQuitDAO channelAutoPayQuitDAO;
    @Autowired
    private ContactReqDAO contactReqDAO;
    @Autowired
    private ContactResultDAO contactResultDAO;
    @Autowired
    private ArSoftChannelHandler handler;

    public String returnNotify(HttpServletRequest request) {
        logger.info("receive notice...params:{}", (Object)this.getRequestParams(request));
        String xunleiPayId = this.getFilterParameter(request, "app_orderid");
        String orderStatus = this.getFilterParameter(request, "status");
        String isRenew = this.getFilterParameter(request, "is_renew");
        String validate = this.getFilterParameter(request, "sign");
        String isMonthly = this.getFilterParameter(request, "is_monthly");
        String statusDesc = this.getFilterParameter(request, "status_desc");
        String asOrderId = this.getFilterParameter(request, "orderid");
        String recAmt = this.getFilterParameter(request, "rec_amount");
        String payTime = this.getFilterParameter(request, "pay_time");
        Map<String, String> noticeParams = this.createNoticeParams(request);
        String sign = ArSoftChannelUtils.createToken(noticeParams, this.arSoftChannelInfo.getKey());
        logger.info("the xunleiPayId:{} and the status:{}", (Object)xunleiPayId, (Object)orderStatus);
        if (!ArSoftChannelUtils.checkSign(sign, validate.toUpperCase())) {
            logger.error("signature mismatch for xunleiPayId:{},sign:{},ours:{}", new Object[]{xunleiPayId, validate, sign});
            return FAIL;
        }
        PayOrder payOrder = this.payOrderDAO.getPayOrder(xunleiPayId);
        if (payOrder == null) {
            logger.error("No PayOrder found for xunleiPayId:{},return failed", (Object)xunleiPayId);
            return FAIL;
        }
        if (recAmt.equals(payOrder.getOrderAmt())) {
            logger.error("Order amt mismatch...xunleiPayId:{},orderAmt:{},rec_amount:{}", new Object[]{xunleiPayId, payOrder.getOrderAmt(), recAmt});
            return FAIL;
        }
        if ("1".equals(orderStatus)) {
            if ("2".equals(isRenew)) {
                ChannelAutoPayResult result = this.channelAutoPayResultDAO.getChannelAutoPayResult(payOrder.getXunleiId(), payOrder.getXunleiPayId());
                if (payTime.equals(result.getRemark())) {
                    logger.info("duplicated renew notice for xunleiPayId:{}", (Object)xunleiPayId);
                    return SUCCESS;
                }
                this.checkContactResult(payOrder);
                return this.autoPayNotice(payOrder, isMonthly, asOrderId, payTime, result);
            }
            if (!"T".equals(payOrder.getStatus())) {
                logger.error("xunleiPayId:{},status:{} is not T,return failed", (Object)xunleiPayId, (Object)payOrder.getStatus());
                return FAIL;
            }
            if ("2".equals(isMonthly)) {
                logger.info("xunleiPayId:{} is monthly,check contact", (Object)xunleiPayId);
                this.checkContactResult(payOrder);
                this.addChannelAutoPayResult(payOrder);
                ContactReq req = this.contactReqDAO.getContactReqbySignNo(payOrder.getXunleiId(), payOrder.getXunleiPayId());
                if (req != null) {
                    req.setStatus("S");
                    this.contactReqDAO.updateContactReq(req);
                } else {
                    logger.warn("No ContactReqthe found for xunleiPayId:{}", (Object)xunleiPayId);
                }
            }
            ArSoftChannelData data = new ArSoftChannelData();
            data.setAmount(recAmt);
            data.setAppOrderid(xunleiPayId);
            data.setIsMonthly(isMonthly);
            data.setOrderId(asOrderId);
            PayOrderOk payOrderOk = this.processPaySuccess(payOrder, data);
            if (payOrderOk != null) {
                logger.info("pay success for the xunleiPayId:{}", (Object)xunleiPayId);
                return SUCCESS;
            }
            logger.error("pay failed for the xunleiPayId:{}", (Object)xunleiPayId);
            return FAIL;
        }
        if ("2".equals(orderStatus)) {
            if (!"T".equals(payOrder.getStatus())) {
                logger.error("the xunleiPayId:{} is not the status of waiting for noticing,status:{}", (Object)xunleiPayId, (Object)payOrder.getStatus());
                return FAIL;
            }
            logger.info("order pay failed...xunleiPayId:{}, statusDesc:{}", (Object)xunleiPayId, (Object)statusDesc);
            this.payOrderDAO.updatePayOrderStatusAndChannelId(xunleiPayId, "F", asOrderId);
            return SUCCESS;
        }
        if ("3".equals(orderStatus)) {
            logger.info("unsubscribe...xunleiPayId:{}", (Object)xunleiPayId);
            ContactResult contactResult = this.contactResultDAO.getContactResultbySignNo(payOrder.getXunleiId(), payOrder.getXunleiPayId());
            if (contactResult == null) {
                logger.error("No ContactResult found for xunleiPayId:{}", (Object)xunleiPayId);
                return FAIL;
            }
            if ("JY".equals(contactResult.getTheType())) {
                logger.error("xunleiPayId:{} has been already unsubscribed,return success", (Object)xunleiPayId);
                return SUCCESS;
            }
            contactResult.setTheType("JY");
            contactResult.setRemark("unsubscribe");
            this.contactResultDAO.updateContactResult(contactResult);
            this.createChannelAutoPayQuit(payOrder);
            return SUCCESS;
        }
        if ("4".equals(orderStatus)) {
            logger.info("renew faild for xunleiPayId:{},nothing to do for that", (Object)xunleiPayId);
            return SUCCESS;
        }
        logger.error("unknown youyifu order status:{} for xunleiPayId:{}", (Object)orderStatus, (Object)xunleiPayId);
        return FAIL;
    }

    private void addChannelAutoPayResult(PayOrder payOrder) {
        ChannelAutoPayResult result = new ChannelAutoPayResult();
        result.setUserShow(payOrder.getUserShow());
        result.setXunleiPayId(payOrder.getXunleiPayId());
        result.setBizNo(payOrder.getBizNo());
        result.setXunleiId(payOrder.getXunleiId());
        result.setPayType(payOrder.getPayType());
        result.setBizOrderId(payOrder.getBizOrderId());
        result.setChannelOrderId(payOrder.getChannelOrderId());
        result.setInputTime(new Date());
        result.setNotifyUrl(this.arSoftChannelInfo.getNotiUrl());
        result.setOrderAmt(Integer.valueOf(Integer.parseInt(this.arSoftChannelInfo.getOrderAmt())));
        result.setSuccessCount(Integer.valueOf(0));
        result.setSuccessTime(new Date());
        result.setPeriod("M");
        result.setProductId(Long.valueOf(payOrder.getProductId()));
        logger.info("contact success, the orderId is {}", (Object)payOrder.getXunleiPayId());
        this.channelAutoPayResultDAO.saveChannelAutoPayResult(result);
    }

    private void checkContactResult(PayOrder payOrder) {
        ContactResult contactResult = this.contactResultDAO.getContactResultByXunleiIdAndPayType(payOrder.getXunleiId(), payOrder.getPayType());
        if (null != contactResult) {
            if (!"QY".equals(contactResult.getTheType()) || !"S".equals(contactResult.getStatus())) {
                logger.info("update ContactResult for xunleiId:{}", (Object)payOrder.getXunleiId());
                contactResult.setStatus("S");
                contactResult.setTheType("QY");
                contactResult.setRemark("update by renew");
                this.contactResultDAO.updateContactResult(contactResult);
            }
        } else {
            contactResult = new ContactResult();
            contactResult.setPayType(payOrder.getPayType());
            contactResult.setProductId(Long.valueOf(payOrder.getProductId()));
            contactResult.setSignNo(payOrder.getXunleiPayId());
            contactResult.setStatus("S");
            contactResult.setUserShow(payOrder.getUserShow());
            contactResult.setXunleiId(payOrder.getXunleiId());
            contactResult.setExtraJson("");
            contactResult.setTheType("QY");
            this.contactResultDAO.saveContactResult(contactResult);
        }
    }

    public void processReContact(PayOrder payOrder, String asOrderId) {
        ContactResult result = this.contactResultDAO.getContactResultByXunleiIdAndPayType(payOrder.getXunleiId(), payOrder.getPayType());
        if (null == result) {
            logger.error("No ContactResult found for xunleiId:{},payType:{},this should not be happen because we received renew order this time", (Object)payOrder.getXunleiId(), (Object)payOrder.getPayType());
            ContactReq contactRequest = this.contactReqDAO.getContactReqbySignNo(payOrder.getXunleiId(), payOrder.getXunleiPayId());
            if (null == contactRequest) {
                logger.error("No ContactReq found for xunleiId:{},signNo:{},this should not be happen because we receive renew order this time", (Object)payOrder.getXunleiId(), (Object)payOrder.getXunleiPayId());
                contactRequest = this.handler.createContactRequest(payOrder);
            }
            this.processContact(contactRequest, payOrder);
        } else if (!"QY".equals(result.getTheType()) || !"S".equals(result.getStatus())) {
            logger.info("update ContactResult for xunleiId:{}", (Object)payOrder.getXunleiId());
            result.setStatus("S");
            result.setTheType("QY");
            result.setRemark("update by renew");
            this.contactResultDAO.updateContactResult(result);
        }
    }

    private void processContact(ContactReq req, PayOrder payOrder) {
        ContactResult contactResult = new ContactResult();
        contactResult.setPayType(req.getPayType());
        contactResult.setProductId(req.getProductId());
        contactResult.setSignNo(req.getSignNo());
        contactResult.setStatus("S");
        contactResult.setUserShow(req.getUserShow());
        contactResult.setXunleiId(req.getXunleiId());
        contactResult.setExtraJson("");
        contactResult.setTheType("QY");
        this.contactResultDAO.saveContactResult(contactResult);
    }

    public String autoPayNotice(PayOrder payOrder, String isMonthly, String asOrderId, String payTime, ChannelAutoPayResult result) {
        String xunleiPayId = payOrder.getXunleiPayId();
        result.setSuccessTime(new Date());
        result.setSuccessCount(Integer.valueOf(result.getSuccessCount() + 1));
        result.setRemark(payTime);
        this.channelAutoPayResultDAO.updateChannelAutoPayResult(result);
        payOrder.setXunleiPayId(payOrder.getXunleiPayId() + "_" + result.getSuccessCount());
        payOrder.setRemark("renew" + result.getSuccessCount());
        payOrder.setBizExt(this.buildAutoPayNoticeExt(payOrder));
        payOrder.setNotifyUrl(this.arSoftChannelInfo.getAutoPayMonthlyNotifyUrl());
        payOrder.setChannelOrderId(asOrderId);
        payOrder.setBizOrderId(payOrder.getBizOrderId() + "_" + result.getSuccessCount());
        payOrder.setStatus("W");
        this.payOrderDAO.savePayOrder(payOrder);
        ArSoftChannelData data = new ArSoftChannelData();
        data.setAmount(payOrder.getOrderAmt() + "");
        data.setAppOrderid(xunleiPayId);
        data.setIsMonthly(isMonthly);
        data.setOrderId(asOrderId + "_" + result.getSuccessCount());
        PayOrderOk payOrderOk = this.processPaySuccess(payOrder, data);
        if (payOrderOk != null) {
            logger.info("process auto pay notice success for xunleiPayId:{}", (Object)xunleiPayId);
            return SUCCESS;
        }
        logger.error("process auto pay notice failed for xunleiPayId:{}", (Object)xunleiPayId);
        return FAIL;
    }

    private String buildAutoPayNoticeExt(PayOrder payOrder) {
        String xunleiId = payOrder.getXunleiId();
        String bizNo = payOrder.getBizNo();
        HashMap<String, String> bizMap = new HashMap<String, String>();
        bizMap.put("ext1", xunleiId);
        bizMap.put("ext2", bizNo);
        String ext = StringUtils.mapToStr(bizMap, (String)"^");
        if (logger.isDebugEnabled()) {
            logger.debug("buildAutoPayNoticeExt... xunleiId: {}, bizNo: {}, to ext: {}", new Object[]{xunleiId, bizNo, ext});
        }
        return ext;
    }

    private String getFilterParameter(HttpServletRequest request, String name) {
        String value = ArSoftNoticeService.escapeSql(request.getParameter(name)).trim();
        logger.debug("getFilterParameter... name: {}, filtered value: {}");
        return value;
    }

    private static final String escapeSql(String str) {
        if (str == null) {
            return "";
        }
        for (String[] ss : sqlhandles) {
            str = str.replaceAll(ss[0], ss[1]);
        }
        return str;
    }

    private Map<String, String> createNoticeParams(HttpServletRequest request) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            map.put(key, request.getParameter(key));
        }
        map.remove("sign");
        return map;
    }

    public void createChannelAutoPayQuit(PayOrder payOrder) {
        ChannelAutoPayQuit quit = new ChannelAutoPayQuit();
        quit.setBizNo(payOrder.getBizNo());
        quit.setBizOrderId(payOrder.getBizOrderId());
        quit.setCancelTime(new Date());
        quit.setOrderAmt(Integer.valueOf(payOrder.getOrderAmt()));
        quit.setPayType(payOrder.getPayType());
        quit.setPhone(payOrder.getPhone());
        quit.setQuitType("S");
        quit.setReqTime(new Date());
        quit.setStatus("S");
        quit.setUserShow(payOrder.getUserShow());
        quit.setXunleiId(payOrder.getXunleiId());
        quit.setXunleiPayId(payOrder.getXunleiPayId());
        this.channelAutoPayQuitDAO.saveChannelAutoPayQuit(quit);
    }
}

