/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels;

import com.xunlei.channel.gateway.pay.common.ChannelConfigInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractChannelInfo {
    private static final Logger logger = LoggerFactory.getLogger(AbstractChannelInfo.class);
    @Autowired
    private ChannelConfigInfoUtils channelConfigInfoUtils;

    protected abstract String getGroupId();

    public String getConfigValue(String propertyKey) {
        return this.channelConfigInfoUtils.getConfigValue(this.getGroupId(), propertyKey);
    }

    public double getConfigValueDouble(String propertyKey) {
        try {
            String value = this.getConfigValue(propertyKey);
            if (value == null) {
                return 0.0;
            }
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return 0.0;
        }
    }
}

