/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.vpay;

import com.google.common.base.Strings;
import com.xunlei.channel.db.pojo.AbstractOrder;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.pay.ChannelData;
import com.xunlei.channel.gateway.common.pojo.PayResult;
import com.xunlei.channel.gateway.common.utils.JsonUtils;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.vpay.VPayChannelInfo;
import com.xunlei.channel.gateway.pay.result.FailPageResult;
import com.xunlei.channel.gateway.pay.result.PageResult;
import com.xunlei.channel.thundercore.client.util.Arith;
import com.xunlei.xlcommons.util.MD5.Md5Encrypt;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VPayNotifyService
extends AbstractChannelService {
    private static final Logger logger = LoggerFactory.getLogger(VPayNotifyService.class);
    @Autowired
    VPayChannelInfo vPayChannelInfo;

    public PageResult pageNotify(HttpServletRequest request) {
        String rtMd5 = request.getParameter("v1");
        final String cardNo = Strings.nullToEmpty((String)request.getParameter("v2"));
        final String rtMi = Strings.nullToEmpty((String)request.getParameter("v3"));
        String cardAmt = request.getParameter("v4");
        final String cardType = request.getParameter("v5");
        final String vpayOrderId = Strings.nullToEmpty((String)request.getParameter("v6"));
        String orderId = request.getParameter("v7");
        String rtFlag = request.getParameter("v10");
        String spId = this.vPayChannelInfo.getConfigValue("sp_id");
        String spPwd = this.vPayChannelInfo.getConfigValue("sp_pwd");
        String toSign = cardNo + rtMi + vpayOrderId + spId + spPwd + orderId + rtFlag + cardAmt;
        logger.info("toSign:{}", (Object)toSign);
        String signMsg = Md5Encrypt.encode((String)toSign.trim(), (String)"UTF-8").toUpperCase();
        if (signMsg.equals(rtMd5)) {
            if (rtFlag.equals("1") || rtFlag.equals("2")) {
                int orderAmt;
                PayOrder payOrder = this.getPayOrderByXunleiPayId(orderId);
                if (null == payOrder) {
                    logger.error("cannot find payOrder with xunleiPayId:{},return fail", (Object)orderId);
                    return new FailPageResult("\u8ba2\u5355\u4e0d\u5b58\u5728");
                }
                if ("S".equals(payOrder.getStatus())) {
                    logger.info("payOrder:{} status was success,do nothing and return", (Object)orderId);
                    PayOrderOk payOrderOk = this.getPayOrderOkByXunleiPayId(payOrder.getXunleiPayId());
                    if (null != payOrderOk) {
                        return this.generatePageUrlAndParams((AbstractOrder)payOrderOk, PayResult.SUCCESS.getValue(), payOrderOk.getFareAmt());
                    }
                    logger.error("error,cannot find PayOrderOk...xunleiPayId:{}", (Object)payOrder.getXunleiPayId());
                    return this.generatePageUrlAndParams((AbstractOrder)payOrder, PayResult.SUCCESS.getValue(), 0);
                }
                try {
                    if (!this.vPayChannelInfo.getConfigValue("valid_card_type").contains(cardType)) {
                        logger.error("notify with invalid cardType:{}", (Object)cardType);
                        return new FailPageResult("\u652f\u4ed8\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u7a0d\u540e\u786e\u8ba4\u652f\u4ed8\u7ed3\u679c");
                    }
                    orderAmt = Integer.parseInt(cardAmt) * 100;
                    if (orderAmt != payOrder.getOrderAmt()) {
                        logger.error("notify with invalid orderAmt:{}", (Object)orderAmt);
                        return new FailPageResult("\u652f\u4ed8\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u7a0d\u540e\u786e\u8ba4\u652f\u4ed8\u7ed3\u679c");
                    }
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    return new FailPageResult("\u652f\u4ed8\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u7a0d\u540e\u786e\u8ba4\u652f\u4ed8\u7ed3\u679c");
                }
                orderAmt = payOrder.getOrderAmt();
                final double PAY_RATE = this.vPayChannelInfo.getConfigValueDouble("fee_rate");
                ChannelData channelData = new ChannelData(){

                    public int getFareAmt() {
                        return (int)Arith.mul((double)orderAmt, (double)PAY_RATE);
                    }

                    public int getFactAmt() {
                        return orderAmt - (int)Arith.mul((double)orderAmt, (double)PAY_RATE);
                    }

                    public String getChannelOrderId() {
                        return vpayOrderId;
                    }

                    public String generateOkExtJson() {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("card_no", cardNo);
                        map.put("card_pwd", rtMi);
                        map.put("card_type", cardType);
                        return JsonUtils.toJson(map);
                    }
                };
                try {
                    PayOrderOk payOrderOk = this.processPaySuccess(payOrder, channelData);
                    return this.generatePageUrlAndParams((AbstractOrder)payOrderOk, PayResult.SUCCESS.getValue(), payOrderOk.getFareAmt());
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    return new FailPageResult("\u652f\u4ed8\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u7a0d\u540e\u786e\u8ba4\u652f\u4ed8\u7ed3\u679c");
                }
            }
            logger.error("vpay notify rtFlag:{} not success", (Object)rtFlag);
            return new FailPageResult("\u652f\u4ed8\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u7a0d\u540e\u786e\u8ba4\u652f\u4ed8\u7ed3\u679c");
        }
        logger.error("vpay notify sign:{} not equals local sign:{}", (Object)rtMd5, (Object)signMsg);
        return new FailPageResult("\u6570\u636e\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u786e\u8ba4\u652f\u4ed8\u7ed3\u679c");
    }
}

