/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.thunderpay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.DirectReturnResult;
import com.xunlei.channel.gateway.common.utils.HttpUtils;
import com.xunlei.channel.gateway.pay.annotation.PayType;
import com.xunlei.channel.gateway.pay.channels.thunderpay.AbstractThunderpayHandler;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.ClientProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@PayType(value="A1", desc="\u96f7\u70b9\u5bc6\u7801\u652f\u4ed8")
public class ThunderpayWithPwdHandler
extends AbstractThunderpayHandler {
    private static final Logger logger = LoggerFactory.getLogger(ThunderpayWithPwdHandler.class);

    @Override
    protected DirectReturnResult checkPwd(String xunleiId, String password) {
        Map<String, Object> pwdResMap = this.checkPayPwd(xunleiId, password);
        boolean pwdRight = (Boolean)pwdResMap.get("pwdRight");
        if (pwdRight) {
            return null;
        }
        String errCode = (String)pwdResMap.get("errCode");
        String errMsg = (String)pwdResMap.get("errMsg");
        logger.info("xunleiId:{},payType:A1,password is illegal!errCode:{},errMsg:{}", new Object[]{xunleiId, errCode, errMsg});
        return new DirectReturnResult(InterfaceReqResult.FAIL, errCode, errMsg, "pay_fail_page", null);
    }

    protected Map<String, Object> checkPayPwd(String userId, String paypwd) {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        logger.debug("A1\u652f\u4ed8\u65b9\u5f0f\uff0c\u5bc6\u7801\u9a8c\u8bc1\u5f00\u59cb...");
        String urlStr = this.thunderpayChannelInfo.getPwdUrl();
        String url = urlStr + "/validateMimaMd5.do?userid=" + userId + "&mima=" + paypwd;
        logger.info("A1_pwd_request:{}", (Object)url);
        try {
            String respJson = this.request(url);
            logger.info("A1_pwd_response:{}", (Object)respJson);
            JSONObject jsonObj = JSON.parseObject((String)respJson);
            int rtn = jsonObj.getIntValue("rtn");
            JSONObject dataObj = jsonObj.getJSONObject("data");
            int ret = dataObj.getIntValue("ret");
            if (rtn == 0 && ret == 1) {
                resMap.put("pwdRight", true);
                return resMap;
            }
            if (ret == 2) {
                resMap.put("pwdRight", false);
                resMap.put("errCode", "1002");
                resMap.put("errMsg", "\u5bc6\u7801\u5c1d\u8bd5\u6b21\u6570\u8d85\u9650");
                return resMap;
            }
            resMap.put("pwdRight", false);
            resMap.put("errCode", "1001");
            resMap.put("errMsg", "A1\u652f\u4ed8\u5bc6\u7801\u9a8c\u8bc1\u5931\u8d25");
            return resMap;
        }
        catch (Exception e) {
            logger.error("validateMimaMd5.do throws Exception:", (Throwable)e);
            resMap.put("pwdRight", false);
            resMap.put("errCode", "1003");
            resMap.put("errMsg", "\u7cfb\u7edf\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5:(");
            return resMap;
        }
    }

    private String request(String url) throws ParseException, ClientProtocolException, IOException {
        String json = HttpUtils.doGet((String)url);
        logger.info("response:{}", (Object)json);
        if (json.startsWith("callback")) {
            json = json.substring(json.indexOf("callback") + 9, json.length() - 1);
        }
        return json;
    }
}

