/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.thunderpay;

import com.xunlei.channel.gateway.common.result.DirectReturnResult;
import com.xunlei.channel.gateway.common.result.ReturnResult;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelHandler;
import com.xunlei.channel.gateway.pay.channels.thunderpay.ThunderpayChannelData;
import com.xunlei.channel.gateway.pay.channels.thunderpay.ThunderpayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.thunderpay.ThunderpayService;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import com.xunlei.channel.thundercore.client.ThunderCoreClient;
import com.xunlei.channel.thundercore.client.response.ConsumeResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractThunderpayHandler
extends AbstractChannelHandler<ReturnResult> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractThunderpayHandler.class);
    private static final String AUTO_PAY_BIZ_NO = "000001003";
    @Autowired
    protected ThunderpayChannelInfo thunderpayChannelInfo;
    @Autowired
    private ThunderpayService thunderpayService;

    @Override
    public ReturnResult generateChannelResult(UnitedPayRequest unitedPayRequest) {
        logger.debug("xunleiPayId:{}", (Object)unitedPayRequest.getXunleiPayId());
        ThunderpayChannelData data = this.generateThunderpayChannelData(unitedPayRequest);
        DirectReturnResult checkPwdResult = this.checkPwd(data.getXunleiId(), data.getXunleiPwd());
        if (checkPwdResult != null) {
            this.thunderpayService.processFailedOrder(data.getXunleiPayId(), checkPwdResult.getCode(), checkPwdResult.getMsg());
            return checkPwdResult;
        }
        ConsumeResponse consumeResponse = this.dealCommit(data);
        return this.thunderpayService.dealResult(consumeResponse, data);
    }

    protected abstract DirectReturnResult checkPwd(String var1, String var2);

    private ThunderpayChannelData generateThunderpayChannelData(UnitedPayRequest unitedPayRequest) {
        ThunderpayChannelData thunderpayChannelData = new ThunderpayChannelData();
        logger.debug("start to generate thunderpay data");
        thunderpayChannelData.setBizNo(unitedPayRequest.getBizNo());
        thunderpayChannelData.setOrderAmt(unitedPayRequest.getOrderAmt());
        thunderpayChannelData.setPoint((double)unitedPayRequest.getOrderAmt() / 100.0);
        thunderpayChannelData.setXunleiId(unitedPayRequest.getXunleiId());
        thunderpayChannelData.setXunleiPayId(unitedPayRequest.getXunleiPayId());
        thunderpayChannelData.setProductName(unitedPayRequest.getProductName());
        thunderpayChannelData.setInputIp(unitedPayRequest.getClientIp());
        thunderpayChannelData.setUserShow(unitedPayRequest.getUserShow());
        thunderpayChannelData.setXunleiPwd(unitedPayRequest.getExtraParam("pwd"));
        return thunderpayChannelData;
    }

    private ConsumeResponse dealCommit(ThunderpayChannelData data) {
        String realClientIp = data.getInputIp() == null ? "" : data.getInputIp();
        String isAutoPay = AUTO_PAY_BIZ_NO.equals(data.getBizNo()) ? "1" : "0";
        try {
            ThunderCoreClient client = new ThunderCoreClient(this.thunderpayChannelInfo.getThunderHost(), this.thunderpayChannelInfo.getThunderPort(), this.thunderpayChannelInfo.getThunderCharset());
            return client.consumeWithIpRequest(this.thunderpayChannelInfo.getThunderBizNo(), this.thunderpayChannelInfo.getThunderBizKey(), data.getXunleiPayId(), data.getUserShow(), data.getXunleiId(), String.valueOf(data.getPoint()), data.getProductName(), realClientIp, isAutoPay);
        }
        catch (Exception ex) {
            logger.error("exception message:", (Throwable)ex);
            return null;
        }
    }
}

