/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.shengpay;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.RedirectPostResult;
import com.xunlei.channel.gateway.common.utils.DateUtils;
import com.xunlei.channel.gateway.pay.annotation.PayType;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelHandler;
import com.xunlei.channel.gateway.pay.channels.shengpay.ShengpayChannelData;
import com.xunlei.channel.gateway.pay.channels.shengpay.ShengpayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.shengpay.ShengpayUtils;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PayType(value="E1", desc="\u76db\u4ed8\u901a\u4f59\u989d")
public class ShengpayHandler
extends AbstractChannelHandler<RedirectPostResult> {
    private static final Logger logger = LoggerFactory.getLogger(ShengpayHandler.class);
    @Autowired
    private ShengpayChannelInfo shengPayChannelInfo;

    @Override
    public RedirectPostResult generateChannelResult(UnitedPayRequest unitedPayRequest) {
        ShengpayChannelData data = this.generateShengpayChannelData(unitedPayRequest);
        try {
            data.setSignMsg(ShengpayUtils.genShengpayReqSignMsg(data, this.shengPayChannelInfo.getBizKey()));
        }
        catch (Exception e) {
            logger.error("\u76db\u4ed8\u901a\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("shengpayUrl", this.shengPayChannelInfo.getPayUrl());
        paramMap.put("Name", data.getVname());
        paramMap.put("Version", data.getVersion());
        paramMap.put("Charset", data.getCharset());
        paramMap.put("MsgSender", data.getMsgSender());
        if (!Strings.isNullOrEmpty((String)data.getSendTime())) {
            paramMap.put("SendTime", data.getSendTime());
        }
        paramMap.put("OrderNo", data.getOrderId());
        paramMap.put("OrderAmount", data.getOrderAmount());
        paramMap.put("OrderTime", data.getOrderTime());
        paramMap.put("PayType", data.getPayType());
        if (!Strings.isNullOrEmpty((String)data.getInstCode())) {
            paramMap.put("InstCode", data.getInstCode());
        }
        paramMap.put("PageUrl", data.getPageUrl());
        paramMap.put("NotifyUrl", data.getNotifyUrl());
        if (!Strings.isNullOrEmpty((String)data.getProductName())) {
            paramMap.put("ProductName", data.getProductName());
        }
        if (!Strings.isNullOrEmpty((String)data.getBuyerContact())) {
            paramMap.put("BuyerContact", data.getBuyerContact());
        }
        paramMap.put("BuyerIp", data.getBuyerIp());
        if (!Strings.isNullOrEmpty((String)data.getExt1())) {
            paramMap.put("Ext1", data.getExt1());
        }
        paramMap.put("SignType", data.getSignType());
        paramMap.put("SignMsg", data.getSignMsg());
        return new RedirectPostResult(InterfaceReqResult.SUCCESS, null, null, null, paramMap, "channels/shengpayRequest");
    }

    private ShengpayChannelData generateShengpayChannelData(UnitedPayRequest unitedPayRequest) {
        logger.debug("generateShengfutongChannelData");
        ShengpayChannelData shengpayChannelData = new ShengpayChannelData();
        shengpayChannelData.setVname(this.shengPayChannelInfo.getVname());
        shengpayChannelData.setVersion(this.shengPayChannelInfo.getVersion());
        shengpayChannelData.setCharset(this.shengPayChannelInfo.getCharset());
        shengpayChannelData.setMsgSender(this.shengPayChannelInfo.getSenderNo());
        String sendTime = ShengpayUtils.getSendTimeFromSft(this.shengPayChannelInfo.getSenderNo());
        if (!Strings.isNullOrEmpty((String)sendTime)) {
            shengpayChannelData.setSendTime(sendTime);
        } else {
            shengpayChannelData.setSendTime(DateUtils.noSpaceYYYYMMDDHHMMSS((Date)new Date()));
        }
        shengpayChannelData.setOrderId(unitedPayRequest.getXunleiPayId());
        DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
        shengpayChannelData.setOrderAmount(DECIMAL_FORMAT.format((double)unitedPayRequest.getOrderAmt() / 100.0));
        shengpayChannelData.setOrderTime(unitedPayRequest.getExtraParam("order_time"));
        if (Strings.isNullOrEmpty((String)shengpayChannelData.getOrderTime())) {
            shengpayChannelData.setOrderTime(DateUtils.noSpaceYYYYMMDDHHMMSS());
        }
        shengpayChannelData.setPayType(this.shengPayChannelInfo.getTranType(unitedPayRequest.getPayType()));
        shengpayChannelData.setInstCode(unitedPayRequest.getExtraParam("bank_no"));
        shengpayChannelData.setPageUrl(this.shengPayChannelInfo.getPageUrl());
        shengpayChannelData.setNotifyUrl(this.shengPayChannelInfo.getNotifyUrl());
        shengpayChannelData.setProductName(unitedPayRequest.getProductName());
        shengpayChannelData.setBuyerContact(unitedPayRequest.getExtraParam("buyer_contact"));
        shengpayChannelData.setBuyerIp(unitedPayRequest.getClientIp());
        shengpayChannelData.setExt1(null);
        shengpayChannelData.setSignType(this.shengPayChannelInfo.getSignType());
        logger.debug("verify shengpay data over...");
        return shengpayChannelData;
    }
}

