/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.jdpay;

import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.dao.PayOrderOkDAO;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.jdpay.JdPayChannelInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

abstract class JdPayChannelService
extends AbstractChannelService {
    private static final Logger logger = LoggerFactory.getLogger(JdPayChannelService.class);
    @Autowired
    PayOrderDAO payOrderDAO;
    @Autowired
    PayOrderOkDAO payOrderOkDAO;
    @Autowired
    JdPayChannelInfo channelInfo;

    JdPayChannelService() {
    }

    boolean isOrderSuccess(PayOrder payOrder) {
        if (payOrder == null) {
            return false;
        }
        if ("S".equals(payOrder.getStatus())) {
            String xunleiPayId = payOrder.getXunleiPayId();
            PayOrderOk payOrderOk = this.getPayOrderOkByXunleiPayId(xunleiPayId);
            if (null != payOrderOk) {
                return true;
            }
            logger.error("error,cannot find PayOrderOk...xunleiPayId:{}", (Object)xunleiPayId);
            return false;
        }
        return false;
    }

    boolean isOrderSuccess(String xunleiPayId) {
        if (xunleiPayId == null) {
            return false;
        }
        PayOrder payOrder = this.getPayOrderByXunleiPayId(xunleiPayId);
        if ("S".equals(payOrder.getStatus())) {
            PayOrderOk payOrderOk = this.getPayOrderOkByXunleiPayId(xunleiPayId);
            if (null != payOrderOk) {
                return true;
            }
            logger.error("error,cannot find PayOrderOk...xunleiPayId:{}", (Object)xunleiPayId);
            return false;
        }
        return false;
    }
}

