/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.jdpay;

import com.xunlei.channel.db.pojo.AbstractOrder;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.pojo.PayResult;
import com.xunlei.channel.gateway.pay.channels.jdpay.JdPayChannelData;
import com.xunlei.channel.gateway.pay.channels.jdpay.JdPayChannelService;
import com.xunlei.channel.gateway.pay.channels.jdpay.JdPayUtil;
import com.xunlei.channel.gateway.pay.channels.jdpay.constants.JdPayTradeResponseStatus;
import com.xunlei.channel.gateway.pay.channels.jdpay.vo.JdPayPageNotifyResponse;
import com.xunlei.channel.gateway.pay.result.FailPageResult;
import com.xunlei.channel.gateway.pay.result.PageResult;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JdPayChannelPageNotifyService
extends JdPayChannelService {
    private static final Logger logger = LoggerFactory.getLogger(JdPayChannelPageNotifyService.class);

    public PageResult generatePageResult(HttpServletRequest request) {
        try {
            JdPayPageNotifyResponse response = this.parseResponse(request);
            this.checkResponseSign(response);
            this.checkResponseStatus(response);
            PayOrder payOrder = this.getPayOrderByPageNotifyResponse(response);
            this.checkOrder(response, payOrder);
            PageResult pageResult = this.processSuccessResult(response, payOrder);
            if (logger.isDebugEnabled()) {
                logger.debug("generatePageResult... response: {}, returns pageResult: {}", (Object)response, (Object)pageResult);
            }
            return pageResult;
        }
        catch (Exception e) {
            logger.error("generatePageResult... caught exception: " + e.getMessage(), (Throwable)e);
            return new FailPageResult("\u8ba2\u5355\u652f\u4ed8\u7ed3\u679c\u6682\u65f6\u65e0\u6cd5\u786e\u8ba4\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b");
        }
    }

    private JdPayPageNotifyResponse parseResponse(HttpServletRequest request) throws Exception {
        JdPayPageNotifyResponse response;
        try {
            response = this.parsePageNotifyResponse(request);
        }
        catch (NumberFormatException e) {
            logger.error("", (Throwable)e);
            throw new Exception("\u53d1\u751f\u9519\u8bef\uff1a\u8ba2\u5355\u91d1\u989d\u4e0d\u5339\u914d");
        }
        return response;
    }

    private void checkResponseSign(JdPayPageNotifyResponse response) throws Exception {
        String merchantRsaPublicKey = this.channelInfo.getMerchantRsaPublicKey();
        boolean checked = JdPayUtil.checkPageNotifySign(response, response.getSign(), merchantRsaPublicKey);
        if (!checked) {
            logger.error("generatePageResult... order: {}, check sign error!", (Object)response.getTradeNum());
            throw new Exception("\u8ba2\u5355\u652f\u4ed8\u7ed3\u679c\u6682\u65f6\u65e0\u6cd5\u786e\u8ba4\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b");
        }
    }

    private void checkResponseStatus(JdPayPageNotifyResponse response) throws Exception {
        JdPayTradeResponseStatus responseStatus = this.getResponseStatus(response);
        if (!responseStatus.equals((Object)JdPayTradeResponseStatus.SUCCESS)) {
            throw new Exception("\u8ba2\u5355\u652f\u4ed8\u7ed3\u679c\u6682\u65f6\u65e0\u6cd5\u786e\u8ba4\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b");
        }
    }

    private void checkOrder(JdPayPageNotifyResponse response, PayOrder payOrder) throws Exception {
        String xunleiPayId = response.getTradeNum();
        if (this.isOrderSuccess(payOrder)) {
            PayOrderOk payOrderOk = this.payOrderOkDAO.getPayOrderOk(xunleiPayId);
            String token = response.getToken();
            payOrderOk.setChannelOrderId(token);
            this.payOrderOkDAO.updatePayOrderOk(payOrderOk);
            logger.debug("generatePageResult... response: {}, order is ok!", (Object)response);
            return;
        }
        if (payOrder == null) {
            logger.error("generatePageResult... response: {}, could'nt found corresponding order!", (Object)response);
            throw new Exception("\u627e\u4e0d\u5230\u5bf9\u5e94\u8ba2\u5355");
        }
        try {
            this.checkOrderByPageNotify(payOrder, response);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    private PageResult processSuccessResult(JdPayPageNotifyResponse response, PayOrder payOrder) {
        JdPayChannelData channelData = this.generateChannelDataByPageNotify(response);
        PayOrderOk payOrderOk1 = this.processPaySuccess(payOrder, channelData);
        return this.generatePageUrlAndParams((AbstractOrder)payOrderOk1, PayResult.SUCCESS.getValue(), payOrderOk1.getFareAmt());
    }

    private JdPayPageNotifyResponse parsePageNotifyResponse(HttpServletRequest request) {
        JdPayPageNotifyResponse response = new JdPayPageNotifyResponse();
        String token = request.getParameter("token");
        response.setToken(token);
        String tradeNum = request.getParameter("tradeNum");
        response.setTradeNum(tradeNum);
        String tradeAmount = request.getParameter("tradeAmount");
        response.setTradeAmount(Integer.parseInt(tradeAmount));
        String tradeCurrency = request.getParameter("tradeCurrency");
        response.setTradeCurrency(tradeCurrency);
        String tradeDate = request.getParameter("tradeDate");
        response.setTradeDate(tradeDate);
        String tradeTime = request.getParameter("tradeTime");
        response.setTradeTime(tradeTime);
        String tradeNote = request.getParameter("tradeNote");
        response.setTradeNote(tradeNote);
        String tradeStatus = request.getParameter("tradeStatus");
        response.setTradeStatus(tradeStatus);
        String sign = request.getParameter("sign");
        response.setSign(sign);
        return response;
    }

    private JdPayTradeResponseStatus getResponseStatus(JdPayPageNotifyResponse response) {
        String tradeStatus = response.getTradeStatus();
        JdPayTradeResponseStatus status = JdPayTradeResponseStatus.getTradeResponseStatusByCode(tradeStatus);
        logger.debug("getResponseStatus... tradeStatus: {}, return JdPayTradeResponseStatus: {}", (Object)tradeStatus, (Object)status);
        return status;
    }

    private PayOrder getPayOrderByPageNotifyResponse(JdPayPageNotifyResponse response) {
        String tradeNum = response.getTradeNum();
        PayOrder payOrder = this.payOrderDAO.getPayOrder(tradeNum);
        return payOrder;
    }

    private void checkOrderByPageNotify(PayOrder payOrder, JdPayPageNotifyResponse response) throws Exception {
        int tradeAmount;
        int orderAmt = payOrder.getOrderAmt();
        if (orderAmt != (tradeAmount = response.getTradeAmount())) {
            throw new Exception("\u91d1\u989d\u9519\u8bef");
        }
    }

    private JdPayChannelData generateChannelDataByPageNotify(JdPayPageNotifyResponse payPageNotifyResponse) {
        String token = payPageNotifyResponse.getToken();
        int tradeAmount = payPageNotifyResponse.getTradeAmount();
        double rateOfCharge = this.channelInfo.getRateOfCharge();
        int fareAmt = (int)Math.round(rateOfCharge * (double)tradeAmount);
        int factAmt = tradeAmount - fareAmt;
        logger.info("generateChannelDataByPageNotify... tradeAmount: {}, rateOfCharge: {}, fareAmt: {}, factAmt: {}", new Object[]{tradeAmount, rateOfCharge, fareAmt, factAmt});
        JdPayChannelData channelData = new JdPayChannelData();
        channelData.setToken(token);
        channelData.setFareAmt(fareAmt);
        channelData.setFactAmt(factAmt);
        String json = this.generateJson(payPageNotifyResponse);
        channelData.setExtJson(json);
        return channelData;
    }

    private String generateJson(JdPayPageNotifyResponse payPageNotifyResponse) {
        String tradeNum = payPageNotifyResponse.getTradeNum();
        PayOrder payOrder = this.getPayOrderByXunleiPayId(tradeNum);
        String extraJson = payOrder.getExtraJson();
        return extraJson;
    }
}

