/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.hebao;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HebaoUtils {
    private static final Logger logger = LoggerFactory.getLogger(HebaoUtils.class);

    public static String getToday() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return format.format(new Date());
    }

    public static String MD5Sign(String signData, String signkey) {
        if (Strings.isNullOrEmpty((String)signkey)) {
            logger.error("invalid signkey:{}", (Object)signkey);
            return "";
        }
        String value = HebaoUtils.cryptMd5(signData, "");
        return HebaoUtils.cryptMd5(value, signkey);
    }

    public static String getRedirectUrl(String payUrl) {
        String[] items;
        HashMap<String, String> rdUrl = new HashMap<String, String>();
        if (payUrl != null && (items = payUrl.split("[<hi:$$>]{7}")) != null) {
            for (int i = 0; i < items.length; ++i) {
                String[] element;
                String item = items[i];
                if (item == null || (element = item.split("[<hi:=>]{6}")) == null || element.length != 2) continue;
                rdUrl.put(element[0], element[1]);
            }
        }
        return (String)rdUrl.get("url") + "?" + "sessionId=" + (String)rdUrl.get("sessionId");
    }

    public static Map<String, String> getRespMap(String respMsg) {
        HashMap<String, String> resMap = new HashMap<String, String>();
        String[] resArr = StringUtils.split((String)respMsg, (String)"&");
        for (int i = 0; i < resArr.length; ++i) {
            String data = resArr[i];
            int index = StringUtils.indexOf((String)data, (char)'=');
            String nm = StringUtils.substring((String)data, (int)0, (int)index);
            String val = StringUtils.substring((String)data, (int)(index + 1));
            resMap.put(nm, val);
        }
        return resMap;
    }

    public static String cryptMd5(String source, String key) {
        byte[] value;
        byte[] keyb;
        byte[] k_ipad = new byte[64];
        byte[] k_opad = new byte[64];
        try {
            keyb = key.getBytes("UTF-8");
            value = source.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            keyb = key.getBytes();
            value = source.getBytes();
        }
        Arrays.fill(k_ipad, keyb.length, 64, new Integer(54).byteValue());
        Arrays.fill(k_opad, keyb.length, 64, new Integer(92).byteValue());
        for (int i = 0; i < keyb.length; ++i) {
            k_ipad[i] = (byte)(keyb[i] ^ 0x36);
            k_opad[i] = (byte)(keyb[i] ^ 0x5C);
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        md.update(k_ipad);
        md.update(value);
        byte[] dg = md.digest();
        md.reset();
        md.update(k_opad);
        md.update(dg, 0, 16);
        dg = md.digest();
        return HebaoUtils.toHex(dg);
    }

    public static String toHex(byte[] input) {
        if (input == null) {
            return null;
        }
        StringBuffer output = new StringBuffer(input.length * 2);
        for (int i = 0; i < input.length; ++i) {
            int current = input[i] & 0xFF;
            if (current < 16) {
                output.append("0");
            }
            output.append(Integer.toString(current, 16));
        }
        return output.toString();
    }
}

