/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.hebao;

import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.RedirectGetResult;
import com.xunlei.channel.gateway.common.result.ReturnResult;
import com.xunlei.channel.gateway.common.utils.HttpUtils;
import com.xunlei.channel.gateway.pay.annotation.PayType;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelHandler;
import com.xunlei.channel.gateway.pay.channels.hebao.HebaoUtils;
import com.xunlei.channel.gateway.pay.channels.hebao.HebaoWapChannelInfo;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PayType(value="T1", desc="\u548c\u5305\u652f\u4ed8")
public class HebaoChannelHandler
extends AbstractChannelHandler<ReturnResult> {
    private static final String UTF8 = "UTF-8";
    private static final Logger logger = LoggerFactory.getLogger(HebaoChannelHandler.class);
    @Autowired
    private HebaoWapChannelInfo hebaoWapChannelInfo;

    @Override
    public RedirectGetResult generateChannelResult(UnitedPayRequest unitedPayRequest) {
        try {
            String today = HebaoUtils.getToday();
            StringBuilder signData = new StringBuilder("02").append(this.hebaoWapChannelInfo.getPageUrl()).append(this.hebaoWapChannelInfo.getReturnUrl()).append(unitedPayRequest.getClientIp()).append(this.hebaoWapChannelInfo.getMerchantId()).append(unitedPayRequest.getXunleiPayId()).append("MD5").append("WAPDirectPayConfirm").append("2.0.0").append(unitedPayRequest.getOrderAmt()).append("").append("00").append(today).append(unitedPayRequest.getXunleiPayId()).append(today).append("702").append(unitedPayRequest.getProductName()).append("1");
            String hmac = HebaoUtils.MD5Sign(signData.toString(), this.hebaoWapChannelInfo.getMerchantKey());
            logger.info("signData:{},hmac:{}", (Object)signData.toString(), (Object)hmac);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("characterSet", "02");
            paramMap.put("callbackUrl", this.hebaoWapChannelInfo.getPageUrl());
            paramMap.put("notifyUrl", this.hebaoWapChannelInfo.getReturnUrl());
            paramMap.put("ipAddress", unitedPayRequest.getClientIp());
            paramMap.put("merchantId", this.hebaoWapChannelInfo.getMerchantId());
            paramMap.put("requestId", unitedPayRequest.getXunleiPayId());
            paramMap.put("signType", "MD5");
            paramMap.put("type", "WAPDirectPayConfirm");
            paramMap.put("version", "2.0.0");
            paramMap.put("amount", "" + unitedPayRequest.getOrderAmt());
            paramMap.put("bankAbbr", "");
            paramMap.put("currency", "00");
            paramMap.put("orderDate", today);
            paramMap.put("orderId", unitedPayRequest.getXunleiPayId());
            paramMap.put("merAcDate", today);
            paramMap.put("period", "7");
            paramMap.put("periodUnit", "02");
            paramMap.put("merchantAbbr", "");
            paramMap.put("productDesc", "");
            paramMap.put("productId", "");
            paramMap.put("productName", unitedPayRequest.getProductName());
            paramMap.put("productNum", "1");
            paramMap.put("reserved1", "");
            paramMap.put("reserved2", "");
            paramMap.put("userToken", "");
            paramMap.put("showUrl", "");
            paramMap.put("couponsFlag", "");
            paramMap.put("hmac", hmac);
            String res = HttpUtils.doPostWithCharsets((String)this.hebaoWapChannelInfo.getPayUrl(), paramMap, (int)60000, (int)60000, (String)UTF8, (String)UTF8);
            logger.info("response:{}", (Object)res);
            Map<String, String> respMap = HebaoUtils.getRespMap(res);
            String hmac1 = respMap.get("hmac");
            StringBuilder vfsign = new StringBuilder(respMap.get("merchantId")).append(respMap.get("requestId")).append(respMap.get("signType")).append(respMap.get("type")).append(respMap.get("version")).append(respMap.get("returnCode")).append(URLDecoder.decode(respMap.get("message"), UTF8)).append(respMap.get("payUrl"));
            String ourHmac = HebaoUtils.MD5Sign(vfsign.toString(), this.hebaoWapChannelInfo.getMerchantKey());
            if (!ourHmac.equals(hmac1)) {
                logger.error("invalid md5 signature...hmac:{},ours:{}", (Object)hmac1, (Object)ourHmac);
                return new RedirectGetResult(InterfaceReqResult.FAIL, "99", "\u4e0b\u5355\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5:(", "pay_fail_page", null);
            }
            String code = respMap.get("returnCode");
            if (!code.equals("000000")) {
                logger.error("unsuccess...errorCode:{},msg:{}", (Object)code, (Object)URLDecoder.decode(respMap.get("message"), UTF8));
                return new RedirectGetResult(InterfaceReqResult.FAIL, "99", "\u4e0b\u5355\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5:(", "pay_fail_page", null);
            }
            String payUrl = respMap.get("payUrl");
            String submitUrl = HebaoUtils.getRedirectUrl(payUrl);
            logger.info("redirect_url:{}", (Object)submitUrl);
            return new RedirectGetResult(InterfaceReqResult.SUCCESS, "00", "", null, submitUrl);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new RedirectGetResult(InterfaceReqResult.FAIL, "99", "\u4e0b\u5355\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5:(", "pay_fail_page", null);
        }
    }
}

