/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.ext19pay;

import com.xunlei.channel.db.pojo.AbstractOrder;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.gateway.common.pay.ChannelData;
import com.xunlei.channel.gateway.common.pojo.PayResult;
import com.xunlei.channel.gateway.common.utils.StringUtils;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.ext19pay.Ext19PayChannelInfo;
import com.xunlei.channel.gateway.pay.result.FailPageResult;
import com.xunlei.channel.gateway.pay.result.PageResult;
import com.xunlei.xlcommons.util.Json.JsonLibUtil;
import com.xunlei.xlcommons.util.MD5.Md5Encrypt;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Ext19PayNotifyService
extends AbstractChannelService {
    private static final Logger logger = LoggerFactory.getLogger(Ext19PayNotifyService.class);
    @Autowired
    private Ext19PayChannelInfo ext19PayChannelInfo;
    private static final String SUCCESS = "Y";
    private static final String FAILED = "N";

    public PageResult pageNotify(HttpServletRequest request) {
        logger.debug("enter the Ext19PayNotifyService pageNotify,with params:{}", (Object)request.getParameterMap());
        String orderId = request.getParameter("order_id");
        String result = "";
        try {
            result = this.getPageNotifyPayResult(request);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return new FailPageResult("\u8ba2\u5355\u652f\u4ed8\u7ed3\u679c\u6682\u65f6\u65e0\u6cd5\u786e\u8ba4\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b");
        }
        PayOrder payOrder = this.getPayOrderByXunleiPayId(orderId);
        if (payOrder == null) {
            logger.error("cannot find payOrder with xunleiPayId:{},ignore", (Object)orderId);
            return new FailPageResult("\u53d1\u751f\u9519\u8bef\uff1a\u8ba2\u5355\u53f7[" + orderId + "]\u4e0d\u5b58\u5728\uff01");
        }
        if (result.equals(SUCCESS)) {
            logger.info("xunleiPayId:{} pay successed", (Object)orderId);
            return this.generatePageUrlAndParams((AbstractOrder)payOrder, PayResult.SUCCESS.getValue(), 0);
        }
        if (result.equals(FAILED)) {
            logger.info("xunleiPayId:{} pay failed", (Object)orderId);
            return new FailPageResult("\u8ba2\u5355\u652f\u4ed8\u5931\u8d25");
        }
        if (result.equals("40008") || result.equals("50010") || result.equals("81008") || result.equals("81012") || result.equals("81029") || result.equals("81030") || result.equals("81033") || result.equals("81034") || result.equals("81035") || result.equals("81036") || result.equals("81037") || result.equals("81037") || result.equals("81088")) {
            logger.info("xunleiPayId:{} pay processed", (Object)orderId);
            return new FailPageResult("\u8ba2\u5355\u652f\u4ed8\u7ed3\u679c\u6682\u65f6\u65e0\u6cd5\u786e\u8ba4\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b");
        }
        logger.error("xunleiPayId:{} pay page notify with invalid result:{}", (Object)orderId, (Object)result);
        return new FailPageResult("\u8ba2\u5355\u652f\u4ed8\u7ed3\u679c\u6682\u65f6\u65e0\u6cd5\u786e\u8ba4\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b");
    }

    public String returnNotify(HttpServletRequest request) {
        logger.debug("enter the Ext19PayNotifyService returnNotify,with params:{}", (Object)request.getParameterMap());
        String orderId = request.getParameter("order_id");
        final String paySq = request.getParameter("pay_sq");
        String result = "";
        try {
            result = this.getReturnNotifyPayResult(request);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return FAILED;
        }
        HashMap<String, String> extraJsonMap = new HashMap<String, String>();
        String cardNo = request.getParameter("pay_cardno");
        String cardPwd = request.getParameter("pay_cardpwd");
        String payDate = request.getParameter("pay_date");
        extraJsonMap.put("card_no", cardNo == null ? "" : cardNo);
        extraJsonMap.put("card_pwd", cardPwd == null ? "" : cardPwd);
        extraJsonMap.put("pay_date", payDate == null ? "" : payDate);
        final String extraJson = JsonLibUtil.mapToJson(extraJsonMap);
        if ("F".equals(result)) {
            logger.info("payOrder:{} pay failed,do nothing and return", (Object)orderId);
            PayOrder payOrder = this.getPayOrderByXunleiPayId(orderId);
            if (payOrder != null) {
                this.processPayFail(payOrder, "", "", orderId, extraJson);
            }
            return SUCCESS;
        }
        if (SUCCESS.equals(result)) {
            int orderAmt;
            PayOrder payOrder = this.getPayOrderByXunleiPayId(orderId);
            if (payOrder == null) {
                logger.error("return notify cannot find payOrder with xunleiPayId:{}", (Object)orderId);
                return FAILED;
            }
            if ("S".equals(payOrder.getStatus())) {
                logger.info("payOrder:{} status was success,do nothing and return", (Object)orderId);
                return SUCCESS;
            }
            String amount = request.getParameter("amount");
            int notifyAmount = (int)(Double.parseDouble(amount) * 100.0);
            if (Math.abs(notifyAmount - (orderAmt = payOrder.getOrderAmt())) > 1) {
                logger.error("orderId:{} notify orderAmt:{} not equals payOrder amt:{}", new Object[]{orderId, notifyAmount, orderAmt});
                return FAILED;
            }
            final double PAY_RATE = this.ext19PayChannelInfo.getConfigValueDouble("fee_rate");
            ChannelData channelData = new ChannelData(){

                public int getFareAmt() {
                    return (int)((double)orderAmt * PAY_RATE);
                }

                public int getFactAmt() {
                    return orderAmt - (int)((double)orderAmt * PAY_RATE);
                }

                public String getChannelOrderId() {
                    return paySq;
                }

                public String generateOkExtJson() {
                    return extraJson;
                }
            };
            try {
                this.processPaySuccess(payOrder, channelData);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                return FAILED;
            }
            return SUCCESS;
        }
        logger.error("payOrder:{} pay notify with invalid result:{},do nothing and return", (Object)orderId, (Object)result);
        return FAILED;
    }

    private String getPageNotifyPayResult(HttpServletRequest request) throws Exception {
        String merchantKey = this.ext19PayChannelInfo.getConfigValue("merchant_key");
        String versionId = request.getParameter("version_id");
        String merchantId = request.getParameter("merchant_id");
        String orderDate = request.getParameter("order_date");
        String orderId = request.getParameter("order_id");
        String amount = request.getParameter("amount");
        String currency = request.getParameter("currency");
        String paySq = request.getParameter("pay_sq");
        String payDate = request.getParameter("pay_date");
        String pcId = request.getParameter("pc_id");
        String result = request.getParameter("result");
        String verifyString = request.getParameter("verifystring");
        if (StringUtils.isAnyNullOrEmpty((String[])new String[]{versionId, merchantId, verifyString, orderId, amount, currency, paySq, payDate, pcId, result})) {
            logger.error("page notify with invalid parameter");
            throw new Exception("invalid notify params");
        }
        String ori = "version_id=" + versionId + "&merchant_id=" + merchantId + "&order_date=" + orderDate + "&order_id=" + orderId + "&amount=" + amount + "&currency=" + currency + "&pay_sq=" + paySq + "&pay_date=" + payDate + "&pc_id=" + pcId + "&result=" + result + "&merchant_key=" + merchantKey;
        logger.info("to sign str:{}", (Object)ori);
        String signMsg = Md5Encrypt.encode((String)ori, (String)"UTF-8");
        logger.info("signMsg:{}", (Object)signMsg);
        if (!verifyString.equalsIgnoreCase(signMsg)) {
            logger.error("page notify with invalid sign:{},localSign:{}", (Object)verifyString, (Object)signMsg);
            throw new Exception("invalid sign");
        }
        return result;
    }

    private String getReturnNotifyPayResult(HttpServletRequest request) throws Exception {
        String merchantKey = this.ext19PayChannelInfo.getConfigValue("merchant_key");
        String versionId = request.getParameter("version_id");
        String merchantId = request.getParameter("merchant_id");
        String orderDate = request.getParameter("order_date");
        String orderId = request.getParameter("order_id");
        String amount = request.getParameter("amount");
        String currency = request.getParameter("currency");
        String paySq = request.getParameter("pay_sq");
        String payDate = request.getParameter("pay_date");
        String pcId = request.getParameter("pc_id");
        String result = request.getParameter("result");
        String verifyString = request.getParameter("verifystring");
        if (StringUtils.isAnyNullOrEmpty((String[])new String[]{versionId, merchantId, verifyString, orderId, amount, currency, paySq, payDate, pcId, result})) {
            logger.error("page notify with invalid parameter");
            throw new Exception("invalid notify params");
        }
        String ori = "version_id=" + versionId + "&merchant_id=" + merchantId + "&order_id=" + orderId + "&result=" + result + "&order_date=" + orderDate + "&amount=" + amount + "&currency=" + currency + "&pay_sq=" + paySq + "&pay_date=" + payDate + "&pc_id=" + pcId + "&merchant_key=" + merchantKey;
        logger.info("to sign str:{}", (Object)ori);
        String signMsg = Md5Encrypt.encode((String)ori, (String)"UTF-8");
        logger.info("signMsg:{}", (Object)signMsg);
        if (!verifyString.equalsIgnoreCase(signMsg)) {
            logger.error("page notify with invalid sign:{},localSign:{}", (Object)verifyString, (Object)signMsg);
            throw new Exception("invalid sign");
        }
        return result;
    }
}

