/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.ext19pay;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.RedirectGetResult;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelHandler;
import com.xunlei.channel.gateway.pay.channels.ext19pay.Ext19PayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.ext19pay.Ext19PayUtil;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import com.xunlei.xlcommons.util.Arith.UnitArith;
import com.xunlei.xlcommons.util.Date.DateUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractExt19PayChannelHandler
extends AbstractChannelHandler<RedirectGetResult> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractChannelHandler.class);
    @Autowired
    protected Ext19PayChannelInfo ext19PayChannelInfo;

    @Override
    public RedirectGetResult generateChannelResult(UnitedPayRequest unitedPayRequest) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("version_id", "1.0");
        params.put("merchant_id", this.ext19PayChannelInfo.getConfigValue("merchant_id"));
        params.put("order_date", DateUtil.getCurrentTime((String)"yyyyMMdd"));
        params.put("order_id", unitedPayRequest.getXunleiPayId());
        params.put("amount", UnitArith.fenToyuan((double)unitedPayRequest.getOrderAmt()));
        params.put("currency", "RMB");
        params.put("ret_url", this.ext19PayChannelInfo.getConfigValue("ret_url"));
        params.put("pm_id", this.getPmId());
        params.put("pc_id", this.getPcId());
        params.put("order_pname", unitedPayRequest.getProductName());
        params.put("order_pdesc", unitedPayRequest.getProductDesc());
        String notifyUrl = this.ext19PayChannelInfo.getConfigValue("notify_url");
        String payUrl = this.ext19PayChannelInfo.getConfigValue("pay_url");
        String md5Key = this.ext19PayChannelInfo.getConfigValue("merchant_key");
        try {
            String url = Ext19PayUtil.generatePayUrl(payUrl, notifyUrl, params, md5Key);
            logger.info("orderId:{} with pay url:{}", (Object)unitedPayRequest.getXunleiPayId(), (Object)url);
            if (!Strings.isNullOrEmpty((String)url)) {
                return new RedirectGetResult(InterfaceReqResult.SUCCESS, "", "", null, url);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return new RedirectGetResult(InterfaceReqResult.FAIL, "99", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", "pay_fail_page", null);
    }

    @Override
    public RedirectGetResult validateSpecialParams(UnitedPayRequest unitedPayRequest) {
        int orderAmt = unitedPayRequest.getOrderAmt();
        if (!this.ext19PayChannelInfo.isAmtAllowed(this.getSpType(), orderAmt / 100)) {
            logger.error("orderId:{} order with invalid orderAmt:{}", (Object)unitedPayRequest.getXunleiPayId(), (Object)orderAmt);
            return new RedirectGetResult(InterfaceReqResult.FAIL, "13", "\u6682\u4e0d\u652f\u6301\u8be5\u9762\u989d\uff01", "pay_fail_page", null);
        }
        return null;
    }

    protected abstract String getSpType();

    protected abstract String getPmId();

    protected abstract String getPcId();
}

