/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.directpay;

import com.xunlei.channel.gateway.pay.channels.directpay.CardPayChannelInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CardPayChannelUtils {
    private static final Logger logger = LoggerFactory.getLogger(CardPayChannelUtils.class);
    @Autowired
    private CardPayChannelInfo cardPayChannelInfo;
    public static String format1 = "yyyyMMddHHmmss";
    public static String format2 = "yyyy-MM-dd HH:mm:ss";

    public static boolean checkAgentId(String agentId, String agents) {
        String[] agentIds;
        logger.info("get agentId is {} , get agents is {}", (Object)agentId, (Object)agents);
        if (null == agentId) {
            return false;
        }
        for (String agent : agentIds = agents.split(",")) {
            if (CardPayChannelUtils.isEmpty(agent) || !agent.equals(agentId)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String getFormatTimeNew(String oldTime) {
        try {
            SimpleDateFormat sdf1 = new SimpleDateFormat(format1);
            SimpleDateFormat sdf2 = new SimpleDateFormat(format2);
            Date date = sdf2.parse(oldTime);
            String newTime = sdf1.format(date);
            return newTime;
        }
        catch (ParseException e) {
            logger.error("parse with exception,message:" + e.getMessage());
            return null;
        }
    }

    public static String timeofnow() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }
}

