/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.directpay;

import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.DirectReturnResult;
import com.xunlei.channel.gateway.common.result.ReturnResult;
import com.xunlei.channel.gateway.pay.annotation.PayType;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelHandler;
import com.xunlei.channel.gateway.pay.channels.directpay.CardPayChannelData;
import com.xunlei.channel.gateway.pay.channels.directpay.CardPayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.directpay.CardPayChannelService;
import com.xunlei.channel.gateway.pay.channels.directpay.CardPayChannelUtils;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import com.xunlei.xlcommons.util.Arith.UnitArith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PayType(value="S2", desc="\u9a8f\u7f51\u76f4\u5145")
public class CardPayChannelHandler
extends AbstractChannelHandler<ReturnResult> {
    private static final Logger logger = LoggerFactory.getLogger(CardPayChannelHandler.class);
    @Autowired
    private CardPayChannelInfo cardPayChannelInfo;
    @Autowired
    private CardPayChannelService cardPayChannelService;

    @Override
    public ReturnResult generateChannelResult(UnitedPayRequest unitedPayRequest) {
        logger.debug("generateChannelResult...");
        boolean isSuccess = false;
        try {
            PayOrderOk payOrderOk;
            CardPayChannelData data = this.getCardPayChannelData(unitedPayRequest);
            logger.debug("get CardPayChannelData {}", (Object)data);
            PayOrder payOrder = this.cardPayChannelService.getPayOrder(data.getXunleiId());
            if (payOrder != null && (payOrderOk = this.cardPayChannelService.dealWithPayOrder(payOrder, data)) != null) {
                isSuccess = true;
            }
            logger.info("the result is {}", (Object)isSuccess);
            if (isSuccess) {
                return new DirectReturnResult(InterfaceReqResult.SUCCESS, "00", "", null, null);
            }
            return new DirectReturnResult(InterfaceReqResult.FAIL, "99", "\u7a0b\u5e8f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", "pay_fail_page", null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new DirectReturnResult(InterfaceReqResult.FAIL, "99", "\u7a0b\u5e8f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", "pay_fail_page", null);
        }
    }

    @Override
    public DirectReturnResult validateSpecialParams(UnitedPayRequest unitedPayRequest) {
        String agentId = unitedPayRequest.getExtraParam("agentId");
        if (!CardPayChannelUtils.checkAgentId(agentId, this.cardPayChannelInfo.getAgent())) {
            logger.error("agentId is invalid, the agentId is {}", (Object)agentId);
            return new DirectReturnResult(InterfaceReqResult.FAIL, "13", "invalid qishun type", "pay_fail_page", null);
        }
        return null;
    }

    public CardPayChannelData getCardPayChannelData(UnitedPayRequest unitedPayRequest) {
        CardPayChannelData cardPayChannelData = new CardPayChannelData();
        cardPayChannelData.setVersion(this.cardPayChannelInfo.getVersion());
        cardPayChannelData.setPageCharset(this.cardPayChannelInfo.getInputCharset());
        cardPayChannelData.setNotifyUrl(this.cardPayChannelInfo.getNotify_url());
        cardPayChannelData.setBizSysno(this.cardPayChannelInfo.getBizSysNo());
        cardPayChannelData.setReqTime(CardPayChannelUtils.getFormatTimeNew(CardPayChannelUtils.timeofnow()));
        cardPayChannelData.setPayParam2(unitedPayRequest.getExtraParam("phone"));
        cardPayChannelData.setPayParam1(unitedPayRequest.getExtraParam("agentId"));
        cardPayChannelData.setPayParam3(unitedPayRequest.getExtraParam("other1"));
        cardPayChannelData.setPayParam4(unitedPayRequest.getExtraParam("other3"));
        cardPayChannelData.setPayType("DIRECT");
        cardPayChannelData.setOrderId(unitedPayRequest.getBizOrderId());
        cardPayChannelData.setOrderAmt("" + UnitArith.fenToyuan((String)(unitedPayRequest.getOrderAmt() + "")));
        cardPayChannelData.setRtnFmt(this.cardPayChannelInfo.getRtnFmt());
        cardPayChannelData.setXunleiId(unitedPayRequest.getXunleiPayId());
        cardPayChannelData.setProductName(unitedPayRequest.getProductName());
        cardPayChannelData.setProductDesc(unitedPayRequest.getProductDesc());
        cardPayChannelData.setInputIp(unitedPayRequest.getClientIp());
        cardPayChannelData.setUserShow(unitedPayRequest.getUserShow());
        cardPayChannelData.setExt1(unitedPayRequest.getExtraParam("ext1"));
        cardPayChannelData.setExt2(unitedPayRequest.getExtraParam("ext2"));
        logger.debug("get cardPayChannelData {}", (Object)cardPayChannelData);
        return cardPayChannelData;
    }

    @Override
    public String analyzeExtParams(UnitedPayRequest unitedPayRequest) {
        StringBuffer buf = new StringBuffer();
        CardPayChannelData data = this.getCardPayChannelData(unitedPayRequest);
        buf.append("{");
        buf.append("\"version\":\"" + data.getVersion() + "\",");
        buf.append("\"phone\":\"" + data.getPayParam2() + "\",");
        buf.append("\"pagecharset\":\"" + data.getPageCharset() + "\",");
        buf.append("\"bizsysno\":\"" + data.getBizSysno() + "\",");
        buf.append("\"reqtime\":\"" + data.getReqTime() + "\",");
        buf.append("\"agentId\":\"" + data.getPayParam1() + "\",");
        buf.append("\"paytype\":\"" + data.getPayType() + "\",");
        buf.append("\"other1\":\"" + data.getPayParam3() + "\",");
        buf.append("\"other3\":\"" + data.getPayParam4() + "\",");
        buf.append("\"ext1\":\"" + data.getExt1() + "\",");
        buf.append("\"ext2\":\"" + data.getExt2() + "\",");
        buf.append("\"Rtnfmt\":\"" + data.getRtnFmt() + "\",");
        buf.append("}");
        logger.info("the ext params is {}", (Object)buf.toString());
        return buf.toString();
    }
}

