/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.cardpay;

import com.xunlei.channel.gateway.pay.channels.cardpay.XLCardPayChannelData;
import com.xunlei.xlcommons.util.MD5.Md5Encrypt;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLCardPayUtils {
    private static final Logger logger = LoggerFactory.getLogger(XLCardPayUtils.class);

    public static String genCardpayReqSignMsg(XLCardPayChannelData data, String bizKey) {
        String signMsg = null;
        try {
            TreeMap<String, String> params = new TreeMap<String, String>();
            params.put("pagecharset", data.getPageCharset());
            params.put("notifyurl", data.getNotifyUrl());
            params.put("bizsysno", data.getBizSysNo());
            params.put("orderid", data.getOrderId());
            params.put("orderamt", "" + data.getOrderamt());
            if (data.getOrderTime() != null && !"".equals(data.getOrderTime()) && !"null".equals(data.getOrderTime())) {
                params.put("ordertime", data.getOrderTime());
            }
            params.put("cardno", data.getCardNo());
            params.put("cardpwd", data.getCardpwd());
            params.put("xluser", data.getUserShow());
            params.put("xlinnerid", data.getXunleiId());
            params.put("productname", data.getProductName());
            params.put("productdesc", data.getProductDesc());
            params.put("clientip", data.getInputIp());
            if (data.getExt1() != null && !"".equals(data.getExt1()) && !"null".equals(data.getExt1())) {
                params.put("ext1", data.getExt1());
            }
            if (data.getExt2() != null && !"".equals(data.getExt2()) && !"null".equals(data.getExt2())) {
                params.put("ext2", data.getExt2());
            }
            signMsg = XLCardPayUtils.createToken(params, bizKey);
            logger.debug("signMsg==" + signMsg);
        }
        catch (Exception e) {
            logger.error("create token failed! {}", (Object)e.getMessage());
        }
        return signMsg;
    }

    public static String createToken(Map<String, String> params, String keySecret) {
        StringBuilder str = new StringBuilder();
        Set<String> set = params.keySet();
        for (String key : set) {
            str.append(key).append("=").append(params.get(key)).append("&");
        }
        String newStr = str.substring(0, str.length() - 1).toString();
        newStr = newStr + keySecret;
        logger.debug("the string before toking is {}", (Object)newStr);
        return Md5Encrypt.encode((String)newStr, (String)"GBK");
    }
}

