/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.audiopay;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.common.utils.AESUtils;
import com.xunlei.channel.gateway.common.utils.HttpUtils;
import com.xunlei.channel.gateway.common.utils.StringUtils;
import com.xunlei.channel.gateway.pay.channels.audiopay.AudioPayChannelData;
import com.xunlei.channel.gateway.pay.channels.audiopay.AudioPayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.audiopay.AudioPayResult;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioPayUtil {
    private static final Logger logger = LoggerFactory.getLogger(AudioPayUtil.class);

    public static String createPayUrl(AudioPayChannelData audioPayChannelData, AudioPayChannelInfo audioPayChannelInfo) {
        String orderId = audioPayChannelData.getOrderId();
        String key = "";
        try {
            String url = audioPayChannelInfo.getConfigValue("ek_url") + "?GKID=" + audioPayChannelInfo.getConfigValue("gk_id");
            key = HttpUtils.doPost((String)url, null, (int)15000, (int)30000);
            logger.debug("orderId:{} get encrypt key:{}", (Object)orderId, (Object)key);
        }
        catch (IOException e) {
            logger.error("orderId:" + orderId, (Throwable)e);
            return null;
        }
        if (key == null || key.equals("0~0~") || key.split("~").length != 2) {
            logger.error("orderId:{} get invalid encrypt key\uff01", (Object)orderId);
            return null;
        }
        String[] keys = key.split("~");
        String id = keys[0];
        String eftKey = keys[1];
        String dPrim = orderId + "~" + audioPayChannelData.getAccount() + "~" + audioPayChannelData.getProductCode() + "~" + audioPayChannelInfo.getConfigValue("mch_id") + "~";
        try {
            String prim = AESUtils.Encrypt((String)dPrim, (String)eftKey, (String)audioPayChannelInfo.getConfigValue("iv"));
            logger.debug("orderId:{} get prim\uff1a{}", (Object)orderId, (Object)prim);
            if (prim == null) {
                logger.error("orderId:{} get prim=null", (Object)orderId);
                return null;
            }
            StringBuilder payUrl = null;
            payUrl = "2".equals(audioPayChannelData.getPageType()) ? new StringBuilder(audioPayChannelInfo.getConfigValue("eft_url_iframe")).append("?Prim=").append(prim).append("&ID=").append(id).append("&Disp=").append(audioPayChannelData.getPayMethod()).append("&ProvinceId=&BuyCall=").append(audioPayChannelData.getPhone()) : new StringBuilder(audioPayChannelInfo.getConfigValue("eft_url_page")).append("?Prim=").append(prim).append("&ID=").append(id).append("&Tpls=").append(audioPayChannelData.getPayMethod());
            logger.info("orderId:{} with payurl:{}", (Object)orderId, (Object)payUrl);
            return payUrl.toString();
        }
        catch (Exception e) {
            logger.error("orderId:" + orderId, (Throwable)e);
            return null;
        }
    }

    public static AudioPayResult createPayResult(String prim, String id, AudioPayChannelInfo audioPayChannelInfo) {
        logger.debug("prim:{},id:{} start createPayResult", (Object)prim, (Object)id);
        String key = "";
        try {
            String url = audioPayChannelInfo.getConfigValue("dk_url") + "?ID=" + id;
            key = HttpUtils.doPost((String)url, null, (int)15000, (int)30000);
            logger.debug("id:{} get decrypt key\uff1a{}", (Object)id, (Object)key);
        }
        catch (IOException e) {
            logger.error("id:" + id, (Throwable)e);
            return null;
        }
        if (StringUtils.isAnyNullOrEmpty((String[])new String[]{key})) {
            logger.error("id:{} get decrypt key=null", (Object)id);
            return null;
        }
        String DPrim = "";
        String IV = audioPayChannelInfo.getConfigValue("iv");
        try {
            DPrim = AESUtils.Decrypt((String)prim, (String)key, (String)IV);
            logger.debug("prim:{} after decrypt:{}", (Object)prim, (Object)DPrim);
        }
        catch (Exception e) {
            logger.error("exception occurs with prim:" + prim, (Throwable)e);
            return null;
        }
        if (Strings.isNullOrEmpty((String)DPrim) || DPrim.split("~").length < 3) {
            logger.error("prim:{} after decrypt:{} is invalid", (Object)prim, (Object)DPrim);
            return null;
        }
        String[] DPrims = DPrim.split("~");
        String payState = DPrims[0];
        String orderId = DPrims[1];
        String productCode = DPrims[2];
        return new AudioPayResult(payState, orderId, productCode);
    }

    public static boolean isValidIp(HttpServletRequest request, AudioPayChannelInfo audioPayChannelInfo) {
        String ip = request.getHeader("X-Real-IP");
        if (Strings.isNullOrEmpty((String)ip)) {
            ip = request.getHeader("x-forwarded-for");
        }
        if (Strings.isNullOrEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        logger.info("clientip:{}", (Object)ip);
        if (Strings.isNullOrEmpty((String)ip)) {
            return false;
        }
        String WHITE_IPS = audioPayChannelInfo.getConfigValue("white_ip");
        return WHITE_IPS.indexOf(ip) != -1 || WHITE_IPS.indexOf("0.0.0.0") != -1;
    }
}

