/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.audiopay;

import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.gateway.common.pay.ChannelData;
import com.xunlei.channel.gateway.common.utils.JsonUtils;
import com.xunlei.channel.gateway.common.utils.StringUtils;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.audiopay.AudioPayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.audiopay.AudioPayResult;
import com.xunlei.channel.gateway.pay.channels.audiopay.AudioPayUtil;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AudioPayNotifyService
extends AbstractChannelService {
    private static final Logger logger = LoggerFactory.getLogger(AudioPayNotifyService.class);
    @Autowired
    private AudioPayChannelInfo audioPayChannelInfo;

    public String returnNotify(HttpServletRequest request) {
        String prim = request.getParameter("Prim");
        String id = request.getParameter("ID");
        if (StringUtils.isAnyNullOrEmpty((String[])new String[]{prim, id})) {
            logger.error("invalid notify with empty param:prim:{} or id:{}", (Object)prim, (Object)id);
            return this.getResultStr("401", "\u53c2\u6570\u9519\u8bef");
        }
        AudioPayResult audioPayResult = AudioPayUtil.createPayResult(prim, id, this.audioPayChannelInfo);
        logger.info("audioPayResult:{}", (Object)audioPayResult);
        if (audioPayResult == null) {
            logger.error("payresult decrypt failed");
            return this.getResultStr("111", "\u89e3\u5bc6\u5931\u8d25");
        }
        String payState = audioPayResult.getPayState();
        final String orderId = audioPayResult.getOrderId();
        final String productCode = audioPayResult.getProductCode();
        if (StringUtils.isAnyNullOrEmpty((String[])new String[]{payState, orderId, productCode})) {
            logger.error("orderId:{} invalid notify with some empty paramter in payresult", (Object)orderId);
            return this.getResultStr("401", "\u89e3\u5bc6\u540e\u660e\u6587\u6709\u53c2\u6570\u4e3a\u7a7a");
        }
        if (!"1".equals(payState)) {
            logger.error("orderId:{} payresult with payState!=1", (Object)orderId);
            return this.getResultStr("401", "\u89e3\u5bc6\u540e\u660e\u6587payState\u4e0d\u7b49\u4e8e1");
        }
        PayOrder payOrder = this.getPayOrderByXunleiPayId(orderId);
        if (null == payOrder) {
            logger.error("cannot find payOrder with xunleiPayId:{},return fail", (Object)orderId);
            return this.getResultStr("009", "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if ("S".equals(payOrder.getStatus())) {
            logger.info("payOrder:{} status was success,do nothing and return", (Object)orderId);
            return this.getResultStr("000", "\u5145\u503c\u6210\u529f");
        }
        final int orderAmt = this.audioPayChannelInfo.getProductCodeAndAmtMap().get(productCode);
        if (orderAmt != payOrder.getOrderAmt()) {
            logger.error("orderId:{} notify with productCode({}) with error orderAmt", (Object)orderId, (Object)productCode);
            return this.getResultStr("111", "\u4ea7\u54c1\u7f16\u7801\u4e0d\u4e00\u81f4");
        }
        final double PAY_RATE = this.audioPayChannelInfo.getConfigValueDouble("fee_rate");
        ChannelData channelData = new ChannelData(){

            public int getFareAmt() {
                return (int)((double)orderAmt * PAY_RATE);
            }

            public int getFactAmt() {
                return orderAmt - (int)((double)orderAmt * PAY_RATE);
            }

            public String getChannelOrderId() {
                return orderId;
            }

            public String generateOkExtJson() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("product_code", productCode);
                return JsonUtils.toJson(map);
            }
        };
        try {
            this.processPaySuccess(payOrder, channelData);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return this.getResultStr("111", "\u672a\u77e5\u9519\u8bef");
        }
        return this.getResultStr("000", "\u5145\u503c\u6210\u529f");
    }

    private String getResultStr(String code, String msg) {
        return code + "~" + msg + "~";
    }
}

