/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.arsoft;

import com.xunlei.channel.db.dao.BizDAO;
import com.xunlei.channel.db.dao.ContactReqDAO;
import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.pojo.Biz;
import com.xunlei.channel.db.pojo.ContactReq;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.gateway.common.utils.MD5Utils;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftChannelInfo;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftChannelUtils;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftCode;
import com.xunlei.xlcommons.util.http.HttpClientUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArSoftConfirmService
extends AbstractChannelService {
    private static final Logger logger = LoggerFactory.getLogger(ArSoftConfirmService.class);
    private static final String[][] sqlhandles = new String[][]{{"'", "`"}, {"<", ""}, {">", ""}};
    @Autowired
    private ArSoftChannelInfo arSoftChannelInfo;
    @Autowired
    private PayOrderDAO payOrderDAO;
    @Autowired
    private BizDAO bizDAO;
    @Autowired
    private ContactReqDAO contactReqDAO;

    public Map<String, String> callBackVerifyCode(HttpServletRequest request) {
        String orderId = this.getFilterParameter(request, "order_id");
        String tradeNo = this.getFilterParameter(request, "trade_no");
        String validate = this.getFilterParameter(request, "signMsg");
        String verifyCode = this.getFilterParameter(request, "verify_code");
        logger.info("callBackVerifyCode...orderId={},tradeNo={},verifyCode={},validate={}", new Object[]{orderId, tradeNo, verifyCode, validate});
        PayOrder payOrder = this.payOrderDAO.getPayOrder(orderId);
        if (payOrder == null) {
            logger.error("the orderId {} is not exist, return failed!", (Object)orderId);
            return this.returnResult(ArSoftCode.RTN10.getCode(), ArSoftCode.RTN1001.getCode(), ArSoftCode.RTN1001.getMsg());
        }
        if (!payOrder.getChannelOrderId().equals(tradeNo)) {
            logger.error("the channelOrderId:{}  is not equals to tradeNo:{} , return failed! orderId is {}", new Object[]{payOrder.getChannelOrderId(), tradeNo, orderId});
            return this.returnResult(ArSoftCode.RTN10.getCode(), ArSoftCode.RTN1002.getCode(), ArSoftCode.RTN1002.getMsg());
        }
        if (!payOrder.getStatus().equals("W")) {
            logger.error("orderId:{}, status:{} is not waiting status,return failed", (Object)orderId, (Object)payOrder.getStatus());
            return this.returnResult(ArSoftCode.RTN10.getCode(), ArSoftCode.RTN1003.getCode(), ArSoftCode.RTN1003.getMsg());
        }
        Biz biz = this.bizDAO.getBiz(payOrder.getBizNo());
        String strToEncode = "order_id=" + orderId + "&trade_no=" + tradeNo + "&verify_code=" + verifyCode;
        String newKey = MD5Utils.getMD5Str((String)(strToEncode + biz.getBizKey()));
        try {
            if (ArSoftChannelUtils.checkSign(newKey, validate)) {
                TreeMap<String, String> confirmParams = new TreeMap<String, String>();
                confirmParams.put("merc_id", this.arSoftChannelInfo.getMercId());
                confirmParams.put("orderid", tradeNo);
                confirmParams.put("app_id", this.arSoftChannelInfo.getAppId());
                confirmParams.put("verify_code", verifyCode);
                confirmParams.put("ver", this.arSoftChannelInfo.getVer());
                confirmParams.put("sign", ArSoftChannelUtils.createToken(confirmParams, this.arSoftChannelInfo.getKey()));
                String response = HttpClientUtil.doPost((String)this.arSoftChannelInfo.getConfirm_url(), confirmParams, null, null);
                logger.info("arsoft reponse:{}", (Object)response);
                Map<String, String> confirmResult = ArSoftChannelUtils.getConfirmParams(response);
                if ("0".equals(confirmResult.get("code")) || "200".equals(confirmResult.get("code"))) {
                    this.payOrderDAO.updatePayOrderStatusAndChannelId(orderId, "T", tradeNo);
                    logger.info("orderId:{} sms confirm successfully!", (Object)orderId);
                    return this.returnResult(ArSoftCode.RTN0.getCode(), "", ArSoftCode.RTN0.getMsg());
                }
                this.payOrderDAO.updatePayOrderStatusAndChannelId(orderId, "F", tradeNo);
                ContactReq req = this.contactReqDAO.getContactReqbySignNo(payOrder.getXunleiId(), payOrder.getXunleiPayId());
                if (req != null) {
                    req.setStatus("F");
                    req.setRemark(confirmResult.get("code"));
                    this.contactReqDAO.updateContactReq(req);
                }
                logger.info("pay failed the errorcode is {}, the error message is {}", (Object)confirmResult.get("code"), (Object)confirmResult.get("msg"));
                return this.returnResult(ArSoftCode.RTN10.getCode(), confirmResult.get("code"), confirmResult.get("msg"));
            }
            return this.returnResult(ArSoftCode.RTN10.getCode(), ArSoftCode.RTN1004.getCode(), ArSoftCode.RTN1004.getMsg());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return this.returnResult(ArSoftCode.RTN10.getCode(), ArSoftCode.RTN99.getCode(), ArSoftCode.RTN99.getMsg());
        }
    }

    private String getFilterParameter(HttpServletRequest request, String name) {
        String s = ArSoftConfirmService.escapeSql(request.getParameter(name)).trim();
        if (logger.isDebugEnabled()) {
            logger.debug("param...{}:{}", (Object)name, (Object)s);
        }
        return s;
    }

    private static final String escapeSql(String str) {
        if (str == null) {
            return "";
        }
        for (String[] ss : sqlhandles) {
            str = str.replaceAll(ss[0], ss[1]);
        }
        return str;
    }

    private Map<String, String> returnResult(String payresult, String errcode, String errmsg) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("payresult", payresult);
        map.put("errcode", errcode);
        map.put("errmsg", errmsg);
        return map;
    }
}

