/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.arsoft;

import com.xunlei.channel.db.dao.ContactReqDAO;
import com.xunlei.channel.db.dao.ContactResultDAO;
import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.pojo.ContactReq;
import com.xunlei.channel.db.pojo.ContactResult;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.DirectReturnResult;
import com.xunlei.channel.gateway.common.result.ReturnResult;
import com.xunlei.channel.gateway.pay.annotation.PayType;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelHandler;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftChannelData;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftChannelInfo;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftChannelUtils;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftCode;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import com.xunlei.xlcommons.util.Date.DateUtil;
import com.xunlei.xlcommons.util.http.HttpClientUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PayType(value="AS", desc="\u4f18\u6613\u4ed8")
public class ArSoftChannelHandler
extends AbstractChannelHandler<ReturnResult> {
    private static final Logger logger = LoggerFactory.getLogger(ArSoftChannelHandler.class);
    @Autowired
    private ArSoftChannelInfo arSoftChannelInfo;
    @Autowired
    private PayOrderDAO payOrderDAO;
    @Autowired
    private ContactReqDAO contactReqDAO;
    @Autowired
    private ContactResultDAO contactResultDAO;

    @Override
    public ReturnResult generateChannelResult(UnitedPayRequest unitedPayRequest) {
        logger.debug("begin generateChannelResult...");
        String orderAmt = unitedPayRequest.getOrderAmt() + "";
        if (!orderAmt.equals(this.arSoftChannelInfo.getOrderAmt())) {
            logger.error("orderId:{} the orderAmt is wrong", (Object)unitedPayRequest.getXunleiPayId());
            return new DirectReturnResult(InterfaceReqResult.FAIL, "30101", "the orderAmt is wrong!", "pay_fail_page", null);
        }
        String phone = unitedPayRequest.getExtraParam("phone");
        if (phone.length() != 11 || ArSoftChannelUtils.getCorpType(phone, this.getCorpType()) == null) {
            logger.error("orderId:{} the phone format is wrong,please check", (Object)unitedPayRequest.getXunleiPayId());
            return new DirectReturnResult(InterfaceReqResult.FAIL, "11", "the phone format is wrong,please check!", "pay_fail_page", null);
        }
        try {
            int orderTimes = this.payOrderDAO.getCountOfOrderRequestByXunleiIdBizNoAndDate(unitedPayRequest.getXunleiId(), unitedPayRequest.getBizNo(), this.getFromDateDaily(), new Date());
            if (orderTimes > 3) {
                logger.warn("xunleiId:{} has ordered more than 3 times today,refuse this order:{}", (Object)unitedPayRequest.getXunleiId(), (Object)unitedPayRequest.getXunleiPayId());
                return new DirectReturnResult(InterfaceReqResult.FAIL, ArSoftCode.RTN1006.getCode(), ArSoftCode.RTN1006.getMsg(), "pay_fail_page", null);
            }
            int costAmtDaily = this.payOrderDAO.getSumOfOrderRequestByphoneAndDate(unitedPayRequest.getXunleiId(), this.getFromDateDaily(), new Date());
            if (costAmtDaily > 50) {
                logger.info("xunleiId:{} has ordered more than 50 RMB today,refuse this order:{}", (Object)unitedPayRequest.getXunleiId(), (Object)unitedPayRequest.getXunleiPayId());
                return new DirectReturnResult(InterfaceReqResult.FAIL, ArSoftCode.RTN1007.getCode(), ArSoftCode.RTN1007.getMsg(), "pay_fail_page", null);
            }
            int costAmtmonth = this.payOrderDAO.getSumOfOrderRequestByphoneAndDate(unitedPayRequest.getXunleiId(), this.getFromDateMonth(), new Date());
            if (costAmtmonth > 100) {
                logger.info("xunleiId:{} has ordered more than 100 RMB this month,refuse this order:{}", (Object)unitedPayRequest.getXunleiId(), (Object)unitedPayRequest.getXunleiPayId());
                return new DirectReturnResult(InterfaceReqResult.FAIL, ArSoftCode.RTN1007.getCode(), ArSoftCode.RTN1007.getMsg(), "pay_fail_page", null);
            }
            ArSoftChannelData data = this.getArSoftChannelData(unitedPayRequest);
            String arSoftUrl = this.arSoftChannelInfo.getPayUrl();
            String response = HttpClientUtil.doPost((String)arSoftUrl, ArSoftChannelUtils.getParams(data, this.arSoftChannelInfo.getKey()), null, null);
            logger.info("orderId:{} the response is:{}", (Object)unitedPayRequest.getXunleiPayId(), (Object)response);
            Map<String, String> result = ArSoftChannelUtils.getResultParams(response);
            if ("0".equals(result.get("status"))) {
                String orderid = result.get("orderid");
                logger.info("xunleiPayId:{} get payed orderid that is {}", (Object)unitedPayRequest.getXunleiPayId(), (Object)orderid);
                this.payOrderDAO.updatePayOrderStatusAndChannelId(unitedPayRequest.getXunleiPayId(), "W", orderid);
                if ("2".equals(data.getIsMonthly())) {
                    ContactResult contactResult = this.contactResultDAO.getTheContactResult(unitedPayRequest.getXunleiId(), "AS", "QY", "S");
                    if (contactResult != null) {
                        logger.error("xunleiId:{} has contacted already,signNo is:{},refuse this time", (Object)unitedPayRequest.getXunleiId(), (Object)contactResult.getSignNo());
                        this.payOrderDAO.updatePayOrderStatusAndChannelId(unitedPayRequest.getXunleiPayId(), "F", orderid);
                        return new DirectReturnResult(InterfaceReqResult.FAIL, "11", "\u8be5\u7528\u6237\u5df2\u7ecf\u662f\u7b7e\u7ea6\u7528\u6237\u4e0d\u80fd\u6301\u7eed\u5305\u6708!", "pay_fail_page", null);
                    }
                    PayOrder payOrder = this.payOrderDAO.getPayOrder(unitedPayRequest.getXunleiPayId());
                    this.createContactRequest(payOrder);
                }
                return new DirectReturnResult(InterfaceReqResult.SUCCESS, ArSoftCode.RTN0.getCode(), unitedPayRequest.getXunleiPayId() + "_" + orderid, "pay_success_page", null);
            }
            String status = result.get("status");
            String msg = result.get("msg");
            return new DirectReturnResult(InterfaceReqResult.FAIL, status, msg, "pay_fail_page", null);
        }
        catch (Exception e) {
            logger.error("Exception occurs for xunleiPayId:" + unitedPayRequest.getXunleiPayId(), (Throwable)e);
            return new DirectReturnResult(InterfaceReqResult.FAIL, "99", "unknow error!", "pay_fail_page", null);
        }
    }

    public ContactReq createContactRequest(PayOrder payOrder) {
        ContactReq req = new ContactReq();
        req.setPayType(payOrder.getPayType());
        req.setProductId(Long.valueOf(payOrder.getProductId()));
        req.setSignNo(payOrder.getXunleiPayId());
        req.setTheType("QY");
        req.setXunleiId(payOrder.getXunleiId());
        req.setUserShow(payOrder.getUserShow());
        req.setExtraJson("");
        req.setStatus("W");
        this.contactReqDAO.saveContactReq(req);
        return req;
    }

    @Override
    public String analyzeExtParams(UnitedPayRequest unitedPayRequest) {
        String isMonthly = unitedPayRequest.getExtraParam("isMonthly");
        if (!"2".equals(isMonthly)) {
            isMonthly = "0";
        }
        return "{\"ismonthly\":\"" + isMonthly + "\"}";
    }

    private ArSoftChannelData getArSoftChannelData(UnitedPayRequest unitedPayRequest) {
        ArSoftChannelData data = new ArSoftChannelData();
        String phone = unitedPayRequest.getExtraParam("phone");
        String isMonthly = unitedPayRequest.getExtraParam("isMonthly");
        if (!"2".equals(isMonthly)) {
            isMonthly = "0";
        }
        data.setAppId(this.arSoftChannelInfo.getAppId());
        data.setMercId(this.arSoftChannelInfo.getMercId());
        data.setAppOrderid(unitedPayRequest.getXunleiPayId());
        data.setAppLevel(this.arSoftChannelInfo.getAppLevel());
        data.setMarketId(unitedPayRequest.getBizNo());
        data.setUserId(unitedPayRequest.getXunleiId());
        data.setPayCode(this.arSoftChannelInfo.getPayCode());
        data.setUserLevel(this.arSoftChannelInfo.getUserLevel());
        data.setPhone(phone);
        data.setAmount(unitedPayRequest.getOrderAmt() + "");
        data.setTime(System.currentTimeMillis() / 1000L + "");
        data.setApnType(this.arSoftChannelInfo.getApnType());
        data.setCorpType(ArSoftChannelUtils.getCorpType(phone, this.getCorpType()));
        data.setIp(unitedPayRequest.getClientIp());
        data.setIsMonthly(isMonthly);
        data.setNotiUrl(this.arSoftChannelInfo.getNotiUrl());
        data.setSiteType(this.arSoftChannelInfo.getSiteType());
        data.setScheme(this.arSoftChannelInfo.getScheme());
        data.setVer(this.arSoftChannelInfo.getVer());
        if (logger.isDebugEnabled()) {
            logger.debug("xunleiPayId={},create {} ", (Object)unitedPayRequest.getXunleiPayId(), (Object)data);
        }
        return data;
    }

    private Map<String, String> getCorpType() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", this.arSoftChannelInfo.getMobileNumbers());
        map.put("2", this.arSoftChannelInfo.getUnionNumbers());
        map.put("3", this.arSoftChannelInfo.getTelecomNumbers());
        return map;
    }

    private Date getFromDateDaily() {
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = sdf.parse(DateUtil.calculateTime((String)DateUtil.getCurrentTime((String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss", (String)"D", (int)-1));
        }
        catch (Exception e) {
            logger.error("get From Date Daily fail!", (Throwable)e);
        }
        return date;
    }

    private Date getFromDateMonth() {
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = sdf.parse(DateUtil.calculateTime((String)DateUtil.getCurrentTime((String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss", (String)"D", (int)-30));
        }
        catch (Exception e) {
            logger.error("get From Date Month fail! ", (Throwable)e);
        }
        return date;
    }
}

