/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.jdpay;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.xunlei.channel.gateway.pay.channels.jdpay.util.DESUtil;
import com.xunlei.channel.gateway.pay.channels.jdpay.util.RSACoder;
import com.xunlei.channel.gateway.pay.channels.jdpay.util.SHAUtil;
import com.xunlei.channel.gateway.pay.channels.jdpay.util.Sha256Util;
import com.xunlei.channel.gateway.pay.channels.jdpay.util.SignUtil;
import com.xunlei.channel.gateway.pay.channels.jdpay.vo.JdPayOrderRequest;
import com.xunlei.channel.gateway.pay.channels.jdpay.vo.JdPayPageNotifyResponse;
import com.xunlei.channel.gateway.pay.channels.jdpay.vo.JdPayReturnNotifyResponse;
import com.xunlei.channel.gateway.pay.channels.jdpay.vo.JdPayReturnNotifyResponseData;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;

public abstract class JdPayUtil {
    private static Logger logger = LoggerFactory.getLogger(JdPayUtil.class);
    public static final String DEFAULT_VERSION = "1.1.5";
    public static final String DEFAULT_CURRENCY = "CNY";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String EXTRA_PARAM_PHONE = "phone";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readSourceKey(String path) {
        BufferedReader reader = null;
        StringBuffer sourceKey = new StringBuffer();
        try {
            reader = new BufferedReader(new FileReader(path));
            String part = reader.readLine();
            while (part != null) {
                if (part.charAt(0) != '-') {
                    sourceKey.append(part).append("\n");
                }
                part = reader.readLine();
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("readSourceKey... read path: {}, rsa content: {}", (Object)path, (Object)sourceKey);
        }
        return sourceKey.toString();
    }

    public static String getSameIndexValueWithMatchValue(String matchValue, String configValue, String anotherConfigValue, String split) {
        String[] anotherConfigValueSplit;
        String[] configValueSplit = configValue.split(split);
        if (configValueSplit.length != (anotherConfigValueSplit = anotherConfigValue.split(split)).length) {
            logger.error("getSameIndexValueWithMatchValue... length of configValueSplit and anotherConfigValueSplit mismatch! configValueSplit.length: {}, anotherConfigValueSplit.length: {}", (Object)configValueSplit.length, (Object)anotherConfigValueSplit.length);
            return null;
        }
        for (int i = 0; i < configValueSplit.length; ++i) {
            String configValueVar = configValueSplit[i];
            if (!configValueVar.equals(matchValue)) continue;
            String found = anotherConfigValueSplit[i];
            logger.debug("getSameIndexValueWithMatchValue... matchConfigValue: {}, matched index: {}, result: {}", new Object[]{matchValue, i, found});
            return found;
        }
        logger.error("getSameIndexValueWithMatchValue... couldn't found matchConfigValue: {} in configValue: {}", (Object)matchValue, (Object)configValue);
        return null;
    }

    public static String generateOrderRequestSign(JdPayOrderRequest request, String rsaPrivateKey) throws Exception {
        ArrayList<String> unSignedKeyList = new ArrayList<String>();
        unSignedKeyList.add("merchantSign");
        unSignedKeyList.add("version");
        unSignedKeyList.add("successCallbackUrl");
        unSignedKeyList.add("forPayLayerUrl");
        String strSourceData = SignUtil.buildObjectToHttpParams(request, unSignedKeyList);
        byte[] sha256SourceSignByte = Sha256Util.encrypt(strSourceData.getBytes("UTF-8"));
        byte[] newsks = RSACoder.encryptByPrivateKey(sha256SourceSignByte, rsaPrivateKey);
        String result = RSACoder.encryptBASE64(newsks);
        logger.info("source: {} sign: {}", (Object)strSourceData, (Object)result);
        return result;
    }

    public static boolean checkPageNotifySign(JdPayPageNotifyResponse response, String sign, String rsaPublicKey) {
        String parsedSign = null;
        try {
            byte[] decryptBase64Sign = new BASE64Decoder().decodeBuffer(sign);
            byte[] bytes = RSACoder.decryptByPublicKey(decryptBase64Sign, rsaPublicKey);
            parsedSign = new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            logger.error("checkPageNotifySign... could'nt decrypt sign " + sign + " from jd!", (Throwable)e);
        }
        ArrayList<String> unSignKeyList = new ArrayList<String>();
        unSignKeyList.add("sign");
        String strSourceData = null;
        try {
            strSourceData = SignUtil.buildObjectToHttpParams(response, unSignKeyList);
        }
        catch (IllegalAccessException e) {
            logger.error("", (Throwable)e);
        }
        String originSign = SHAUtil.encrypt(strSourceData, null);
        if (originSign == null || parsedSign == null) {
            logger.warn("checkPageNotifySign... mismatch sign! sign string: {}, sign: {}, signed: {}", new Object[]{strSourceData, originSign, parsedSign});
            return false;
        }
        boolean match = originSign.equals(parsedSign);
        logger.info("checkPageNotifySign... response: {}, originSign: {}, parsedSign: {}, match: {}", new Object[]{response, originSign, parsedSign, match});
        return match;
    }

    public static String urlEncode(String input) {
        try {
            if (input == null || input.length() == 0) {
                return "";
            }
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported Encoding Exception", e);
        }
    }

    public static boolean checkReturnNotifySign(JdPayReturnNotifyResponse response, String md5Key) throws Exception {
        String sign;
        String signed = JdPayUtil.generateReturnNotifySign(response, md5Key);
        boolean equals = signed.equals(sign = response.getSign());
        if (equals) {
            logger.debug("checkReturnNotifySign... match same! signed: {}, sign: {}", (Object)signed, (Object)sign);
        } else {
            logger.error("checkReturnNotifySign... mismatch sign! signed: {}, sign: {}", (Object)signed, (Object)sign);
        }
        return equals;
    }

    public static String generateReturnNotifySign(JdPayReturnNotifyResponse response, String md5Key) throws Exception {
        String version = response.getVersion();
        String merchant = response.getMerchant();
        String terminal = response.getTerminal();
        String data = response.getData();
        return JdPayUtil.generateReturnNotifySign(version, merchant, terminal, data, md5Key);
    }

    public static JdPayReturnNotifyResponse parseReturnNotifyResponse(String base64String) throws IOException {
        XmlMapper mapper = JdPayUtil.newXmlMapper();
        byte[] bytes = Base64.decodeBase64((String)base64String);
        String xml = new String(bytes, "UTF-8");
        logger.debug("parseReturnNotifyResponse... xml: {}", (Object)xml);
        JdPayReturnNotifyResponse jdPayReturnNotifyResponse = (JdPayReturnNotifyResponse)mapper.readValue(xml, JdPayReturnNotifyResponse.class);
        return jdPayReturnNotifyResponse;
    }

    public static String decodeJdPayReturnNotifyResponseData(String cryptData, String base64DesKey) throws Exception {
        byte[] desKey = Base64.decodeBase64((String)base64DesKey);
        String rs = DESUtil.decrypt(cryptData, desKey, "UTF-8");
        return rs;
    }

    public static JdPayReturnNotifyResponseData parseJdPayReturnNotifyResponseData(String cryptData, String base64DesKey) throws Exception {
        String data = JdPayUtil.decodeJdPayReturnNotifyResponseData(cryptData, base64DesKey);
        XmlMapper mapper = JdPayUtil.newXmlMapper();
        JdPayReturnNotifyResponseData jdPayReturnNotifyResponseData = (JdPayReturnNotifyResponseData)mapper.readValue(data, JdPayReturnNotifyResponseData.class);
        return jdPayReturnNotifyResponseData;
    }

    private static String generateReturnNotifySign(String version, String merchant, String terminal, String data, String md5Key) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(version);
        sb.append(merchant);
        sb.append(terminal);
        sb.append(data);
        String sign = JdPayUtil.md5(sb.toString(), md5Key);
        return sign;
    }

    private static String md5(String text, String salt) throws Exception {
        byte[] bytes = (text + salt).getBytes();
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(bytes);
        bytes = messageDigest.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            if ((bytes[i] & 0xFF) < 16) {
                sb.append("0");
            }
            sb.append(Long.toString(bytes[i] & 0xFF, 16));
        }
        return sb.toString().toLowerCase();
    }

    public static XmlMapper newXmlMapper() {
        XmlMapper mapper = new XmlMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }
}

