/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.jdpay;

import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.pay.channels.jdpay.JdPayChannelData;
import com.xunlei.channel.gateway.pay.channels.jdpay.JdPayChannelService;
import com.xunlei.channel.gateway.pay.channels.jdpay.JdPayUtil;
import com.xunlei.channel.gateway.pay.channels.jdpay.constants.JdPayTradeResponseInfo;
import com.xunlei.channel.gateway.pay.channels.jdpay.constants.JdPayTradeResponseStatus;
import com.xunlei.channel.gateway.pay.channels.jdpay.vo.JdPayReturnNotifyResponse;
import com.xunlei.channel.gateway.pay.channels.jdpay.vo.JdPayReturnNotifyResponseData;
import com.xunlei.channel.gateway.pay.channels.jdpay.vo.JdPayReturnNotifyResponseDataReturn;
import com.xunlei.channel.gateway.pay.channels.jdpay.vo.JdPayReturnNotifyResponseDataTrade;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JdPayChannelReturnNotifyService
extends JdPayChannelService {
    private static final Logger logger = LoggerFactory.getLogger(JdPayChannelReturnNotifyService.class);
    private static final String SUCCESS_RETURN_STRING = "success";
    private static final String FAIL_RETURN_STRING = "failure";
    private static final String RETURN_NOTIFY_RESPONSE_PARAMETER_NAME = "resp";

    public String returnNotify(HttpServletRequest request) {
        try {
            JdPayReturnNotifyResponse response = this.parseResponseByHttpRequest(request);
            this.checkSign(response);
            JdPayReturnNotifyResponseData data = this.parseData(response);
            this.checkStatus(data);
            PayOrderOk payOrderOk = this.processSuccessResponse(data);
            if (payOrderOk == null) {
                return FAIL_RETURN_STRING;
            }
            logger.info("returnNotify... pay success! xunleiPayId: {}", (Object)payOrderOk.getXunleiPayId());
            return SUCCESS_RETURN_STRING;
        }
        catch (Exception e) {
            logger.error("returnNotify... caught exception in returnNotify! message: " + e.getMessage(), (Throwable)e);
            return FAIL_RETURN_STRING;
        }
    }

    private JdPayReturnNotifyResponse parseResponseByHttpRequest(HttpServletRequest request) throws Exception {
        JdPayReturnNotifyResponse jdPayReturnNotifyResponse;
        String resp = request.getParameter(RETURN_NOTIFY_RESPONSE_PARAMETER_NAME);
        try {
            jdPayReturnNotifyResponse = JdPayUtil.parseReturnNotifyResponse(resp);
            if (logger.isDebugEnabled()) {
                logger.debug("parseResponseByHttpRequest... parse response: {}, to JdPayReturnNotifyResponse: {}", (Object)resp, (Object)jdPayReturnNotifyResponse);
            }
        }
        catch (Exception e) {
            logger.error("parseResponseByHttpRequest... parse JdPayReturnNotifyResponseData error! resp: " + resp, (Throwable)e);
            throw new Exception("parse JdPayReturnNotifyResponseData error!");
        }
        return jdPayReturnNotifyResponse;
    }

    private void checkSign(JdPayReturnNotifyResponse response) throws Exception {
        String merchantMd5Key = this.channelInfo.getMerchantMd5Key();
        try {
            boolean checked = JdPayUtil.checkReturnNotifySign(response, merchantMd5Key);
            if (!checked) {
                logger.error("returnNotify... check sign error! jdPayReturnNotifyResponse: {}, merchantMd5Key: {}", (Object)response, (Object)merchantMd5Key);
                throw new Exception("check sign error!");
            }
            logger.debug("returnNotify... check sign ok! jdPayReturnNotifyResponse: {}, merchantMd5Key: {}", (Object)response, (Object)merchantMd5Key);
        }
        catch (Exception e) {
            logger.error("returnNotify... caught exception when checking sign!", (Throwable)e);
            throw new Exception("caught exception when checking sign!");
        }
    }

    private JdPayReturnNotifyResponseData parseData(JdPayReturnNotifyResponse response) throws Exception {
        String merchantDesKey = this.channelInfo.getMerchantDesKey();
        String data = response.getData();
        try {
            JdPayReturnNotifyResponseData jdPayReturnNotifyResponseData = JdPayUtil.parseJdPayReturnNotifyResponseData(data, merchantDesKey);
            if (logger.isDebugEnabled()) {
                logger.debug("parseData... parse data success! response: {}, data: {}", (Object)response, (Object)data);
            }
            return jdPayReturnNotifyResponseData;
        }
        catch (Exception e) {
            logger.error("returnNotify... caught exception when parsing response data! data: " + data, (Throwable)e);
            throw new Exception("caught exception when parsing response data");
        }
    }

    private void checkStatus(JdPayReturnNotifyResponseData data) throws Exception {
        JdPayReturnNotifyResponseDataReturn dataReturn = data.getDataReturn();
        JdPayTradeResponseInfo tradeResponseStatusByCode = JdPayTradeResponseInfo.getTradeResponseStatusByCode(dataReturn.getCode());
        if (tradeResponseStatusByCode.equals((Object)JdPayTradeResponseInfo.SUCCESS)) {
            return;
        }
        if (tradeResponseStatusByCode.equals((Object)JdPayTradeResponseInfo.PROCESSING)) {
            logger.info("returnNotify... returns processing status! status: {}", (Object)dataReturn);
        } else {
            logger.info("returnNotify... not success status! status: {}", (Object)dataReturn);
            this.processFailStatus(data);
        }
    }

    private void processFailStatus(JdPayReturnNotifyResponseData data) {
        JdPayReturnNotifyResponseDataTrade trade = data.getTrade();
        JdPayReturnNotifyResponseDataReturn dataReturn = data.getDataReturn();
        String id = trade.getId();
        PayOrder payOrder = this.getPayOrderByXunleiPayId(id);
        if (payOrder == null) {
            logger.error("processFailStatus... no such order: {} with data: {}", (Object)id, (Object)data);
            return;
        }
        String extraJson = payOrder.getExtraJson();
        String code = dataReturn.getCode();
        String desc = dataReturn.getDesc();
        this.processPayFail(payOrder, code, desc, null, extraJson);
        if (logger.isInfoEnabled()) {
            logger.info("processFailStatus... order is failed! xunleiPayId: {}, code: {}, desc: {}", new Object[]{id, code, desc});
        }
    }

    private PayOrderOk processSuccessResponse(JdPayReturnNotifyResponseData data) throws Exception {
        JdPayReturnNotifyResponseDataTrade trade = data.getTrade();
        String xunleiPayId = trade.getId();
        PayOrder payOrder = this.getPayOrderByXunleiPayId(xunleiPayId);
        String status = trade.getStatus();
        JdPayTradeResponseStatus tradeResponseStatusByCode = JdPayTradeResponseStatus.getTradeResponseStatusByCode(status);
        if (!tradeResponseStatusByCode.equals((Object)JdPayTradeResponseStatus.SUCCESS)) {
            logger.error("processSuccessResponse... trade returns not success status: {}", (Object)status);
            throw new Exception("order status is not success!");
        }
        if (this.isOrderSuccess(payOrder)) {
            logger.info("processSuccessResponse... order is already success! xunleiPayId: {}", (Object)xunleiPayId);
            return null;
        }
        if (payOrder == null) {
            logger.error("processSuccessResponse... could'nt found the order: {}", (Object)xunleiPayId);
            return null;
        }
        this.checkOrderByReturnNotify(payOrder, trade);
        JdPayChannelData channelData = this.generateChannelDataByReturnNotify(trade);
        PayOrderOk payOrderOk = this.processPaySuccess(payOrder, channelData);
        return payOrderOk;
    }

    private void checkOrderByReturnNotify(PayOrder payOrder, JdPayReturnNotifyResponseDataTrade trade) throws Exception {
        int orderAmt;
        int amount = trade.getAmount();
        if (amount != (orderAmt = payOrder.getOrderAmt())) {
            throw new Exception("\u91d1\u989d\u9519\u8bef");
        }
    }

    private JdPayChannelData generateChannelDataByReturnNotify(JdPayReturnNotifyResponseDataTrade trade) {
        int tradeAmount = trade.getAmount();
        double rateOfCharge = this.channelInfo.getRateOfCharge();
        int fareAmt = (int)Math.round(rateOfCharge * (double)tradeAmount);
        int factAmt = tradeAmount - fareAmt;
        logger.info("generateChannelDataByReturnNotify... tradeAmount: {}, rateOfCharge: {}, fareAmt: {}, factAmt: {}", new Object[]{tradeAmount, rateOfCharge, fareAmt, factAmt});
        JdPayChannelData channelData = new JdPayChannelData();
        channelData.setFareAmt(fareAmt);
        channelData.setFactAmt(factAmt);
        String json = this.generateOkJson(trade);
        channelData.setExtJson(json);
        return channelData;
    }

    private String generateOkJson(JdPayReturnNotifyResponseDataTrade trade) {
        String id = trade.getId();
        PayOrder payOrderByXunleiPayId = this.getPayOrderByXunleiPayId(id);
        String extraJson = payOrderByXunleiPayId.getExtraJson();
        return extraJson;
    }
}

