/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.jdpay;

import com.xunlei.channel.db.dao.PayOrderOkDAO;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.utils.BizUtil;
import com.xunlei.channel.gateway.common.utils.SignatureUtils;
import com.xunlei.channel.gateway.pay.channels.jdpay.constants.JdPayQueryResultCode;
import com.xunlei.channel.gateway.pay.channels.jdpay.vo.JdPayFirstOrderInfo;
import com.xunlei.channel.gateway.pay.channels.jdpay.vo.JdPayQueryResult;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JdPayChannelOrderQueryService {
    private static final Logger logger = LoggerFactory.getLogger(JdPayChannelOrderQueryService.class);
    private static final DateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final String SIGN_PARAMETER_NAME = "signMsg";
    @Autowired
    private PayOrderOkDAO payOrderOkDAO;
    @Autowired
    private BizUtil bizUtil;

    public JdPayQueryResult checkSign(String xunleiId, String bizNo, String signMsg) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put(SIGN_PARAMETER_NAME, signMsg);
        paramsMap.put("xunleiId", xunleiId);
        paramsMap.put("bizNo", bizNo);
        String bizKey = this.bizUtil.getBizKey(bizNo);
        boolean b = this.checkSign(paramsMap, bizKey);
        if (!b) {
            JdPayQueryResult signErrorResult = this.getSignErrorResult();
            logger.error("checkSign... check sign error! xunleiId: {}, bizNo: {}, signMsg: {}", new Object[]{xunleiId, bizNo, signMsg});
            return signErrorResult;
        }
        return null;
    }

    public boolean checkSign(Map<String, String> paramsMap, String bizKey) {
        boolean b = SignatureUtils.checkSign(paramsMap, (String)bizKey, (String)SIGN_PARAMETER_NAME);
        if (b) {
            if (logger.isDebugEnabled()) {
                logger.debug("checkSign... paramsMap: {}, bizKey: {}, result: {}", new Object[]{paramsMap, bizKey, b});
            }
        } else {
            logger.warn("checkSign... paramsMap: {}, bizKey: {}, result: {}", new Object[]{paramsMap, bizKey, b});
        }
        return b;
    }

    public JdPayQueryResult queryFirstPayOrderOkByXunleiIdAndPayType(String xunleiId) {
        try {
            PayOrderOk payOrderOk = this.payOrderOkDAO.getFirstPayOrderOkByXunleiIdAndPayType(xunleiId, "JD");
            JdPayQueryResult successResult = this.getSuccessResult(xunleiId, payOrderOk);
            if (logger.isDebugEnabled()) {
                logger.debug("queryFirstPayOrderOkByXunleiIdAndPayType... xunleiId: {} payOrderOk: {}, return JdPayQueryResult: {}", new Object[]{xunleiId, payOrderOk, successResult});
            }
            return successResult;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return this.getErrorResult(e);
        }
    }

    protected JdPayQueryResult getSignErrorResult() {
        JdPayQueryResult result = new JdPayQueryResult();
        result.setIsSuccess(InterfaceReqResult.FAIL);
        result.setCode(JdPayQueryResultCode.CHECK_SIGN_ERROR.getCode());
        result.setMessage(JdPayQueryResultCode.CHECK_SIGN_ERROR.getMessage());
        return result;
    }

    protected JdPayQueryResult getErrorResult(Exception e) {
        JdPayQueryResult result = new JdPayQueryResult();
        result.setIsSuccess(InterfaceReqResult.FAIL);
        result.setCode(JdPayQueryResultCode.QUERY_FAILED.getCode());
        result.setMessage(e.getMessage());
        return result;
    }

    protected JdPayQueryResult getSuccessResult(String xunleiId, PayOrderOk payOrderOk) {
        JdPayQueryResult result = new JdPayQueryResult();
        result.setIsSuccess(InterfaceReqResult.SUCCESS);
        if (payOrderOk == null) {
            result.setCode(JdPayQueryResultCode.NOT_FOUND_SUCCESS_ORDER.getCode());
            result.setMessage(JdPayQueryResultCode.NOT_FOUND_SUCCESS_ORDER.getMessage());
            if (logger.isDebugEnabled()) {
                logger.debug("getSuccessResult... xunleiId: {} not found payOrderOk", (Object)xunleiId);
            }
            return result;
        }
        String bizNo = payOrderOk.getBizNo();
        String xunleiPayId = payOrderOk.getXunleiPayId();
        Date updateTime = payOrderOk.getUpdateTime();
        String bizOrderId = payOrderOk.getBizOrderId();
        String successTime = FORMAT.format(updateTime);
        JdPayFirstOrderInfo orderInfo = new JdPayFirstOrderInfo();
        orderInfo.setBizNo(bizNo);
        orderInfo.setXunleiPayId(xunleiPayId);
        orderInfo.setXunleiId(xunleiId);
        orderInfo.setSuccessTime(successTime);
        orderInfo.setBizOrderId(bizOrderId);
        result.setCode(JdPayQueryResultCode.FOUND.getCode());
        result.setMessage(JdPayQueryResultCode.FOUND.getMessage());
        result.setOrderInfo(orderInfo);
        if (logger.isDebugEnabled()) {
            logger.debug("getSuccessResult... xunleiId: {} found payOrderOk, xunleiPayId: {}, successTime: {}", new Object[]{xunleiId, payOrderOk.getXunleiPayId(), successTime});
        }
        return result;
    }
}

