/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.jdpay;

import com.xunlei.channel.gateway.pay.channels.AbstractChannelInfo;
import com.xunlei.channel.gateway.pay.channels.jdpay.JdPayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JdPayChannelInfo
extends AbstractChannelInfo {
    private static final Logger logger = LoggerFactory.getLogger(JdPayChannelInfo.class);
    public static final String ORDER_REQUEST_URL = "/nPay.htm";
    public static final String CONFIG_VALUE_SPLIT_WORD = ",";
    public static final String CACHE_GROUP_ID = "gateway_jdpay";
    public static final String MERCHANT_NUM = "merchant_num";
    public static final String RATE_OF_CHARGE = "rate_of_charge";
    public static final String MERCHANT_RSA_PRIVATE_KEY_FILE_PATH = "merchant_rsa_private_key_file_path";
    public static final String MERCHANT_RSA_PUBLIC_KEY_FILE_PATH = "merchant_rsa_public_key_file_path";
    public static final String MERCHANT_MD5_KEY = "merchant_md5_key";
    public static final String MERCHANT_DES_KEY = "merchant_des_key";
    public static final String MERCHANT_BIZ_NO = "merchant_biz_no";
    public static final String SERVER_PAY_URL = "server_pay_url";
    public static final String SERVER_QUERY_URL = "server_query_url";
    public static final String SERVER_REFUND_URL = "server_refund_url";
    public static final String SUCCESS_CALL_BACK_URL = "success_call_back_url";
    public static final String NOTIFY_URL = "notify_url";

    @Override
    protected String getGroupId() {
        return CACHE_GROUP_ID;
    }

    public String getMerchantNumByBizNo(String bizNo) {
        String anotherSameIndexConfigValue = this.getAnotherSameIndexConfigValue(bizNo, MERCHANT_BIZ_NO, MERCHANT_NUM);
        return anotherSameIndexConfigValue;
    }

    public String getMerchantRsaPrivateKey() {
        String merchantRsaPrivateKeyFilePath = this.getConfigValue(MERCHANT_RSA_PRIVATE_KEY_FILE_PATH);
        String rsaPrivateKey = JdPayUtil.readSourceKey(merchantRsaPrivateKeyFilePath);
        return rsaPrivateKey;
    }

    public String getMerchantRsaPublicKey() {
        String merchantRsaPrivateKeyFilePath = this.getConfigValue(MERCHANT_RSA_PUBLIC_KEY_FILE_PATH);
        String rsaPublicKey = JdPayUtil.readSourceKey(merchantRsaPrivateKeyFilePath);
        return rsaPublicKey;
    }

    public String getMerchantMd5Key() {
        return this.getConfigValue(MERCHANT_MD5_KEY);
    }

    public String getMerchantDesKey() {
        return this.getConfigValue(MERCHANT_DES_KEY);
    }

    public String getBizNoByMerchantNum(String merchantNum) {
        String anotherSameIndexConfigValue = this.getAnotherSameIndexConfigValue(merchantNum, MERCHANT_NUM, MERCHANT_BIZ_NO);
        return anotherSameIndexConfigValue;
    }

    public String getServerPayUrl() {
        return this.getConfigValue(SERVER_PAY_URL);
    }

    public String getServerQueryUrl() {
        return this.getConfigValue(SERVER_QUERY_URL);
    }

    public String getServerRefundUrl() {
        return this.getConfigValue(SERVER_REFUND_URL);
    }

    public String getSuccessCallBackUrl() {
        return this.getConfigValue(SUCCESS_CALL_BACK_URL);
    }

    public String getNotifyUrl() {
        return this.getConfigValue(NOTIFY_URL);
    }

    public double getRateOfCharge() {
        return this.getConfigValueDouble(RATE_OF_CHARGE);
    }

    public String getOrderRequestUrl() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getServerPayUrl());
        buffer.append(ORDER_REQUEST_URL);
        return buffer.toString();
    }

    private String getAnotherSameIndexConfigValue(String matchConfigValue, String configName, String anotherConfigName) {
        String configValue = this.getConfigValue(configName);
        String anotherConfigValue = this.getConfigValue(anotherConfigName);
        return JdPayUtil.getSameIndexValueWithMatchValue(matchConfigValue, configValue, anotherConfigValue, CONFIG_VALUE_SPLIT_WORD);
    }
}

