/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.jdpay;

import com.xunlei.channel.db.dao.PayOrderOkDAO;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.RedirectPostResult;
import com.xunlei.channel.gateway.pay.annotation.PayType;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelHandler;
import com.xunlei.channel.gateway.pay.channels.jdpay.JdPayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.jdpay.JdPayUtil;
import com.xunlei.channel.gateway.pay.channels.jdpay.util.SignUtil;
import com.xunlei.channel.gateway.pay.channels.jdpay.vo.JdPayOrderRequest;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PayType(value="JD", desc="\u4eac\u4e1c\u652f\u4ed8")
public class JdPayChannelHandler
extends AbstractChannelHandler<RedirectPostResult> {
    public static final String PAY_TYPE = "JD";
    private static final Logger logger = LoggerFactory.getLogger(JdPayChannelHandler.class);
    private static final String ORDER_REQUEST_PAGE = "channels/jdPayRequest";
    @Autowired
    private JdPayChannelInfo channelInfo;
    @Autowired
    private PayOrderOkDAO payOrderOkDAO;

    @Override
    public RedirectPostResult generateChannelResult(UnitedPayRequest unitedPayRequest) {
        try {
            JdPayOrderRequest orderRequest = this.buildOrderRequestByUnitPayRequest(unitedPayRequest);
            Map<String, String> params = this.buildParams(orderRequest);
            return new RedirectPostResult(InterfaceReqResult.SUCCESS, null, null, null, params, ORDER_REQUEST_PAGE);
        }
        catch (Exception e) {
            logger.error("generateChannelResult... caught exception when generateChannelResult!", (Throwable)e);
            return new RedirectPostResult(InterfaceReqResult.FAIL, null, null, null, null, null);
        }
    }

    @Override
    public RedirectPostResult validateSpecialParams(UnitedPayRequest unitedPayRequest) {
        return (RedirectPostResult)super.validateSpecialParams(unitedPayRequest);
    }

    @Override
    public String analyzeExtParams(UnitedPayRequest unitedPayRequest) {
        String bizNo = unitedPayRequest.getBizNo();
        String merchantNum = this.channelInfo.getMerchantNumByBizNo(bizNo);
        return "{\"merchantNum\":\"" + merchantNum + "\"}";
    }

    private Map<String, String> buildParams(JdPayOrderRequest orderRequest) throws IllegalAccessException {
        String orderRequestUrl = this.channelInfo.getOrderRequestUrl();
        TreeMap<String, String> params = SignUtil.objectToMap(orderRequest);
        params.put("orderRequestUrl", orderRequestUrl);
        return params;
    }

    private JdPayOrderRequest buildOrderRequestByUnitPayRequest(UnitedPayRequest unitedPayRequest) throws Exception {
        JdPayOrderRequest request = new JdPayOrderRequest();
        String xunleiId = unitedPayRequest.getXunleiId();
        PayOrderOk lastPayOrderOk = this.payOrderOkDAO.getLastPayOrderOkWithChannelOrderIdByXunleiIdAndPayType(xunleiId, PAY_TYPE);
        if (lastPayOrderOk != null && lastPayOrderOk.getChannelOrderId() != null) {
            String channelOrderId = lastPayOrderOk.getChannelOrderId();
            logger.debug("buildOrderRequestByUnitPayRequest... xunleiId: {}, get token: {}", (Object)xunleiId, (Object)channelOrderId);
            request.setToken(channelOrderId);
        }
        request.setVersion("1.1.5");
        String bizNo = unitedPayRequest.getBizNo();
        String merchantNum = this.channelInfo.getMerchantNumByBizNo(bizNo);
        request.setMerchantNum(merchantNum);
        String xunleiPayId = unitedPayRequest.getXunleiPayId();
        request.setTradeNum(xunleiPayId);
        String productName = unitedPayRequest.getProductName();
        request.setTradeName(productName);
        String productDesc = unitedPayRequest.getProductDesc();
        request.setTradeDescription(productDesc);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        String formattedDate = format.format(date);
        request.setTradeTime(formattedDate);
        int orderAmt = unitedPayRequest.getOrderAmt();
        request.setTradeAmount(orderAmt);
        request.setCurrency("CNY");
        request.setSuccessCallbackUrl(this.channelInfo.getSuccessCallBackUrl());
        request.setNotifyUrl(this.channelInfo.getNotifyUrl());
        String clientIp = unitedPayRequest.getClientIp();
        request.setIp(clientIp);
        String rsaPrivateKey = this.channelInfo.getMerchantRsaPrivateKey();
        String sign = JdPayUtil.generateOrderRequestSign(request, rsaPrivateKey);
        request.setMerchantSign(sign);
        if (logger.isDebugEnabled()) {
            logger.debug("buildOrderRequestByUnitPayRequest... UnitedPayRequest: {}, generate JdPayOrderRequest: {}", (Object)unitedPayRequest, (Object)request);
        }
        return request;
    }
}

