/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.arsoft;

import com.xunlei.channel.db.dao.BizDAO;
import com.xunlei.channel.db.dao.ChannelAutoPayQuitDAO;
import com.xunlei.channel.db.dao.ChannelAutoPayResultDAO;
import com.xunlei.channel.db.dao.ContactResultDAO;
import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.pojo.Biz;
import com.xunlei.channel.db.pojo.ChannelAutoPayQuit;
import com.xunlei.channel.db.pojo.ChannelAutoPayResult;
import com.xunlei.channel.db.pojo.ContactResult;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.gateway.common.utils.MD5Utils;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftChannelInfo;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftChannelUtils;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftCode;
import com.xunlei.xlcommons.util.Date.DateUtil;
import com.xunlei.xlcommons.util.http.HttpClientUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArSoftUnsubscribeService
extends AbstractChannelService {
    private static final Logger logger = LoggerFactory.getLogger(ArSoftUnsubscribeService.class);
    private static final String[][] sqlhandles = new String[][]{{"'", "`"}, {"<", ""}, {">", ""}};
    @Autowired
    private ArSoftChannelInfo arSoftChannelInfo;
    @Autowired
    private PayOrderDAO payOrderDAO;
    @Autowired
    private ContactResultDAO contactResultDAO;
    @Autowired
    private BizDAO bizDAO;
    @Autowired
    private ChannelAutoPayResultDAO channelAutoPayResultDAO;
    @Autowired
    private ChannelAutoPayQuitDAO channelAutoPayQuitDAO;

    public Map<String, String> returnNotify(HttpServletRequest request) {
        logger.info("get request params ,{}", (Object)request.getParameterMap().toString());
        String mercId = this.arSoftChannelInfo.getMercId();
        String appId = this.arSoftChannelInfo.getAppId();
        String validate = this.getFilterParameter(request, "signMsg");
        String xunleiId = this.getFilterParameter(request, "xunlei_id");
        String signNo = this.getFilterParameter(request, "sign_no");
        String orderId = signNo.substring(signNo.indexOf(95) + 1, signNo.length());
        logger.info("get params [mercId={},appId={},phone={},validate={}]", new Object[]{mercId, appId, xunleiId, validate});
        ContactResult contactResult = this.contactResultDAO.getContactResultbySignNo(xunleiId, signNo);
        if (contactResult == null) {
            logger.error("the signNo {} is not exist , pay failed!", (Object)xunleiId);
            return this.returnResult(ArSoftCode.RTN10.getCode(), ArSoftCode.RTN1001.getCode(), ArSoftCode.RTN1001.getMsg());
        }
        PayOrder payOrder = this.payOrderDAO.getPayOrder(orderId);
        if (payOrder == null) {
            logger.error("the orderId {} \u4e0d\u5728\u8ba2\u5355\u8bf7\u6c42\u8868\u91cc", (Object)orderId);
            return this.returnResult(ArSoftCode.RTN10.getCode(), ArSoftCode.RTN1001.getCode(), ArSoftCode.RTN1001.getMsg());
        }
        String strToEncode = "&xunleiId=" + xunleiId + "&signNo=" + signNo;
        Biz biz = this.bizDAO.getBiz(payOrder.getBizNo());
        String newKey = MD5Utils.getMD5Str((String)(strToEncode + biz.getBizKey()));
        try {
            if (ArSoftChannelUtils.checkSign(newKey, validate)) {
                TreeMap<String, String> confirmParams = new TreeMap<String, String>();
                confirmParams.put("merc_id", mercId);
                confirmParams.put("app_id", appId);
                confirmParams.put("user_id", xunleiId);
                confirmParams.put("sign", ArSoftChannelUtils.createToken(confirmParams, this.arSoftChannelInfo.getKey()));
                String response = HttpClientUtil.doPost((String)this.arSoftChannelInfo.getUnSubscriberUrl(), confirmParams, null, null);
                logger.info("get arsoft's reponse witch is {}", (Object)response);
                Map<String, String> confirmResult = ArSoftChannelUtils.getConfirmParams(response);
                logger.info(confirmResult.toString());
                if ("0".equals(confirmResult.get("code")) || "200".equals(confirmResult.get("code"))) {
                    if ("JY".equals(contactResult.getTheType())) {
                        logger.error("\u8ba2\u5355{}\uff0c\u5df2\u7ecf\u89e3\u7ea6\u4e86\uff0c\u6ca1\u5fc5\u8981\u518d\u89e3\u7ea6\u54af\uff01 ", (Object)orderId);
                        return this.returnResult(ArSoftCode.RTN10.getCode(), confirmResult.get("code"), confirmResult.get("msg"));
                    }
                    ChannelAutoPayResult result = this.channelAutoPayResultDAO.getChannelAutoPayResult(payOrder.getXunleiPayId());
                    if (result == null) {
                        logger.error("\u8ba2\u5355\u53f7 {} \u4e0d\u5728\u6211\u4eec\u7684\u7eed\u8d39\u7ed3\u679c\u8868\u91cc\u9762", (Object)orderId);
                        return this.returnResult(ArSoftCode.RTN10.getCode(), confirmResult.get("code"), confirmResult.get("msg"));
                    }
                    contactResult.setTheType("JY");
                    contactResult.setRemark("\u8be5\u7b7e\u7ea6\u5df2\u89e3\u7ea6");
                    this.contactResultDAO.updateContactResult(contactResult);
                    result.setCancelDate(DateUtil.getCurrentTime((String)"yyyyMMdd"));
                    result.setPayType(payOrder.getPayType());
                    this.channelAutoPayResultDAO.updateChannelAutoPayResult(result);
                    this.createChannelAutoPayQuit(payOrder);
                    return this.returnResult(ArSoftCode.RTN0.getCode(), "", ArSoftCode.RTN0.getMsg());
                }
                logger.info("pay failed the errorcode is {}, the error message is {}", (Object)confirmResult.get("code"), (Object)confirmResult.get("msg"));
                return this.returnResult(ArSoftCode.RTN10.getCode(), confirmResult.get("code"), confirmResult.get("msg"));
            }
            return this.returnResult(ArSoftCode.RTN10.getCode(), ArSoftCode.RTN1004.getCode(), ArSoftCode.RTN1004.getMsg());
        }
        catch (Exception e) {
            logger.error("unknow error! {}", (Object)e.getMessage());
            return this.returnResult(ArSoftCode.RTN10.getCode(), ArSoftCode.RTN99.getCode(), ArSoftCode.RTN99.getMsg());
        }
    }

    private String getFilterParameter(HttpServletRequest request, String name) {
        String s = ArSoftUnsubscribeService.escapeSql(request.getParameter(name)).trim();
        logger.debug("\u8bf7\u6c42\u53c2\u6570" + name + "\u7684\u503c\u662f\uff1a" + s);
        return s;
    }

    private static final String escapeSql(String str) {
        if (str == null) {
            return "";
        }
        for (String[] ss : sqlhandles) {
            str = str.replaceAll(ss[0], ss[1]);
        }
        return str;
    }

    private Map<String, String> returnResult(String payresult, String errcode, String errmsg) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("payresult", payresult);
        map.put("errcode", errcode);
        map.put("errmsg", errmsg);
        return map;
    }

    public void createChannelAutoPayQuit(PayOrder payOrder) {
        ChannelAutoPayQuit quit = new ChannelAutoPayQuit();
        quit.setBizNo(payOrder.getBizNo());
        quit.setBizOrderId(payOrder.getBizOrderId());
        quit.setCancelTime(new Date());
        quit.setOrderAmt(Integer.valueOf(payOrder.getOrderAmt()));
        quit.setPayType(payOrder.getPayType());
        quit.setPhone(payOrder.getPhone());
        quit.setQuitType("S");
        quit.setReqTime(new Date());
        quit.setStatus("S");
        quit.setUserShow(payOrder.getUserShow());
        quit.setXunleiId(payOrder.getXunleiId());
        quit.setXunleiPayId(payOrder.getXunleiPayId());
        this.channelAutoPayQuitDAO.saveChannelAutoPayQuit(quit);
    }
}

