/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.arsoft;

import com.xunlei.channel.db.dao.BizDAO;
import com.xunlei.channel.db.dao.ChannelAutoPayQuitDAO;
import com.xunlei.channel.db.dao.ChannelAutoPayResultDAO;
import com.xunlei.channel.db.dao.ContactReqDAO;
import com.xunlei.channel.db.dao.ContactResultDAO;
import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.dao.PayOrderOkDAO;
import com.xunlei.channel.db.pojo.ChannelAutoPayQuit;
import com.xunlei.channel.db.pojo.ChannelAutoPayResult;
import com.xunlei.channel.db.pojo.ContactReq;
import com.xunlei.channel.db.pojo.ContactResult;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.utils.StringUtils;
import com.xunlei.channel.gateway.notice.service.PayNoticeService;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftChannelData;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftChannelInfo;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftChannelUtils;
import com.xunlei.xlcommons.util.Date.DateUtil;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArSoftNoticeService
extends AbstractChannelService {
    private static final Logger logger = LoggerFactory.getLogger(ArSoftNoticeService.class);
    private static final String[][] sqlhandles = new String[][]{{"'", "`"}, {"<", ""}, {">", ""}};
    private static final String SUCCESS = "success";
    private static final String FAIL = "fail";
    @Autowired
    private ArSoftChannelInfo arSoftChannelInfo;
    @Autowired
    private PayOrderDAO payOrderDAO;
    @Autowired
    private BizDAO bizDAO;
    @Autowired
    private PayOrderOkDAO payOrderOkDAO;
    @Autowired
    private ChannelAutoPayResultDAO channelAutoPayResultDAO;
    @Autowired
    private PayNoticeService payNoticeService;
    @Autowired
    private ChannelAutoPayQuitDAO channelAutoPayQuitDAO;
    @Autowired
    private ContactReqDAO contactReqDAO;
    @Autowired
    private ContactResultDAO contactResultDAO;

    public String returnNotify(HttpServletRequest request) {
        String orderId = this.getFilterParameter(request, "app_orderid");
        String status = this.getFilterParameter(request, "status");
        String isRenew = this.getFilterParameter(request, "is_renew");
        String validate = this.getFilterParameter(request, "sign");
        String isMonthly = this.getFilterParameter(request, "is_monthly");
        String statusDesc = this.getFilterParameter(request, "status_desc");
        Map<String, String> noticeParams = this.createNoticeParams(request);
        String sign = ArSoftChannelUtils.createToken(noticeParams, this.arSoftChannelInfo.getKey());
        logger.info("the orderId is {} and the status is {}", (Object)orderId, (Object)status);
        if (!ArSoftChannelUtils.checkSign(sign, validate.toUpperCase())) {
            logger.error("returnNotify... check sign error! the status {} is error and the orderId is {}", (Object)status, (Object)orderId);
            return FAIL;
        }
        PayOrder payOrder = this.payOrderDAO.getPayOrder(orderId);
        if (payOrder == null) {
            logger.error("the orderId {} \u4e0d\u5728\u8ba2\u5355\u8bf7\u6c42\u8868\u91cc", (Object)orderId);
            return FAIL;
        }
        if ("1".equals(status) && "0".equals(isRenew) || "1".equals(status) && isRenew == null || "1".equals(status) && "".equals(isRenew)) {
            if (!"T".equals(payOrder.getStatus())) {
                logger.error("the orderId {} is not the status of waiting for noticing", (Object)orderId);
                return FAIL;
            }
            if ("2".equals(isMonthly)) {
                ContactReq req = this.contactReqDAO.getContactReqbySignNo(payOrder.getXunleiId(), payOrder.getXunleiPayId());
                if (req != null) {
                    ContactResult contactResult = new ContactResult();
                    contactResult.setPayType(req.getPayType());
                    contactResult.setProductId(req.getProductId());
                    contactResult.setSignNo(req.getSignNo());
                    contactResult.setStatus("S");
                    contactResult.setUserShow(req.getUserShow());
                    contactResult.setXunleiId(req.getXunleiId());
                    contactResult.setExtraJson("");
                    contactResult.setTheType("QY");
                    this.contactResultDAO.saveContactResult(contactResult);
                    ChannelAutoPayResult result = new ChannelAutoPayResult();
                    result.setUserShow(payOrder.getUserShow());
                    result.setXunleiPayId(payOrder.getXunleiPayId());
                    result.setBizNo(payOrder.getBizNo());
                    result.setXunleiId(payOrder.getXunleiId());
                    result.setPayType(payOrder.getPayType());
                    result.setBizOrderId(payOrder.getBizOrderId());
                    result.setChannelOrderId(payOrder.getChannelOrderId());
                    result.setInputTime(new Date());
                    result.setNotifyUrl(this.arSoftChannelInfo.getNotiUrl());
                    result.setOrderAmt(Integer.valueOf(Integer.parseInt(this.arSoftChannelInfo.getOrderAmt())));
                    result.setSuccessCount(Integer.valueOf(0));
                    result.setSuccessTime(new Date());
                    result.setPeriod("M");
                    result.setCancelDate("-----");
                    result.setProductId(Long.valueOf(payOrder.getProductId()));
                    logger.info("\u9996\u6b21\u5305\u6708\u8ba2\u8d2d ,the orderId is {}", (Object)orderId);
                    this.channelAutoPayResultDAO.saveChannelAutoPayResult(result);
                } else {
                    logger.error("the orderId {} \u5728\u7b7e\u7ea6\u8bf7\u6c42\u8868\u91cc\u4e0d\u5b58\u5728", (Object)orderId);
                    return FAIL;
                }
            }
            ArSoftChannelData data = new ArSoftChannelData();
            data.setAmount(payOrder.getOrderAmt() + "");
            data.setAppOrderid(orderId);
            data.setIsMonthly(isMonthly);
            data.setOrderId(payOrder.getChannelOrderId());
            PayOrderOk payOrderOk = this.processPaySuccess(payOrder, data);
            if (payOrderOk != null) {
                logger.info("\u670d\u52a1\u53d1\u9001\u6210\u529f,the orderId is {}", (Object)orderId);
                this.payOrderDAO.updatePayOrderStatusAndChannelId(orderId, "S", payOrder.getChannelOrderId());
                return SUCCESS;
            }
            logger.error("\u670d\u52a1\u53d1\u9001\u5931\u8d25,the orderId is {}", (Object)orderId);
            return FAIL;
        }
        if ("1".equals(status) && "2".equals(isRenew)) {
            return this.autoPayNotice(payOrder, isMonthly);
        }
        if ("2".equals(status)) {
            if (!"T".equals(payOrder.getStatus())) {
                logger.error("the orderId {} is not the status of waiting for noticing", (Object)orderId);
                return FAIL;
            }
            logger.error("\u8ba2\u8d2d\u5931\u8d25,\u8ba2\u5355\u53f7\u662f {},\u5931\u8d25\u539f\u56e0\u662f{}", (Object)orderId, (Object)statusDesc);
            this.payOrderDAO.updatePayOrderStatusAndChannelId(orderId, "F", payOrder.getChannelOrderId());
            return SUCCESS;
        }
        if ("3".equals(status)) {
            logger.info("\u8ba2\u5355\u53f7 {} \u5f00\u59cb\u9000\u8ba2", (Object)orderId);
            PayOrderOk payOrderOk = this.payOrderOkDAO.getPayOrderOk(orderId);
            if (!"S".equals(payOrder.getStatus()) || payOrderOk == null) {
                logger.error("\u8ba2\u5355{}\u4e0d\u5728\u6210\u529f\u8868\u91cc ", (Object)orderId);
                return FAIL;
            }
            ContactResult contactResult = this.contactResultDAO.getContactResultbySignNo(payOrder.getXunleiId(), payOrder.getXunleiPayId());
            if (contactResult == null) {
                logger.error("\u8ba2\u5355{}\u4e0d\u5728\u7b7e\u7ea6\u8868\u91cc\uff0c\u4e0d\u5b58\u5728\u9000\u8ba2\u5173\u7cfb ", (Object)orderId);
                return FAIL;
            }
            if ("JY".equals(contactResult.getTheType())) {
                logger.error("\u8ba2\u5355{}\uff0c\u5df2\u7ecf\u89e3\u7ea6\u4e86\uff0c\u6ca1\u5fc5\u8981\u518d\u89e3\u7ea6\u54af\uff01 ", (Object)orderId);
                return FAIL;
            }
            ChannelAutoPayResult result = this.channelAutoPayResultDAO.getChannelAutoPayResult(payOrder.getXunleiPayId());
            if (result == null) {
                logger.error("\u8ba2\u5355\u53f7 {} \u4e0d\u5728\u6211\u4eec\u7684\u7eed\u8d39\u7ed3\u679c\u8868\u91cc\u9762", (Object)orderId);
                return FAIL;
            }
            contactResult.setTheType("JY");
            contactResult.setRemark("\u8be5\u7b7e\u7ea6\u5df2\u89e3\u7ea6");
            this.contactResultDAO.updateContactResult(contactResult);
            result.setCancelDate(DateUtil.getCurrentTime((String)"yyyyMMdd"));
            result.setPayType(payOrder.getPayType());
            this.channelAutoPayResultDAO.updateChannelAutoPayResult(result);
            this.createChannelAutoPayQuit(payOrder);
            return SUCCESS;
        }
        if ("4".equals(status)) {
            return SUCCESS;
        }
        logger.error("unknow error! the orderId is {}, query string: {}", (Object)orderId, (Object)request.getQueryString());
        return FAIL;
    }

    public String autoPayNotice(PayOrder payOrder, String isMonthly) {
        String orderId = payOrder.getXunleiPayId();
        PayOrderOk payOrderOk = this.payOrderOkDAO.getPayOrderOk(orderId);
        if (!"S".equals(payOrder.getStatus()) || payOrderOk == null) {
            logger.error("autoPayNotice... \u8ba2\u5355{}\u4e0d\u5728\u6210\u529f\u8868\u91cc, payOrder.status: {}, payOrderOk: {}", new Object[]{orderId, payOrder.getStatus(), payOrderOk});
            return FAIL;
        }
        ContactResult contactResult = this.contactResultDAO.getContactResultbySignNo(payOrder.getXunleiId(), payOrder.getXunleiPayId());
        if (contactResult == null) {
            logger.error("\u8ba2\u5355{}\u4e0d\u5728\u7b7e\u7ea6\u7ed3\u679c\u8868 ", (Object)orderId);
            return FAIL;
        }
        if ("JY".equals(contactResult.getTheType())) {
            logger.error("\u8ba2\u5355{},\u8be5\u7528\u6237\u5df2\u7ecf\u89e3\u7ea6\u4e86\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7eed\u8d39 ", (Object)orderId);
            return FAIL;
        }
        ChannelAutoPayResult result = this.channelAutoPayResultDAO.getChannelAutoPayResult(payOrder.getXunleiPayId());
        result.setSuccessTime(new Date());
        int count = result.getSuccessCount();
        result.setSuccessCount(Integer.valueOf(++count));
        String failCounts = result.getRemark();
        if (failCounts != null) {
            result.setRemark("");
        }
        this.channelAutoPayResultDAO.updateChannelAutoPayResult(result);
        payOrder.setXunleiPayId(payOrder.getXunleiPayId() + "_" + result.getSuccessCount());
        payOrder.setRemark("\u7eed\u8d39" + count + "\u6b21");
        String bizExt = this.buildAutoPayNoticeExt(payOrder);
        payOrder.setBizExt(bizExt);
        payOrder.setNotifyUrl(this.arSoftChannelInfo.getAutoPayMonthlyNotifyUrl());
        payOrder.setStatus("W");
        this.payOrderDAO.savePayOrder(payOrder);
        ArSoftChannelData data = new ArSoftChannelData();
        data.setAmount(payOrder.getOrderAmt() + "");
        data.setAppOrderid(orderId);
        data.setIsMonthly(isMonthly);
        data.setOrderId(payOrder.getChannelOrderId());
        payOrderOk = this.processPaySuccess(payOrder, data);
        if (payOrderOk != null) {
            logger.info("\u7eed\u8d39\u670d\u52a1\u53d1\u9001\u6210\u529f,the orderId is {}", (Object)orderId);
            this.payOrderDAO.updatePayOrderStatusAndChannelId(orderId, "S", payOrder.getChannelOrderId());
            return SUCCESS;
        }
        logger.error("\u7eed\u8d39\u670d\u52a1\u53d1\u9001\u5931\u8d25,the orderId is {}", (Object)orderId);
        return FAIL;
    }

    private String buildAutoPayNoticeExt(PayOrder payOrder) {
        String xunleiId = payOrder.getXunleiId();
        String bizNo = payOrder.getBizNo();
        HashMap<String, String> bizMap = new HashMap<String, String>();
        bizMap.put("ext1", xunleiId);
        bizMap.put("ext2", bizNo);
        String ext = StringUtils.mapToStr(bizMap, (String)"^");
        if (logger.isDebugEnabled()) {
            logger.debug("buildAutoPayNoticeExt... xunleiId: {}, bizNo: {}, to ext: {}", new Object[]{xunleiId, bizNo, ext});
        }
        return ext;
    }

    private String getFilterParameter(HttpServletRequest request, String name) {
        String s = ArSoftNoticeService.escapeSql(request.getParameter(name)).trim();
        logger.debug("\u8bf7\u6c42\u53c2\u6570" + name + "\u7684\u503c\u662f\uff1a" + s);
        return s;
    }

    private static final String escapeSql(String str) {
        if (str == null) {
            return "";
        }
        for (String[] ss : sqlhandles) {
            str = str.replaceAll(ss[0], ss[1]);
        }
        return str;
    }

    private Map<String, String> createNoticeParams(HttpServletRequest request) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            map.put(key, request.getParameter(key));
        }
        logger.info("get notice params ==> {}", (Object)((Object)map).toString());
        map.remove("sign");
        return map;
    }

    public void createChannelAutoPayQuit(PayOrder payOrder) {
        ChannelAutoPayQuit quit = new ChannelAutoPayQuit();
        quit.setBizNo(payOrder.getBizNo());
        quit.setBizOrderId(payOrder.getBizOrderId());
        quit.setCancelTime(new Date());
        quit.setOrderAmt(Integer.valueOf(payOrder.getOrderAmt()));
        quit.setPayType(payOrder.getPayType());
        quit.setPhone(payOrder.getPhone());
        quit.setQuitType("S");
        quit.setReqTime(new Date());
        quit.setStatus("S");
        quit.setUserShow(payOrder.getUserShow());
        quit.setXunleiId(payOrder.getXunleiId());
        quit.setXunleiPayId(payOrder.getXunleiPayId());
        this.channelAutoPayQuitDAO.saveChannelAutoPayQuit(quit);
    }
}

