/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.vpay;

import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.RedirectPostResult;
import com.xunlei.channel.gateway.pay.annotation.PayType;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelHandler;
import com.xunlei.channel.gateway.pay.channels.vpay.VPayChannelData;
import com.xunlei.channel.gateway.pay.channels.vpay.VPayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.vpay.VPayChannelUtil;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import com.xunlei.xlcommons.util.Arith.Arith;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PayType(value="G", desc="\u56fa\u8bdd\u652f\u4ed8\u3001V\u5e01\u652f\u4ed8|\u76c8\u534e\u8baf\u65b9\u516c\u53f8")
public class VPayChannelHandler
extends AbstractChannelHandler<RedirectPostResult> {
    private static final Logger logger = LoggerFactory.getLogger(VPayChannelHandler.class);
    @Autowired
    VPayChannelInfo vPayChannelInfo;

    @Override
    public RedirectPostResult generateChannelResult(UnitedPayRequest unitedPayRequest) {
        VPayChannelData data = new VPayChannelData();
        data.setMoney((int)Arith.div((double)unitedPayRequest.getOrderAmt(), (double)100.0));
        data.setOrderId(unitedPayRequest.getXunleiPayId());
        data.setSpId(this.vPayChannelInfo.getConfigValue("sp_id"));
        data.setSpPwd(this.vPayChannelInfo.getConfigValue("sp_pwd"));
        data.setSpRec(this.vPayChannelInfo.getConfigValue("sp_rec"));
        data.setSpReq(this.vPayChannelInfo.getConfigValue("sp_req"));
        data.setSpVersion(this.vPayChannelInfo.getConfigValue("sp_version"));
        String sign = VPayChannelUtil.genSign(data);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("spid", data.getSpId());
        paramMap.put("spname", unitedPayRequest.getProductName());
        paramMap.put("orderId", data.getOrderId());
        paramMap.put("spreq", data.getSpReq());
        paramMap.put("sprec", data.getSpRec());
        paramMap.put("usershow", unitedPayRequest.getUserShow());
        paramMap.put("userip", unitedPayRequest.getClientIp());
        paramMap.put("sign", sign);
        paramMap.put("spversion", data.getSpVersion());
        paramMap.put("money", String.valueOf(data.getMoney()));
        return new RedirectPostResult(InterfaceReqResult.SUCCESS, null, null, null, paramMap, "channels/vpayRequest");
    }

    @Override
    public RedirectPostResult validateSpecialParams(UnitedPayRequest unitedPayRequest) {
        if (!this.vPayChannelInfo.isValidAmt(unitedPayRequest.getOrderAmt())) {
            logger.error("invalid orderAmt:{}", (Object)unitedPayRequest.getOrderAmt());
            return new RedirectPostResult(InterfaceReqResult.FAIL, "13", "\u6682\u4e0d\u652f\u6301\u8be5\u91d1\u989d", null, null, "pay_fail_page");
        }
        return null;
    }
}

