/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.mycardbillingpay;

import com.google.common.base.Strings;
import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.pojo.AbstractOrder;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.gateway.common.pay.ChannelData;
import com.xunlei.channel.gateway.common.pojo.PayResult;
import com.xunlei.channel.gateway.common.utils.JsonUtils;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.mycardbillingpay.BillingReturnMsgsParser;
import com.xunlei.channel.gateway.pay.channels.mycardbillingpay.MyCardBillingPayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.mycardbillingpay.MyCardBillingPayUtil;
import com.xunlei.channel.gateway.pay.result.FailPageResult;
import com.xunlei.channel.gateway.pay.result.PageResult;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MyCardBillingPayNotifyService
extends AbstractChannelService {
    private static final Logger logger = LoggerFactory.getLogger(MyCardBillingPayNotifyService.class);
    private static final String applyReturnMsg = "MYCARD";
    @Autowired
    private PayOrderDAO payOrderDAO;
    @Autowired
    private MyCardBillingPayChannelInfo myCardBillingPayChannelInfo;

    public PageResult pageNotify(HttpServletRequest request) {
        PayOrder payOrder;
        String returnMsgNo = request.getParameter("ReturnMsgNo");
        String returnMsg = request.getParameter("ReturnMsg");
        String tradeSeq = request.getParameter("TradeSeq");
        try {
            payOrder = this.payOrderDAO.getPayOrder(tradeSeq);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return new FailPageResult("\u8ba2\u5355\u652f\u4ed8\u7ed3\u679c\u6682\u65f6\u65e0\u6cd5\u786e\u8ba4\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b");
        }
        try {
            this.dealNotify(payOrder, tradeSeq, returnMsgNo, returnMsg);
            return this.generatePageUrlAndParams((AbstractOrder)payOrder, PayResult.SUCCESS.getValue(), 0);
        }
        catch (Exception e) {
            return new FailPageResult(e.getMessage());
        }
    }

    public String returnNotify(HttpServletRequest request) {
        String xmlMessage = request.getParameter("data");
        logger.info("returnNotify data:{}", (Object)xmlMessage);
        try {
            List<Map<String, String>> records = MyCardBillingPayUtil.getXmlResponse(xmlMessage);
            Iterator<Map<String, String>> iterator = records.iterator();
            if (iterator.hasNext()) {
                Map<String, String> recordMap = iterator.next();
                try {
                    this.dealOneRecordMap(recordMap);
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
            return applyReturnMsg;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return applyReturnMsg;
        }
    }

    private void dealOneRecordMap(Map<String, String> recordMap) throws Exception {
        String tradeSeq = recordMap.get("TradeSeq");
        String returnMsgNo = recordMap.get("ReturnMsgNo");
        String returnMsg = recordMap.get("ReturnMsg");
        logger.info("deal orderid:{} ", (Object)tradeSeq);
        if (tradeSeq != null && !tradeSeq.isEmpty()) {
            PayOrder payOrder = this.payOrderDAO.getPayOrder(tradeSeq);
            this.dealNotify(payOrder, tradeSeq, returnMsgNo, returnMsg);
        }
    }

    private void dealNotify(PayOrder payOrder, String tradeSeq, String returnMsgNo, String returnMsg) throws Exception {
        if (payOrder == null) {
            logger.error("cannot find payOrder:{},ignore", (Object)tradeSeq);
            throw new Exception("\u53d1\u751f\u9519\u8bef\uff1a\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if ("S".equals(payOrder.getStatus())) {
            logger.info("payOrder:{} status was success,do nothing and return", (Object)tradeSeq);
            return;
        }
        if (!"1".equals(returnMsgNo)) {
            this.processPayFail(payOrder, returnMsgNo, returnMsg, payOrder.getChannelOrderId(), null);
            if (Strings.isNullOrEmpty((String)returnMsg)) {
                returnMsg = "\u8ba2\u5355\u652f\u4ed8\u5931\u8d25";
            }
            throw new Exception(returnMsg);
        }
        Map payOrderExtraMap = (Map)JsonUtils.toObject((String)payOrder.getExtraJson(), Map.class);
        final String authCode = (String)payOrderExtraMap.get("auth_code");
        List<String> queryRespList = MyCardBillingPayUtil.queryOrderResult(this.myCardBillingPayChannelInfo.getCacheQueryUrl(), authCode);
        logger.info("query order with resp:{}", queryRespList);
        String queryResult = queryRespList.get(0).trim();
        String orderPayResult = queryRespList.get(2).trim();
        if ("1".equals(queryResult) && "3".equals(orderPayResult)) {
            List<String> paymentConfirmResultList = MyCardBillingPayUtil.paymentConfirm(this.myCardBillingPayChannelInfo.getCacheConfirmUrl(), payOrder.getUserShow(), authCode);
            logger.info("authcode:{} with paymentConfirmResult:{}", (Object)authCode, paymentConfirmResultList);
            String paymentConfirmResult = paymentConfirmResultList.get(0).trim();
            if ("1".equals(paymentConfirmResult)) {
                logger.error("xunleipayid:{} authcode:{} pay success", (Object)payOrder.getXunleiPayId(), (Object)authCode);
                final int orderAmt = payOrder.getOrderAmt();
                final String channelOrderId = payOrder.getChannelOrderId();
                final double PAY_RATE = this.myCardBillingPayChannelInfo.getCacheFeeRate();
                ChannelData channelData = new ChannelData(){

                    public int getFareAmt() {
                        return (int)((double)orderAmt * PAY_RATE);
                    }

                    public int getFactAmt() {
                        return orderAmt - (int)((double)orderAmt * PAY_RATE);
                    }

                    public String getChannelOrderId() {
                        return channelOrderId;
                    }

                    public String generateOkExtJson() {
                        HashMap<String, String> extraJsonMap = new HashMap<String, String>();
                        extraJsonMap.put("auth_code", authCode);
                        return JsonUtils.toJson(extraJsonMap);
                    }
                };
                try {
                    this.processPaySuccess(payOrder, channelData);
                    return;
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    throw new Exception("\u8ba2\u5355\u652f\u4ed8\u7ed3\u679c\u6682\u65f6\u65e0\u6cd5\u786e\u8ba4\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b");
                }
            }
            this.processPayFail(payOrder, returnMsgNo, returnMsg, payOrder.getChannelOrderId(), null);
            String errorMsg = BillingReturnMsgsParser.getVerifyMsgMap(returnMsgNo);
            if (Strings.isNullOrEmpty((String)errorMsg)) {
                errorMsg = "\u8ba2\u5355\u672a\u652f\u4ed8\u6210\u529f";
            }
            throw new Exception(errorMsg);
        }
        if ("1".equals(queryResult) && !"3".equals(orderPayResult)) {
            this.processPayFail(payOrder, returnMsgNo, returnMsg, payOrder.getChannelOrderId(), null);
            String errorMsg = BillingReturnMsgsParser.getCheckMsgMap(returnMsgNo);
            if (Strings.isNullOrEmpty((String)errorMsg)) {
                errorMsg = "\u8ba2\u5355\u672a\u652f\u4ed8\u6210\u529f";
            }
            throw new Exception(errorMsg);
        }
        logger.error("authcode:{} query order result failed", (Object)authCode);
        throw new Exception("\u8ba2\u5355\u652f\u4ed8\u7ed3\u679c\u6682\u65f6\u65e0\u6cd5\u786e\u8ba4\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b");
    }
}

