/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.hebao;

import com.xunlei.channel.db.pojo.AbstractOrder;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.pojo.PayResult;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.hebao.HebaoChannelData;
import com.xunlei.channel.gateway.pay.channels.hebao.HebaoUtils;
import com.xunlei.channel.gateway.pay.channels.hebao.HebaoWapChannelInfo;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HebaoChannelService
extends AbstractChannelService {
    private static final String SUCCESS = "SUCCESS";
    private static final String FAILED = "FAILED";
    private static final Logger logger = LoggerFactory.getLogger(HebaoChannelService.class);
    @Autowired
    private HebaoWapChannelInfo hebaoWapChannelInfo;

    public String returnNotifyWap(HttpServletRequest request) {
        logger.info("returnNotifyWap...params:{}", (Object)this.getRequestParams(request));
        String signKey = this.hebaoWapChannelInfo.getMerchantKey();
        try {
            String merchantId = this.getNotNullParam(request, "merchantId");
            String payNo = this.getNotNullParam(request, "payNo");
            String returnCode = this.getNotNullParam(request, "returnCode");
            String message = this.getNotNullParam(request, "message");
            String signType = this.getNotNullParam(request, "signType");
            String type = this.getNotNullParam(request, "type");
            String version = this.getNotNullParam(request, "version");
            String amount = this.getNotNullParam(request, "amount");
            String amtItem = this.getNotNullParam(request, "amtItem");
            String bankAbbr = this.getNotNullParam(request, "bankAbbr");
            String mobile = this.getNotNullParam(request, "mobile");
            String orderId = this.getNotNullParam(request, "orderId");
            String payDate = this.getNotNullParam(request, "payDate");
            String reserved1 = this.getNotNullParam(request, "reserved1");
            String reserved2 = this.getNotNullParam(request, "reserved2");
            String status = this.getNotNullParam(request, "status");
            String orderDate = request.getParameter("orderDate");
            String fee = this.getNotNullParam(request, "fee");
            String hmac = this.getNotNullParam(request, "hmac");
            String accountDate = this.getNotNullParam(request, "accountDate");
            PayOrder payOrder = this.getPayOrderByXunleiPayId(orderId);
            if (null == payOrder) {
                logger.error("cannot find payOrder with xunleiPayId:{}", (Object)orderId);
                return SUCCESS;
            }
            StringBuilder signData = new StringBuilder(merchantId).append(payNo).append(returnCode).append(message).append(signType).append(type).append(version).append(amount).append(amtItem).append(bankAbbr).append(mobile).append(orderId).append(payDate).append(accountDate).append(reserved1).append(reserved2).append(status).append(orderDate).append(fee);
            logger.info("orignal:{}", (Object)signData.toString());
            String ourHmac = HebaoUtils.MD5Sign(signData.toString(), signKey);
            if (!ourHmac.equals(hmac)) {
                logger.error("invalid md5...hmac:{},ours:{}", (Object)hmac, (Object)ourHmac);
                return this.generateRedirectUrl((AbstractOrder)payOrder, PayResult.FAILED.getValue(), "99", 0);
            }
            if (!SUCCESS.equals(status)) {
                logger.error("unsuccess...status:{},returnCode:{},message:{}", new Object[]{status, returnCode, URLDecoder.decode(message, "UTF-8")});
                return this.generateRedirectUrl((AbstractOrder)payOrder, PayResult.FAILED.getValue(), "99", 0);
            }
            HebaoChannelData data = new HebaoChannelData();
            data.setChannelOrderId(orderId);
            data.setFareAmt((int)(100.0 * Double.parseDouble(fee)));
            data.setOrderAmt(Integer.parseInt(amount));
            if ("S".equals(payOrder.getStatus())) {
                logger.info("payOrder:{} status was success,do nothing and return", (Object)orderId);
                return SUCCESS;
            }
            PayOrderOk payOrderOk = this.processPaySuccess(payOrder, data);
            return null != payOrderOk ? SUCCESS : FAILED;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String pageNotifyWap(HttpServletRequest request) {
        logger.info("pageNotifyWap...params:{}", (Object)this.getRequestParams(request));
        String signKey = this.hebaoWapChannelInfo.getMerchantKey();
        try {
            String merchantId = this.getNotNullParam(request, "merchantId");
            String payNo = this.getNotNullParam(request, "payNo");
            String returnCode = this.getNotNullParam(request, "returnCode");
            String message = this.getNotNullParam(request, "message");
            String signType = this.getNotNullParam(request, "signType");
            String type = this.getNotNullParam(request, "type");
            String version = this.getNotNullParam(request, "version");
            String amount = this.getNotNullParam(request, "amount");
            String amtItem = this.getNotNullParam(request, "amtItem");
            String bankAbbr = this.getNotNullParam(request, "bankAbbr");
            String mobile = this.getNotNullParam(request, "mobile");
            String orderId = this.getNotNullParam(request, "orderId");
            String payDate = this.getNotNullParam(request, "payDate");
            String reserved1 = this.getNotNullParam(request, "reserved1");
            String reserved2 = this.getNotNullParam(request, "reserved2");
            String status = this.getNotNullParam(request, "status");
            String orderDate = this.getNotNullParam(request, "orderDate");
            String fee = this.getNotNullParam(request, "fee");
            String hmac = this.getNotNullParam(request, "hmac");
            String accountDate = this.getNotNullParam(request, "accountDate");
            PayOrder payOrder = this.getPayOrderByXunleiPayId(orderId);
            if (null == payOrder) {
                logger.error("cannot find payOrder with xunleiPayId:{},return success", (Object)orderId);
                return SUCCESS;
            }
            StringBuilder signData = new StringBuilder(merchantId).append(payNo).append(returnCode).append(message).append(signType).append(type).append(version).append(amount).append(amtItem).append(bankAbbr).append(mobile).append(orderId).append(payDate).append(accountDate).append(reserved1).append(reserved2).append(status).append(orderDate).append(fee);
            logger.info("orignal:{}", (Object)signData.toString());
            String ours = HebaoUtils.MD5Sign(signData.toString(), signKey);
            if (!ours.equals(hmac)) {
                logger.error("invalid md5...hmac:{},ours:{}", (Object)hmac, (Object)ours);
                return FAILED;
            }
            if (!SUCCESS.equals(status)) {
                logger.warn("xunleiPayId:{},status:{} is not success,nothing to do", (Object)orderId, (Object)status);
                return SUCCESS;
            }
            int feeAmt = (int)(100.0 * Double.parseDouble(fee));
            return this.generateRedirectUrl((AbstractOrder)payOrder, PayResult.SUCCESS.getValue(), "", feeAmt);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return FAILED;
        }
    }
}

