/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.baiduwallet;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import com.xunlei.channel.db.pojo.AbstractOrder;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.pojo.PayResult;
import com.xunlei.channel.gateway.common.utils.BizUtil;
import com.xunlei.channel.gateway.common.utils.HttpUtils;
import com.xunlei.channel.gateway.common.utils.MD5Utils;
import com.xunlei.channel.gateway.common.utils.SignatureUtils;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.baiduwallet.BaiduNewUserResponse;
import com.xunlei.channel.gateway.pay.channels.baiduwallet.BaiduWalletChannelData;
import com.xunlei.channel.gateway.pay.channels.baiduwallet.BaiduWalletChannelInfo;
import com.xunlei.channel.gateway.pay.channels.baiduwallet.BaiduWalletUtils;
import com.xunlei.channel.gateway.pay.result.FailPageResult;
import com.xunlei.channel.gateway.pay.result.PageResult;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaiduWalletService
extends AbstractChannelService {
    private static final Logger logger = LoggerFactory.getLogger(BaiduWalletService.class);
    private static final String SUCCESS = "OK";
    private static final String FAILED = "Failed";
    @Autowired
    private BaiduWalletChannelInfo baiduWalletChannelInfo;
    @Autowired
    private BizUtil bizUtil;

    public String returnNotify(HttpServletRequest request) {
        BaiduWalletChannelData baiduChannelData = BaiduWalletUtils.parseNotifyData(request);
        logger.info("receive baidu-wallet notify....orderId:{}", (Object)baiduChannelData.getOrderNo());
        baiduChannelData.setSpKey(this.baiduWalletChannelInfo.getSpKey(baiduChannelData.getSpNo()));
        if (!this.checkSign(baiduChannelData, baiduChannelData.getSign())) {
            logger.warn("signMsg is invalid...orderNo:{}", (Object)baiduChannelData.getOrderNo());
            return "invalid sign";
        }
        if (!"1".equals(baiduChannelData.getPayResult())) {
            logger.info("payResult:{},not success,do nothing and return", (Object)baiduChannelData.getPayResult());
            return SUCCESS;
        }
        PayOrder payOrder = this.getPayOrderByXunleiPayId(baiduChannelData.getOrderNo());
        if (null == payOrder) {
            logger.error("cannot find payOrder with xunleiPayId:{},return success", (Object)baiduChannelData.getOrderNo());
            return FAILED;
        }
        if (!baiduChannelData.getTotalAmount().equals(payOrder.getOrderAmt())) {
            logger.error("orderAmt mismatch...payOrder.orderAmt:{},baidu.totalAmount:{}", (Object)payOrder.getOrderAmt(), (Object)baiduChannelData.getTotalAmount());
            return FAILED;
        }
        if ("S".equals(payOrder.getStatus())) {
            logger.info("payOrder:{} status was success,do nothing and return");
            return SUCCESS;
        }
        PayOrderOk payOrderOk = this.processPaySuccess(payOrder, baiduChannelData);
        return null != payOrderOk ? SUCCESS : FAILED;
    }

    private boolean checkSign(BaiduWalletChannelData data, String sign) {
        if (null == data || Strings.isNullOrEmpty((String)sign)) {
            return false;
        }
        try {
            String notifySignMsg = BaiduWalletUtils.generatedRespSignMsg(data);
            if (!sign.equalsIgnoreCase(notifySignMsg)) {
                logger.info("order id:{},signMsg is:{},and notifySignMsg is:{} ", new Object[]{data.getOrderNo(), sign, notifySignMsg});
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.error("order id:{}, check sign with exception:{}", (Object)data.getOrderNo(), (Object)e.getMessage());
            return false;
        }
    }

    public PageResult pageNotify(HttpServletRequest request) {
        BaiduWalletChannelData baiduChannelData = BaiduWalletUtils.parseNotifyData(request);
        logger.info("receive baidu-wallet pageNotify....orderId:{}", (Object)baiduChannelData.getOrderNo());
        baiduChannelData.setSpKey(this.baiduWalletChannelInfo.getSpKey(baiduChannelData.getSpNo()));
        if (!this.checkSign(baiduChannelData, baiduChannelData.getSign())) {
            logger.error("signMsg is invalid...orderNo:{}", (Object)baiduChannelData.getOrderNo());
            return new FailPageResult("\u8ba2\u5355\u652f\u4ed8\u7ed3\u679c\u6682\u65f6\u65e0\u6cd5\u786e\u8ba4\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b");
        }
        if (!"1".equals(baiduChannelData.getPayResult())) {
            logger.warn("payResult:{},not success,do nothing and return", (Object)baiduChannelData.getPayResult());
            return new FailPageResult("\u8ba2\u5355\u652f\u4ed8\u7ed3\u679c\u6682\u65f6\u65e0\u6cd5\u786e\u8ba4\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b");
        }
        PayOrder payOrder = this.getPayOrderByXunleiPayId(baiduChannelData.getOrderNo());
        if (null == payOrder) {
            logger.error("cannot find payOrder with xunleiPayId:{},ignore", (Object)baiduChannelData.getOrderNo());
            return new FailPageResult("\u53d1\u751f\u9519\u8bef\uff1a\u6ca1\u6709\u627e\u5230\u8be5\u8fc5\u96f7\u652f\u4ed8\u53f7:" + baiduChannelData.getOrderNo());
        }
        if (!baiduChannelData.getTotalAmount().equals(payOrder.getOrderAmt())) {
            logger.error("orderAmt mismatch...payOrder.orderAmt:{},baidu.totalAmount:{}", (Object)payOrder.getOrderAmt(), (Object)baiduChannelData.getTotalAmount());
            return new FailPageResult("\u8ba2\u5355\u652f\u4ed8\u7ed3\u679c\u6682\u65f6\u65e0\u6cd5\u786e\u8ba4\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b");
        }
        if ("S".equals(payOrder.getStatus())) {
            logger.info("payOrder:{} status was success,do nothing and return", (Object)baiduChannelData.getOrderNo());
            PayOrderOk payOrderOk = this.getPayOrderOkByXunleiPayId(payOrder.getXunleiPayId());
            if (null != payOrderOk) {
                return this.generatePageUrlAndParams((AbstractOrder)payOrderOk, PayResult.SUCCESS.getValue(), payOrderOk.getFareAmt());
            }
            logger.error("error,cannot find PayOrderOk...xunleiPayId:{}", (Object)payOrder.getXunleiPayId());
            return this.generatePageUrlAndParams((AbstractOrder)payOrder, PayResult.SUCCESS.getValue(), 0);
        }
        PayOrderOk payOrderOk = this.processPaySuccess(payOrder, baiduChannelData);
        return this.generatePageUrlAndParams((AbstractOrder)payOrderOk, PayResult.SUCCESS.getValue(), payOrderOk.getFareAmt());
    }

    public BaiduNewUserResponse processBaiduNewUser(String bizNo, String xlpayId, String signMsg) {
        if (Strings.isNullOrEmpty((String)bizNo) || Strings.isNullOrEmpty((String)xlpayId) || Strings.isNullOrEmpty((String)signMsg)) {
            return BaiduNewUserResponse.genereateErrorResponse(1006, "all params must not be empty");
        }
        String bizKey = this.bizUtil.getBizKey(bizNo);
        if (Strings.isNullOrEmpty((String)bizKey)) {
            return BaiduNewUserResponse.genereateErrorResponse(1001, "invalid bizNo");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("bizNo", bizNo);
        params.put("xlpayId", xlpayId);
        params.put("signMsg", signMsg);
        if (!SignatureUtils.checkSign(params, (String)bizKey, (String)"signMsg")) {
            return BaiduNewUserResponse.genereateErrorResponse(1002, "invalid signMsg");
        }
        String baiduURL = this.generateBaiduNewUserURL(bizNo, xlpayId);
        try {
            String baiduResponse = HttpUtils.doGet((String)baiduURL);
            logger.info("baiduURL:{},response:{}", (Object)baiduURL, (Object)baiduResponse);
            JSONObject baiduObject = JSON.parseObject((String)baiduResponse);
            String err = baiduObject.getString("err");
            if (!"0".equals(err)) {
                return BaiduNewUserResponse.genereateErrorResponse(1004, err);
            }
            JSONObject content = baiduObject.getJSONObject("content");
            String broughtNewUser = content.getString("has_brought_newuser");
            return BaiduNewUserResponse.genereateSuccessResponse("1".equals(broughtNewUser) ? 1 : 0);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return BaiduNewUserResponse.genereateErrorResponse(1005, "network error");
        }
    }

    private String generateBaiduNewUserURL(String bizNO, String xunleiPayId) {
        String spNo = this.baiduWalletChannelInfo.getSpNo(true);
        StringBuilder sb = new StringBuilder("order_no=").append(xunleiPayId).append("&sign_method=1&sp_no=").append(spNo);
        String params = sb.toString();
        sb.append("&key=").append(this.baiduWalletChannelInfo.getSpKey(spNo));
        logger.debug("MD5 original String:{}", (Object)sb.toString());
        String md5Sign = MD5Utils.getMD5Str((String)sb.toString());
        return this.baiduWalletChannelInfo.getBaiduNewUserURL() + "?" + params + "&sign=" + md5Sign;
    }
}

