/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.audiopay;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.RedirectGetResult;
import com.xunlei.channel.gateway.common.utils.JsonUtils;
import com.xunlei.channel.gateway.common.utils.StringUtils;
import com.xunlei.channel.gateway.pay.annotation.PayType;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelHandler;
import com.xunlei.channel.gateway.pay.channels.audiopay.AudioPayChannelData;
import com.xunlei.channel.gateway.pay.channels.audiopay.AudioPayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.audiopay.AudioPayUtil;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@PayType(value="AU", desc="\u7535\u8bdd\u3001\u77ed\u4fe1\u652f\u4ed8|\u76db\u5cf0\u8fdc\u666f\u516c\u53f8")
public class AudioPayChannelHandler
extends AbstractChannelHandler<RedirectGetResult> {
    private static final Logger logger = LoggerFactory.getLogger(AudioPayChannelHandler.class);
    @Autowired
    AudioPayChannelInfo audioPayChannelInfo;

    @Override
    public RedirectGetResult generateChannelResult(UnitedPayRequest unitedPayRequest) {
        AudioPayChannelData audioPayChannelData = this.generateChannelData(unitedPayRequest);
        String payUrl = AudioPayUtil.createPayUrl(audioPayChannelData, this.audioPayChannelInfo);
        if (payUrl == null) {
            logger.error("orderId:{} create pay url failed", (Object)audioPayChannelData.getOrderId());
            return new RedirectGetResult(InterfaceReqResult.FAIL, "99", "\u7a0b\u5e8f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", "pay_fail_page", null);
        }
        return new RedirectGetResult(InterfaceReqResult.SUCCESS, "", "", null, payUrl);
    }

    protected AudioPayChannelData generateChannelData(UnitedPayRequest unitedPayRequest) {
        String orderId = unitedPayRequest.getXunleiPayId();
        String account = unitedPayRequest.getUserShow();
        String productCode = unitedPayRequest.getExtraParamsMap().get("product_code");
        String payMethod = unitedPayRequest.getExtraParamsMap().get("pay_method");
        String pageType = unitedPayRequest.getExtraParamsMap().get("page_type");
        String phone = unitedPayRequest.getExtraParamsMap().get("phone");
        AudioPayChannelData audioPayChannelData = new AudioPayChannelData();
        audioPayChannelData.setAccount(account);
        audioPayChannelData.setOrderId(orderId);
        audioPayChannelData.setProductCode(productCode);
        audioPayChannelData.setPayMethod(payMethod);
        audioPayChannelData.setPageType(pageType);
        audioPayChannelData.setPhone(phone);
        audioPayChannelData.setOrderAmt(unitedPayRequest.getOrderAmt());
        return audioPayChannelData;
    }

    @Override
    public RedirectGetResult validateSpecialParams(UnitedPayRequest unitedPayRequest) {
        String phone;
        String productCode = unitedPayRequest.getExtraParamsMap().get("product_code");
        String payMethod = unitedPayRequest.getExtraParamsMap().get("pay_method");
        String pageType = unitedPayRequest.getExtraParamsMap().get("page_type");
        HashMap<String, Integer> productCodeAndAmtMap = this.audioPayChannelInfo.getProductCodeAndAmtMap();
        if (Strings.isNullOrEmpty((String)productCode) || productCodeAndAmtMap.get(productCode) == null) {
            logger.error("invalid product_code:{}", (Object)productCode);
            return new RedirectGetResult(InterfaceReqResult.FAIL, "13", "invalid param product_code", "pay_fail_page", null);
        }
        if (Strings.isNullOrEmpty((String)payMethod) || !this.audioPayChannelInfo.getPayMethodList().contains(payMethod)) {
            logger.error("invalid pay_method:{}", (Object)payMethod);
            return new RedirectGetResult(InterfaceReqResult.FAIL, "13", "invalid param pay_method", "pay_fail_page", null);
        }
        if (Strings.isNullOrEmpty((String)pageType)) {
            pageType = "1";
            unitedPayRequest.getExtraParamsMap().put("page_type", pageType);
        } else if (!this.audioPayChannelInfo.getPageTypeList().contains(pageType)) {
            logger.error("invalid page_type:{}", (Object)pageType);
            return new RedirectGetResult(InterfaceReqResult.FAIL, "13", "invalid param page_type", "pay_fail_page", null);
        }
        if ("2".equals(pageType) && (StringUtils.isAnyNullOrEmpty((String[])new String[]{phone = unitedPayRequest.getExtraParamsMap().get("phone")}) || phone.length() > 20)) {
            logger.error("pay with invalid phone:{}", (Object)phone);
            return new RedirectGetResult(InterfaceReqResult.FAIL, "13", "invalid param phone", "pay_fail_page", null);
        }
        int amount = unitedPayRequest.getOrderAmt();
        if (amount != (Integer)productCodeAndAmtMap.get(productCode)) {
            logger.error("productCode:{} with invalid orderAmt({}),diffrent with gateway orderAmt({})", new Object[]{productCode, amount, productCodeAndAmtMap.get(productCode)});
            return new RedirectGetResult(InterfaceReqResult.FAIL, "13", "invalid order_amt with the product_code", "pay_fail_page", null);
        }
        return null;
    }

    @Override
    public String analyzeExtParams(UnitedPayRequest unitedPayRequest) {
        String productCode = unitedPayRequest.getExtraParamsMap().get("product_code");
        String payMethod = unitedPayRequest.getExtraParamsMap().get("pay_method");
        String pageType = unitedPayRequest.getExtraParamsMap().get("page_type");
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put("product_code", productCode);
        extParams.put("pay_method", payMethod);
        extParams.put("page_type", pageType);
        return JsonUtils.toJson(extParams);
    }
}

