/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.arsoft;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.pay.channels.arsoft.ArSoftChannelData;
import com.xunlei.xlcommons.util.Json.JsonLibUtil;
import com.xunlei.xlcommons.util.MD5.Md5Encrypt;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArSoftChannelUtils {
    private static final Logger logger = LoggerFactory.getLogger(ArSoftChannelUtils.class);
    public static final String MOBILE = "1";
    public static final String UNION = "2";
    public static final String TELECOM = "3";

    public static String getCorpType(String phone, Map<String, String> corpTypes) {
        String prePhone = phone.substring(0, 3);
        Set<String> keys = corpTypes.keySet();
        for (String key : keys) {
            String corpType = corpTypes.get(key);
            if (!corpType.contains(prePhone)) continue;
            return key;
        }
        return null;
    }

    public static Map<String, String> getParams(ArSoftChannelData data, String key) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("merc_id", data.getMercId());
        params.put("app_orderid", data.getAppOrderid());
        params.put("app_id", data.getAppId());
        params.put("app_level", data.getAppLevel());
        params.put("market_id", data.getMarketId());
        params.put("user_id", data.getUserId());
        params.put("pay_code", data.getPayCode());
        params.put("user_level", data.getUserLevel());
        params.put("phone", data.getPhone());
        params.put("amount", data.getAmount());
        params.put("time", data.getTime());
        params.put("apn_type", data.getApnType());
        params.put("corp_type", data.getCorpType());
        params.put("ip", data.getIp());
        params.put("is_monthly", data.getIsMonthly());
        params.put("noti_url", data.getNotiUrl());
        params.put("site_type", data.getSiteType());
        params.put("scheme", data.getScheme());
        params.put("ver", data.getVer());
        params.put("sign", ArSoftChannelUtils.createToken(params, key));
        return params;
    }

    public static String createToken(Map<String, String> params, String keySecret) {
        StringBuffer str = new StringBuffer();
        params.put("merc_key", keySecret);
        Set<String> set = params.keySet();
        for (String key : set) {
            str.append(key).append("=").append(params.get(key)).append("&");
        }
        String newStr = str.substring(0, str.length() - 1);
        logger.info("the send url params is {}", (Object)newStr);
        return Md5Encrypt.encode((String)newStr, (String)"UTF-8").toUpperCase();
    }

    public static Map<String, String> getResultParams(String response) {
        HashMap<String, String> result = new HashMap<String, String>();
        Map map = JsonLibUtil.jsonToMap((String)response);
        String status = map.get("status") + "";
        String message = map.get("msg") + "";
        result.put("status", status);
        result.put("msg", message);
        if ("0".equals(status)) {
            Object msg = map.get("res");
            String params = JsonLibUtil.objectToJson(msg);
            Map res = JsonLibUtil.jsonToMap((String)params);
            result.put("orderid", res.get("orderid") + "");
        }
        return result;
    }

    public static Map<String, String> getConfirmParams(String response) throws UnsupportedEncodingException {
        HashMap<String, String> result = new HashMap<String, String>();
        Map map = JsonLibUtil.jsonToMap((String)response);
        String status = map.get("status") + "";
        String message = map.get("msg") + "";
        result.put("status", status);
        result.put("msg", message);
        Object msg = map.get("res");
        if (msg != null && !msg.toString().equals("null")) {
            String params = JsonLibUtil.objectToJson(msg);
            Map res = JsonLibUtil.jsonToMap((String)params);
            result.put("code", res.get("code") + "");
            Object obj = res.get("msg");
            if (obj != null && !obj.toString().equals("null")) {
                result.put("msg", obj.toString());
            }
        }
        return result;
    }

    public static boolean checkSign(String strToEncode, String key) {
        if (null == strToEncode || Strings.isNullOrEmpty((String)key)) {
            return false;
        }
        if (strToEncode.equals(key)) {
            return true;
        }
        logger.error("the key validate failed! the sign is {} , the signed is {}", (Object)strToEncode, (Object)key);
        return false;
    }
}

