/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.qishun;

import com.google.common.base.Strings;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.utils.MD5Utils;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.qishun.QishunChannelData;
import com.xunlei.channel.gateway.pay.channels.qishun.QishunChannelInfo;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QishunService
extends AbstractChannelService {
    private static final Logger logger = LoggerFactory.getLogger(QishunService.class);
    private static final String SUCCESS = "1";
    private static final String FAILED = "0";
    private static final String[][] sqlhandles = new String[][]{{"'", "`"}, {"<", ""}, {">", ""}};
    @Autowired
    private QishunChannelInfo qishunChannelInfo;

    public String returnNotify(HttpServletRequest request) {
        String merchantKey = "";
        String orderId = this.getFilterParameter(request, "orderid");
        String tag = this.getFilterParameter(request, "tag");
        String tradeNo = this.getFilterParameter(request, "trade_no");
        String validate = this.getFilterParameter(request, "validate");
        String faceValue = this.getFilterParameter(request, "face_value");
        try {
            float f = Float.parseFloat(faceValue);
            int num = (int)f;
            QishunChannelData qishunChannelData = new QishunChannelData();
            qishunChannelData.setTrandeNo(tradeNo);
            qishunChannelData.setRmb(num + "");
            if (QishunService.isEmpty(orderId) || QishunService.isEmpty(tag) || QishunService.isEmpty(tradeNo) || QishunService.isEmpty(validate)) {
                return FAILED;
            }
            PayOrder payOrder = this.getPayOrderByXunleiPayId(orderId);
            if (null == payOrder) {
                logger.error("cannot find payOrder with xunleiPayId:{},return success", (Object)tradeNo);
                return FAILED;
            }
            String productType = payOrder.getExtraJson();
            if (productType == null) {
                return FAILED;
            }
            if (productType.contains(FAILED)) {
                merchantKey = this.qishunChannelInfo.getThunderMerchantKey();
            } else if (productType.contains(SUCCESS)) {
                merchantKey = this.qishunChannelInfo.getVipMerchantKey();
            }
            String strToEncode = "orderid=" + orderId + "&tag=" + tag + "&trade_no=" + tradeNo;
            String newKey = MD5Utils.getMD5Str((String)(strToEncode + merchantKey));
            logger.debug("my key is {}, the old key is {}", (Object)newKey, (Object)validate);
            if (this.checkSign(newKey, validate)) {
                PayOrderOk payOrderOk = this.processPaySuccess(payOrder, qishunChannelData);
                return null != payOrderOk ? SUCCESS : FAILED;
            }
            return FAILED;
        }
        catch (Exception e) {
            logger.error("unknow error!" + e.getMessage());
            return FAILED;
        }
    }

    private String getFilterParameter(HttpServletRequest request, String name) {
        String s = QishunService.escapeSql(request.getParameter(name)).trim();
        logger.debug("\u8bf7\u6c42\u53c2\u6570" + name + "\u7684\u503c\u662f\uff1a" + s);
        return s;
    }

    private static final String escapeSql(String str) {
        if (str == null) {
            return "";
        }
        for (String[] ss : sqlhandles) {
            str = str.replaceAll(ss[0], ss[1]);
        }
        return str;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private boolean checkSign(String strToEncode, String key) {
        if (null == strToEncode || Strings.isNullOrEmpty((String)key)) {
            return false;
        }
        if (strToEncode.equals(key)) {
            return true;
        }
        logger.error("the key validate failed! the sign is {} , the signed is {}", (Object)strToEncode, (Object)key);
        return false;
    }
}

