/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.mycardmemberpay;

import com.google.common.base.Strings;
import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.pojo.AbstractOrder;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.gateway.common.pay.ChannelData;
import com.xunlei.channel.gateway.common.pojo.PayResult;
import com.xunlei.channel.gateway.common.utils.JsonUtils;
import com.xunlei.channel.gateway.common.utils.StringUtils;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.mycardmemberpay.MemberReturnMsgsParser;
import com.xunlei.channel.gateway.pay.channels.mycardmemberpay.MyCardMemberPayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.mycardmemberpay.MyCardMemberPayUtil;
import com.xunlei.channel.gateway.pay.result.FailPageResult;
import com.xunlei.channel.gateway.pay.result.PageResult;
import com.xunlei.xlcommons.util.http.HttpClientUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MyCardMemberPayNotifyService
extends AbstractChannelService {
    public static final Logger logger = LoggerFactory.getLogger(MyCardMemberPayNotifyService.class);
    @Autowired
    private MyCardMemberPayChannelInfo myCardMemberPayChannelInfo;
    @Autowired
    private PayOrderDAO payOrderDAO;

    public PageResult pageNotify(HttpServletRequest request) {
        logger.debug("enter the MyCardMemberPayNotifyService pageNotify,with params:{}", (Object)request.getParameterMap());
        String factorySeq = request.getParameter("FactorySeq");
        String msgNo = request.getParameter("ReturnMsgNo");
        String otp = request.getParameter("OTP");
        String authCode = request.getParameter("AuthCode");
        HashMap<String, String> extraMap = new HashMap<String, String>();
        extraMap.put("otp", otp);
        extraMap.put("auth_code", authCode);
        final String extraJson = JsonUtils.toJson(extraMap);
        if (StringUtils.isAnyNullOrEmpty((String[])new String[]{factorySeq, msgNo, otp, authCode})) {
            logger.error("any notify param is empty");
            return new FailPageResult("\u8ba2\u5355\u652f\u4ed8\u7ed3\u679c\u6682\u65f6\u65e0\u6cd5\u786e\u8ba4\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b");
        }
        PayOrder payOrder = this.getPayOrderByXunleiPayId(factorySeq);
        if (payOrder == null) {
            logger.error("cannot find payOrder with xunleiPayId:{},ignore", (Object)factorySeq);
            return new FailPageResult("\u53d1\u751f\u9519\u8bef\uff1a\u8ba2\u5355\u53f7[" + factorySeq + "]\u4e0d\u5b58\u5728\uff01");
        }
        if ("S".equals(payOrder.getStatus())) {
            logger.info("payOrder:{} status was success,do nothing and return", (Object)factorySeq);
            return this.generatePageUrlAndParams((AbstractOrder)payOrder, PayResult.SUCCESS.getValue(), 0);
        }
        if ("F".equals(payOrder.getStatus())) {
            logger.info("payOrder:{} status was failed,do nothing and return", (Object)factorySeq);
            return new FailPageResult("\u53d1\u751f\u9519\u8bef\uff1a\u672a\u77e5\u9519\u8bef");
        }
        Map payOrderExtraMap = (Map)JsonUtils.toObject((String)payOrder.getExtraJson(), Map.class);
        String dbAuthCode = (String)payOrderExtraMap.get("auth_code");
        if (!authCode.trim().equals(dbAuthCode)) {
            logger.error("xunleiPayId:{} login notify failed with invalid authCode:{} not equals payOrder authCode:{}", new Object[]{factorySeq, authCode, dbAuthCode});
            return new FailPageResult("\u53d1\u751f\u9519\u8bef\uff1a\u8fd4\u56de\u7684AuthCode\u4e0d\u4e00\u81f4");
        }
        payOrderExtraMap.put("otp", otp);
        try {
            this.payOrderDAO.updatePayOrderExtraJsonAndChannelId(payOrder.getXunleiPayId(), JsonUtils.toJson((Object)payOrderExtraMap), payOrder.getChannelOrderId());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        if (!msgNo.equals("1")) {
            String msg = MemberReturnMsgsParser.getLoginResultMsg(msgNo);
            if (Strings.isNullOrEmpty((String)msg)) {
                msg = "\u672a\u77e5\u9519\u8bef";
            }
            this.processPayFail(payOrder, msgNo, msg, payOrder.getChannelOrderId(), extraJson);
            logger.error("xunleiPayId:{} login failed with msgno:{}", (Object)factorySeq, (Object)msgNo);
            return new FailPageResult("\u53d1\u751f\u9519\u8bef\uff1a" + msg);
        }
        String memberCostlistRenderUrl = MyCardMemberPayUtil.getMemberCostListRenderUrl(this.myCardMemberPayChannelInfo.getCacheCostListRenderUrl(), authCode, otp);
        logger.info("orderid:{} with memberCostlistRenderUrl:{}", (Object)factorySeq, (Object)memberCostlistRenderUrl);
        try {
            String resp = HttpClientUtil.doGet((String)memberCostlistRenderUrl, new HashMap(), null);
            logger.info("cost list with resp:{}", (Object)resp);
            Document document = DocumentHelper.parseText((String)resp);
            Element root = document.getRootElement();
            String returnmsgno = root.elementText("ReturnMsgNo");
            logger.debug("MemberCostListReturnMsgno : {}", (Object)returnmsgno);
            if (!"1".equals(returnmsgno.trim())) {
                String msg = MemberReturnMsgsParser.getCostlistrenderResultMsg(returnmsgno.trim());
                if (Strings.isNullOrEmpty((String)msg)) {
                    msg = "\u672a\u77e5\u9519\u8bef";
                }
                this.processPayFail(payOrder, msgNo, msg, payOrder.getChannelOrderId(), extraJson);
                logger.error("xunleiPayId:{} login failed with msgno:{}", (Object)factorySeq, (Object)msgNo);
                return new FailPageResult("\u53d1\u751f\u9519\u8bef\uff1a" + msg);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return new FailPageResult("\u8ba2\u5355\u652f\u4ed8\u7ed3\u679c\u6682\u65f6\u65e0\u6cd5\u786e\u8ba4\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b");
        }
        logger.info("orderid:{} pay successed", (Object)factorySeq);
        final int orderAmt = payOrder.getOrderAmt();
        final String channelOrderId = payOrder.getChannelOrderId();
        final double PAY_RATE = this.myCardMemberPayChannelInfo.getCacheFeeRate();
        ChannelData channelData = new ChannelData(){

            public int getFareAmt() {
                return (int)((double)orderAmt * PAY_RATE);
            }

            public int getFactAmt() {
                return orderAmt - (int)((double)orderAmt * PAY_RATE);
            }

            public String getChannelOrderId() {
                return channelOrderId;
            }

            public String generateOkExtJson() {
                return extraJson;
            }
        };
        try {
            this.processPaySuccess(payOrder, channelData);
            return this.generatePageUrlAndParams((AbstractOrder)payOrder, PayResult.SUCCESS.getValue(), 0);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return new FailPageResult("\u8ba2\u5355\u652f\u4ed8\u7ed3\u679c\u6682\u65f6\u65e0\u6cd5\u786e\u8ba4\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b");
        }
    }
}

