/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.alipay.wapdirect;

import com.google.common.base.Strings;
import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.RedirectGetResult;
import com.xunlei.channel.gateway.pay.annotation.PayType;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelHandler;
import com.xunlei.channel.gateway.pay.channels.alipay.AlipaySignUtils;
import com.xunlei.channel.gateway.pay.channels.alipay.AlipayUtils;
import com.xunlei.channel.gateway.pay.channels.alipay.wapdirect.AlipayWapChannelInfo;
import com.xunlei.channel.gateway.pay.pojo.UnitedPayRequest;
import java.io.UnsupportedEncodingException;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@PayType(value="N3", desc="\u79fb\u52a8\u652f\u4ed8\u7f51\u9875\u5373\u65f6\u5230\u8d26\u63a5\u53e3|\u652f\u4ed8\u5b9d")
public class AlipayWapChannelHandler
extends AbstractChannelHandler<RedirectGetResult> {
    private static final String ALIPAY_GATEWAY = "https://mapi.alipay.com/gateway.do";
    public static final String INPUT_CHARSET = "utf-8";
    private static final String SERVICE = "alipay.wap.create.direct.pay.by.user";
    private static final Logger logger = LoggerFactory.getLogger(AlipayWapChannelHandler.class);
    @Autowired
    private AlipayWapChannelInfo alipayWapChannelInfo;

    @Override
    public RedirectGetResult generateChannelResult(UnitedPayRequest unitedPayRequest) {
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("service", SERVICE);
        paramMap.put("partner", this.alipayWapChannelInfo.getPartnerId());
        paramMap.put("_input_charset", INPUT_CHARSET);
        paramMap.put("notify_url", this.alipayWapChannelInfo.getNotifyUrl());
        paramMap.put("return_url", this.alipayWapChannelInfo.getPageUrl());
        paramMap.put("out_trade_no", unitedPayRequest.getXunleiPayId());
        paramMap.put("subject", unitedPayRequest.getProductName());
        paramMap.put("total_fee", "" + (double)unitedPayRequest.getOrderAmt() / 100.0);
        paramMap.put("seller_id", this.alipayWapChannelInfo.getPartnerId());
        paramMap.put("payment_type", "1");
        String token = unitedPayRequest.getExtraParam("token");
        if (!Strings.isNullOrEmpty((String)token)) {
            paramMap.put("extern_token", token);
        }
        String sign = AlipaySignUtils.doMD5Sign(paramMap, this.alipayWapChannelInfo.getPartnerKey(), "&", INPUT_CHARSET);
        paramMap.put("sign_type", "MD5");
        try {
            StringBuilder url = new StringBuilder(ALIPAY_GATEWAY).append("?").append(AlipayUtils.generateParams(paramMap, INPUT_CHARSET)).append("&sign=").append(sign);
            logger.info("AlipayWapUrl:{}", (Object)url.toString());
            return new RedirectGetResult(InterfaceReqResult.SUCCESS, "00", "", null, url.toString());
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new RedirectGetResult(InterfaceReqResult.FAIL, "99", "\u7a0b\u5e8f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", "pay_fail_page", null);
        }
    }
}

