/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.unicommobilepay;

import com.xunlei.channel.gateway.common.constants.InterfaceReqResult;
import com.xunlei.channel.gateway.common.result.DirectSDKPayResult;
import com.xunlei.channel.gateway.common.utils.MD5Utils;
import com.xunlei.channel.gateway.common.utils.StringUtils;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobilePayChannelData;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobilePayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobilePayException;
import com.xunlei.channel.gateway.pay.channels.unicommobilepay.UnicomMobileResponseCode;
import com.xunlei.xlcommons.util.MD5.Md5Encrypt;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnicomMobilePayUtil {
    public static final Logger logger = LoggerFactory.getLogger(UnicomMobilePayUtil.class);
    private static final String PHONE_NUMBER = "^[\\d]{11}$";
    private static final Pattern PHONE_NUMBER_PATTEN = Pattern.compile("^[\\d]{11}$");
    public static final String EXTRA_PARAM_PHONE = "phone";
    public static final String EXTRA_PARAM_OTHER1 = "other1";
    public static final String EXTRA_JSON_DEST = "dest";
    public static final String EXTRA_JSON_LINK_ID = "linkid";
    public static final String EXTRA_JSON_CMD = "cmd";
    public static final String EXTRA_JSON_SVCID = "svcid";
    public static final String EXTRA_JSON_UP_TIME = "uptime";
    public static final String EXTRA_JSON_FEE = "fee";
    public static final String EXTRA_JSON_SUCCESS_TIME = "successTime";
    public static final String SIGN_PARAMETER_NAME = "signMsg";
    public static final String STATU_O = "O";
    public static final String STATU_W = "W";
    public static final String STATU_Y = "Y";
    public static final String STATU_F = "F";
    public static final String STATU_U = "U";

    public static boolean isMobile(String number) {
        Matcher m = PHONE_NUMBER_PATTEN.matcher(number);
        return m.matches();
    }

    public static DirectSDKPayResult generatePayResult(InterfaceReqResult isSuccess, UnicomMobileResponseCode code, String errMsg) {
        return new DirectSDKPayResult(isSuccess, "10", code.getCode(), errMsg, null);
    }

    public static DirectSDKPayResult generatePayResult(UnicomMobilePayException e) {
        return new DirectSDKPayResult(InterfaceReqResult.FAIL, "10", e.getErrCode(), e.getMessage(), null);
    }

    public static Map<String, String> getRequestParamsMap(HttpServletRequest request, UnicomMobilePayChannelInfo channelInfo) throws UnicomMobilePayException {
        String linkId = request.getParameter("linkId");
        String mobile = request.getParameter("mobile");
        String time = request.getParameter("time");
        String status = request.getParameter("status");
        String auth = request.getParameter("auth");
        if (StringUtils.isAnyNullOrEmpty((String[])new String[]{linkId})) {
            throw new UnicomMobilePayException("linkId can not be null!", UnicomMobileResponseCode.RTN1.getCode());
        }
        if (StringUtils.isAnyNullOrEmpty((String[])new String[]{mobile})) {
            throw new UnicomMobilePayException("mobile can not be null!", UnicomMobileResponseCode.RTN1.getCode());
        }
        if (StringUtils.isAnyNullOrEmpty((String[])new String[]{time})) {
            throw new UnicomMobilePayException("time can not be null!", UnicomMobileResponseCode.RTN1.getCode());
        }
        if (StringUtils.isAnyNullOrEmpty((String[])new String[]{status})) {
            throw new UnicomMobilePayException("status can not be null!", UnicomMobileResponseCode.RTN1.getCode());
        }
        if (StringUtils.isAnyNullOrEmpty((String[])new String[]{auth})) {
            throw new UnicomMobilePayException("auth can not be null!", UnicomMobileResponseCode.RTN1.getCode());
        }
        if (!UnicomMobilePayUtil.isLTMobile(channelInfo, mobile)) {
            throw new UnicomMobilePayException("mobile:" + mobile + " is illegal!", UnicomMobileResponseCode.RTN8.getCode());
        }
        if ("DELIVRD".equals(status)) {
            throw new UnicomMobilePayException("status:" + status + " is success,can not remove Order!", UnicomMobileResponseCode.RTN6.getCode());
        }
        String authString = linkId + mobile + time + status + channelInfo.getConfigValue("authority_key");
        logger.info("=====ExtunionmobilepayRemoveOrderServlet authString is:{}=====", (Object)authString);
        String signMsg = MD5Utils.getMD5Str((String)authString, (String)"UTF-8");
        logger.info("remote auth is:{} local auth is:{}", new Object[]{auth, signMsg});
        if (signMsg == null || !signMsg.equals(auth)) {
            throw new UnicomMobilePayException("auth is illegal!", UnicomMobileResponseCode.RTN2.getCode());
        }
        try {
            time = UnicomMobilePayUtil.formatTime(time);
        }
        catch (ParseException e) {
            throw new UnicomMobilePayException("time:" + time + " is illegal!", UnicomMobileResponseCode.RTN6.getCode());
        }
        String clientIp = request.getHeader("X-Real-IP");
        if (clientIp == null) {
            clientIp = request.getRemoteAddr();
        }
        if (!UnicomMobilePayUtil.isInList(clientIp, channelInfo.getConfigValue("ip_white_list"))) {
            throw new UnicomMobilePayException("Ip:" + clientIp + " verify fail!", UnicomMobileResponseCode.RTN2.getCode());
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("linkId", linkId);
        paramsMap.put("mobile", mobile);
        paramsMap.put("time", time);
        paramsMap.put("status", status);
        logger.info("=====ExtunionmobilepayRemoveOrderServlet request params:{}=====", paramsMap);
        return paramsMap;
    }

    public static UnicomMobilePayChannelData getRequestBean(HttpServletRequest request) throws Exception {
        String Linkid = request.getParameter("Linkid");
        String Status = request.getParameter("Status");
        String Src = request.getParameter("Src");
        String Rtime = request.getParameter("RTime");
        String STime = request.getParameter("STime");
        String Spid = request.getParameter("Spid");
        String Dest = request.getParameter("Dest");
        String Cmd = request.getParameter("Cmd");
        String fee = request.getParameter("Fee");
        String Svcid = request.getParameter("Svcid");
        UnicomMobilePayChannelData result = new UnicomMobilePayChannelData();
        result.setLinkId(Linkid);
        result.setStatus(Status);
        result.setSrc(Src);
        result.setrTime(Rtime);
        result.setsTime(STime);
        result.setSpId(Spid);
        result.setDest(Dest);
        result.setCmd(Cmd);
        result.setFee(fee);
        result.setSvcId(Svcid);
        return result;
    }

    public static UnicomMobilePayChannelData checkLegalParam(HttpServletRequest request, UnicomMobilePayChannelInfo channelInfo) throws Exception {
        logger.debug("===========begin checkLegalParam==============");
        String Spid = request.getParameter("Spid");
        String Src = request.getParameter("Src");
        String Dest = request.getParameter("Dest");
        String Linkid = request.getParameter("Linkid");
        String Cmd = request.getParameter("Cmd");
        String fee = request.getParameter(EXTRA_JSON_FEE);
        String Time = request.getParameter("STime");
        String Svcid = request.getParameter("Svcid");
        String singMsgRemost = request.getParameter("Auth");
        String clientIp = request.getHeader("X-Real-IP");
        if (clientIp == null) {
            clientIp = request.getRemoteAddr();
        }
        if (!UnicomMobilePayUtil.isInList(clientIp, channelInfo.getConfigValue("ip_white_list"))) {
            throw new UnicomMobilePayException("Ip verify fail!", UnicomMobileResponseCode.RTN2.getCode());
        }
        String signMsgLocal = MD5Utils.getMD5Str((String)(Linkid + channelInfo.getConfigValue("authority_key") + Time), (String)"UTF-8");
        logger.info("request Auth is:{} local Auth is:{}", (Object)singMsgRemost, (Object)signMsgLocal);
        if (signMsgLocal == null || !signMsgLocal.equalsIgnoreCase(singMsgRemost)) {
            throw new UnicomMobilePayException("Auth verify fail!", UnicomMobileResponseCode.RTN2.getCode());
        }
        UnicomMobilePayChannelData channelData = new UnicomMobilePayChannelData();
        channelData.setSpId(Spid);
        channelData.setSrc(Src);
        channelData.setDest(Dest);
        channelData.setCmd(Cmd);
        channelData.setLinkId(Linkid);
        channelData.setFee(fee);
        channelData.setsTime(Time);
        channelData.setSvcId(Svcid);
        channelData.setAuth(singMsgRemost);
        return channelData;
    }

    public static void verifyCallBackRequestParam(HttpServletRequest request) throws UnicomMobilePayException {
        logger.debug("===========begin verifyRequestParam==============");
        String[] params = new String[]{"outTradeNo", "paymentcodesms"};
        for (int i = 0; i < params.length; ++i) {
            String paramName = params[i];
            String value = request.getParameter(paramName);
            if (!StringUtils.isAnyNullOrEmpty((String[])new String[]{value})) continue;
            throw new UnicomMobilePayException(UnicomMobileResponseCode.getIllegalMsg(paramName), UnicomMobileResponseCode.RTN1.getCode());
        }
    }

    public static void validateOrderParam(HttpServletRequest request, UnicomMobilePayChannelInfo channelInfo) throws Exception {
        logger.debug("===========begin validateParam==============");
        String[] params = new String[]{"Src", "Dest", "Linkid", "Cmd", EXTRA_JSON_FEE, "STime", "Svcid", "Auth"};
        for (int i = 0; i < params.length; ++i) {
            String paramName = params[i];
            String value = request.getParameter(paramName);
            if (!StringUtils.isAnyNullOrEmpty((String[])new String[]{value})) continue;
            throw new UnicomMobilePayException(UnicomMobileResponseCode.getIllegalMsg(paramName), UnicomMobileResponseCode.RTN1.getCode());
        }
        String mobile = request.getParameter("Src");
        if (!UnicomMobilePayUtil.isLTMobile(channelInfo, mobile)) {
            throw new UnicomMobilePayException(UnicomMobileResponseCode.getIllegalMsg("Src"), UnicomMobileResponseCode.RTN8.getCode());
        }
    }

    public static void verifyRequestParam(HttpServletRequest request, UnicomMobilePayChannelInfo channelInfo) throws Exception {
        logger.debug("===========begin verifyRequestParam==============");
        String[] params = new String[]{"Linkid", "Status", "Src", "RTime", "Auth", "Dest", "Cmd", "Fee", "Svcid", "STime"};
        for (int i = 0; i < params.length; ++i) {
            String paramName = params[i];
            String value = request.getParameter(paramName);
            if (!StringUtils.isAnyNullOrEmpty((String[])new String[]{value})) continue;
            throw new UnicomMobilePayException(UnicomMobileResponseCode.getIllegalMsg(paramName), UnicomMobileResponseCode.RTN1.getCode());
        }
        String mobile = request.getParameter("Src");
        if (!UnicomMobilePayUtil.isLTMobile(channelInfo, mobile)) {
            throw new UnicomMobilePayException(UnicomMobileResponseCode.getIllegalMsg("Src"), UnicomMobileResponseCode.RTN8.getCode());
        }
    }

    public static boolean isInList(String param, String listName, List<String> list) {
        if (null == list || list.size() <= 0) {
            logger.info("propertie named [{}] is null or dispose incorrectly!", (Object)listName);
            return false;
        }
        if (list.contains(param)) {
            logger.info("according to [{}],param[{}] was be found!", (Object)listName, (Object)param);
            return true;
        }
        logger.info("according to [{}],param[{}] was not found!", (Object)listName, (Object)param);
        return false;
    }

    public static boolean isInList(String param, String list) {
        String[] split;
        if (StringUtils.isAnyNullOrEmpty((String[])new String[]{list, param})) {
            return false;
        }
        for (String s : split = list.split(",")) {
            if (!param.equals(s.trim())) continue;
            return true;
        }
        return false;
    }

    public static String getAreaCodeFromMb(String mobile) {
        if (null == mobile || "".equals(mobile)) {
            return null;
        }
        return mobile.substring(3, 7);
    }

    public static boolean isLTMobile(UnicomMobilePayChannelInfo info, String number) {
        String[] split;
        if (!UnicomMobilePayUtil.isMobile(number)) {
            return false;
        }
        String configValue = info.getConfigValue("unicom_mobile_number_sections");
        for (String s : split = configValue.split(",")) {
            if (!number.startsWith(s.trim())) continue;
            return true;
        }
        return false;
    }

    public static String createToken(Map params, String secret) {
        String tr = "";
        Set set = params.keySet();
        for (String key : set) {
            tr = tr + key + "=" + params.get(key);
            tr = tr + "&";
        }
        tr = tr + "key=";
        tr = tr + secret;
        logger.info("before encrypt: {}", (Object)tr);
        String encode = Md5Encrypt.encode((String)tr, (String)"UTF-8");
        logger.info("after encrypt: {}", (Object)encode);
        return encode;
    }

    public static Map<String, String> json2map(String response) {
        HashMap<String, String> params = new HashMap<String, String>();
        response = response.replace("{", "");
        response = response.replace("}", "");
        String[] array = response.split(",");
        for (int i = 0; i < array.length; ++i) {
            String[] newArray = array[i].split(":");
            String key = newArray[0].replace("\"", "");
            key = key.replace("\n", "");
            key = key.replace("\t", "");
            key = key.trim();
            String value = newArray[1].replace("\"", "");
            value = value.replace("\n", "");
            value = value.replace("\t", "");
            value = value.trim();
            params.put(key, value);
        }
        logger.info(response + "\t change to " + params);
        return params;
    }

    public static String getBiznoBySvcid(String svcid, UnicomMobilePayChannelInfo channelInfo) {
        Map<String, String> biznoMap = UnicomMobilePayUtil.getMapFromProperties(channelInfo.getConfigValue("bizno_remote"), channelInfo.getConfigValue("bizno_local"));
        logger.debug("biznoMap: {}", biznoMap);
        if (null == biznoMap || biznoMap.size() <= 0) {
            logger.error("can not get bizno from properties,please check properties file!");
            return null;
        }
        return biznoMap.get(svcid);
    }

    private static Map<String, String> getMapFromProperties(String prop1, String prop2) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (!StringUtils.isAnyNullOrEmpty((String[])new String[]{prop1, prop2})) {
            String[] prop1s = prop1.split(",");
            String[] prop2s = prop2.split(",");
            if (prop2s.length == prop1s.length) {
                for (int i = 0; i < prop1s.length; ++i) {
                    result.put(prop1s[i], prop2s[i]);
                }
            } else {
                logger.error("Analysis properties fail,propertie [biznoRemote] must match [biznoLocal]!");
            }
        } else {
            logger.error("Analysis properties fail,propertie [biznoRemote] or [biznnoLocal] does not exist!");
        }
        return result;
    }

    public static String formatTime(String time) throws ParseException {
        SimpleDateFormat sp = new SimpleDateFormat("yyyyMMddHHmmss");
        SimpleDateFormat sp2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sp2.format(sp.parse(time));
    }
}

