/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.shengpay;

import com.google.common.base.Strings;
import com.xunlei.channel.db.pojo.AbstractOrder;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.gateway.common.pojo.PayResult;
import com.xunlei.channel.gateway.pay.channels.AbstractChannelService;
import com.xunlei.channel.gateway.pay.channels.shengpay.ShengpayChannelData;
import com.xunlei.channel.gateway.pay.channels.shengpay.ShengpayChannelInfo;
import com.xunlei.channel.gateway.pay.channels.shengpay.ShengpayUtils;
import com.xunlei.channel.gateway.pay.result.FailPageResult;
import com.xunlei.channel.gateway.pay.result.PageResult;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShengpayService
extends AbstractChannelService {
    private static final Logger logger = LoggerFactory.getLogger(ShengpayService.class);
    private static final String SUCCESS = "OK";
    private static final String FAILED = "Failed";
    @Autowired
    private ShengpayChannelInfo shengpayChannelInfo;

    public String returnNotify(HttpServletRequest request) {
        String result;
        String signMsg = request.getParameter("SignMsg");
        if (Strings.isNullOrEmpty((String)signMsg)) {
            logger.error("no signMsg,return error");
            return "Error";
        }
        ShengpayChannelData data = ShengpayUtils.parseNotifyData(request);
        logger.info("receive notify....orderId:{}", (Object)data.getOrderId());
        if (!this.checkSign(data, signMsg)) {
            return "signMsg is invalid";
        }
        try {
            result = this.dealNotify(data);
        }
        catch (Exception e) {
            logger.error("Exception occurs while invoking dealNotify method", (Throwable)e);
            result = "N";
        }
        logger.info("return result:{}", (Object)result);
        return result;
    }

    public PageResult pageNotify(HttpServletRequest request) {
        String signMsg = request.getParameter("SignMsg");
        ShengpayChannelData data = ShengpayUtils.parseNotifyData(request);
        logger.info("receive baidu-wallet pageNotify....orderId:{}", (Object)data.getOrderId());
        if (!this.checkSign(data, signMsg)) {
            logger.error("signMsg is invalid...orderNo:{}", (Object)data.getOrderId());
            return new FailPageResult("\u8ba2\u5355\u652f\u4ed8\u7ed3\u679c\u6682\u65f6\u65e0\u6cd5\u786e\u8ba4\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b");
        }
        if (!data.isSuccess()) {
            logger.warn("payResult:{},not success,do nothing and return", (Object)data.getTransStatus());
            return new FailPageResult("\u8ba2\u5355\u652f\u4ed8\u7ed3\u679c\u6682\u65f6\u65e0\u6cd5\u786e\u8ba4\uff0c\u8bf7\u7a0d\u7b49\u7247\u523b");
        }
        PayOrder payOrder = this.getPayOrderByXunleiPayId(data.getOrderId());
        if (null == payOrder) {
            logger.error("cannot find payOrder with xunleiPayId:{},ignore", (Object)data.getOrderId());
            return new FailPageResult("\u53d1\u751f\u9519\u8bef\uff1a\u6ca1\u6709\u627e\u5230\u8be5\u8fc5\u96f7\u652f\u4ed8\u53f7:" + data.getOrderId());
        }
        try {
            int orderAmt = (int)(100.0 * Double.parseDouble(data.getOrderAmount()));
            if (orderAmt != payOrder.getOrderAmt()) {
                logger.error("orderAmt mismatch...payOrder.orderAmt:{},shengpay.totalAmount:{}", (Object)payOrder.getOrderAmt(), (Object)orderAmt);
                return new FailPageResult("\u53d1\u751f\u9519\u8bef\uff1a\u8ba2\u5355\u91d1\u989d\u4e0d\u5339\u914d");
            }
            data.setOrderMoney(orderAmt);
        }
        catch (NumberFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new FailPageResult("\u53d1\u751f\u9519\u8bef\uff1a\u8ba2\u5355\u91d1\u989d\u4e0d\u5339\u914d");
        }
        if ("S".equals(payOrder.getStatus())) {
            logger.info("payOrder:{} status was success,do nothing and return", (Object)data.getOrderId());
            PayOrderOk payOrderOk = this.getPayOrderOkByXunleiPayId(payOrder.getXunleiPayId());
            if (null != payOrderOk) {
                return this.generatePageUrlAndParams((AbstractOrder)payOrderOk, PayResult.SUCCESS.getValue(), payOrderOk.getFareAmt());
            }
            logger.error("error,cannot find PayOrderOk...xunleiPayId:{}", (Object)payOrder.getXunleiPayId());
            return this.generatePageUrlAndParams((AbstractOrder)payOrder, PayResult.SUCCESS.getValue(), 0);
        }
        PayOrderOk payOrderOk = this.processPaySuccess(payOrder, data);
        return this.generatePageUrlAndParams((AbstractOrder)payOrderOk, PayResult.SUCCESS.getValue(), payOrderOk.getFareAmt());
    }

    private String dealNotify(ShengpayChannelData data) throws Exception {
        PayOrder payOrder = this.getPayOrderByXunleiPayId(data.getOrderId());
        if (null == payOrder) {
            logger.error("cannot find payOrder with xunleiPayId:{},return ", (Object)data.getOrderId());
            return FAILED;
        }
        try {
            int orderAmt = (int)(100.0 * Double.parseDouble(data.getOrderAmount()));
            if (orderAmt != payOrder.getOrderAmt()) {
                logger.error("orderAmt mismatch...payOrder.orderAmt:{},shengpay.totalAmount:{}", (Object)payOrder.getOrderAmt(), (Object)orderAmt);
                return FAILED;
            }
            data.setOrderMoney(orderAmt);
        }
        catch (NumberFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return FAILED;
        }
        if ("S".equals(payOrder.getStatus())) {
            logger.info("payOrder:{} status was success,do nothing and return");
            return SUCCESS;
        }
        PayOrderOk payOrderOk = this.processPaySuccess(payOrder, data);
        return null != payOrderOk ? SUCCESS : FAILED;
    }

    private boolean checkSign(ShengpayChannelData notifyData, String signMsg) {
        if (null == notifyData || Strings.isNullOrEmpty((String)signMsg)) {
            return false;
        }
        try {
            String notifySignMsg = ShengpayUtils.genShengpayRespSignMsg(notifyData, this.shengpayChannelInfo.getBizKey());
            if (!signMsg.equals(notifySignMsg)) {
                logger.info("order id:{},signMsg is:{},and notifySignMsg is:{} ", new Object[]{notifyData.getOrderId(), signMsg, notifySignMsg});
                return false;
            }
            return true;
        }
        catch (UnsupportedEncodingException e) {
            logger.error("order id:{}, check sign with exception:{}", (Object)notifyData.getOrderId(), (Object)e.getMessage());
            return false;
        }
    }
}

