/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.gateway.pay.channels.mycardbillingpay;

import com.xunlei.channel.gateway.pay.channels.mycardbillingpay.BillingServiceAuthRequest;
import com.xunlei.channel.gateway.pay.channels.mycardbillingpay.BillingServiceAuthResponse;
import com.xunlei.xlcommons.util.http.HttpClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyCardBillingPayUtil {
    private static final Logger logger = LoggerFactory.getLogger(MyCardBillingPayUtil.class);

    public static BillingServiceAuthResponse getBillingServiceAuthResult(String authServiceUrl, BillingServiceAuthRequest auth) throws Exception {
        String reqUrl = String.format(authServiceUrl, auth.getServiceId(), auth.getTradeSeq(), auth.getPaymentAmount());
        logger.info("auth req url:{}", (Object)reqUrl);
        String resp = HttpClientUtil.doGet((String)reqUrl, new HashMap(), null);
        logger.info("auth resp:{}", (Object)resp);
        Document dom = DocumentHelper.parseText((String)resp);
        Element element = dom.getRootElement();
        String[] respValue = element.getStringValue().split("\\|");
        if (respValue.length >= 4) {
            return new BillingServiceAuthResponse(respValue[0], respValue[1], respValue[2], respValue[3]);
        }
        return new BillingServiceAuthResponse(respValue[0], respValue[1], null, null);
    }

    public static String getBillingUrl(String billingUrl, String authCode) {
        return String.format(billingUrl, authCode);
    }

    public static List<String> queryOrderResult(String queryUrl, String authCode) {
        String url = String.format(queryUrl, authCode);
        logger.info("query url:{}", (Object)url);
        ArrayList<String> returnList = new ArrayList<String>();
        try {
            String queryResp = HttpClientUtil.doGet((String)url, new HashMap(), null);
            logger.info("query resp:{}", (Object)queryResp);
            Document dom = DocumentHelper.parseText((String)queryResp);
            Element element = dom.getRootElement();
            String[] respValue = element.getStringValue().split("\\|");
            for (int i = 0; i < respValue.length; ++i) {
                returnList.add(respValue[i]);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return returnList;
    }

    public static List<String> paymentConfirm(String confirmUrl, String cPMemberId, String authCode) {
        String url = String.format(confirmUrl, cPMemberId, authCode);
        logger.info("paymentconfirm url:{}", (Object)url);
        ArrayList<String> returnList = new ArrayList<String>();
        try {
            String queryResp = HttpClientUtil.doGet((String)url, new HashMap(), null);
            logger.info("query resp:{}", (Object)queryResp);
            Document dom = DocumentHelper.parseText((String)queryResp);
            Element element = dom.getRootElement();
            String[] respValue = element.getStringValue().split("\\|");
            for (int i = 0; i < respValue.length; ++i) {
                returnList.add(respValue[i]);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return returnList;
    }

    public static List<Map<String, String>> getXmlResponse(String xmlMessage) throws DocumentException {
        Document document = DocumentHelper.parseText((String)xmlMessage);
        Element rootElement = document.getRootElement();
        Element records = rootElement.element("Records");
        Iterator iterator = records.elementIterator();
        LinkedList<Map<String, String>> recordsList = new LinkedList<Map<String, String>>();
        HashMap<String, String> recordMap = new HashMap<String, String>();
        while (iterator.hasNext()) {
            Element record = (Element)iterator.next();
            String returnMsgNo = record.elementText("ReturnMsgNo");
            String returnMsg = record.elementText("ReturnMsg");
            String tradeSeq = record.elementText("TradeSeq");
            recordMap.put("ReturnMsgNo", returnMsgNo);
            recordMap.put("ReturnMsg", returnMsg);
            recordMap.put("TradeSeq", tradeSeq);
            recordsList.add(recordMap);
        }
        return recordsList;
    }
}

